/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.lease;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.Availability;
import io.rsocket.frame.LeaseFrameCodec;
import io.rsocket.lease.Lease;
import io.rsocket.lease.LeaseImpl;
import io.rsocket.lease.LeaseStats;
import io.rsocket.lease.MissingLeaseException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.publisher.Flux;
import reactor.util.annotation.Nullable;

public interface ResponderLeaseHandler
extends Availability {
    public static final ResponderLeaseHandler None = new ResponderLeaseHandler(){

        @Override
        public boolean useLease() {
            return true;
        }

        @Override
        public Exception leaseError() {
            throw new AssertionError((Object)"Error not possible with NOOP leases handler");
        }

        @Override
        public Disposable send(Consumer<ByteBuf> leaseFrameSender) {
            return Disposables.disposed();
        }

        @Override
        public double availability() {
            return 1.0;
        }
    };

    public boolean useLease();

    public Exception leaseError();

    public Disposable send(Consumer<ByteBuf> var1);

    public static final class Impl<T extends LeaseStats>
    implements ResponderLeaseHandler {
        private volatile LeaseImpl currentLease = LeaseImpl.empty();
        private final String tag;
        private final ByteBufAllocator allocator;
        private final Function<Optional<T>, Flux<Lease>> leaseSender;
        private final Optional<T> leaseStatsOption;
        private final T leaseStats;

        public Impl(String tag, ByteBufAllocator allocator, Function<Optional<T>, Flux<Lease>> leaseSender, Optional<T> leaseStatsOption) {
            this.tag = tag;
            this.allocator = allocator;
            this.leaseSender = leaseSender;
            this.leaseStatsOption = leaseStatsOption;
            this.leaseStats = leaseStatsOption.orElse(null);
        }

        @Override
        public boolean useLease() {
            boolean success = this.currentLease.use();
            this.onUseEvent(success, this.leaseStats);
            return success;
        }

        @Override
        public Exception leaseError() {
            LeaseImpl l = this.currentLease;
            String t = this.tag;
            if (!l.isValid()) {
                return new MissingLeaseException(l, t);
            }
            return new MissingLeaseException(t);
        }

        @Override
        public Disposable send(Consumer<ByteBuf> leaseFrameSender) {
            return this.leaseSender.apply(this.leaseStatsOption).doOnTerminate(this::onTerminateEvent).subscribe(lease -> {
                this.currentLease = Impl.create(lease);
                leaseFrameSender.accept(this.createLeaseFrame((Lease)lease));
            });
        }

        @Override
        public double availability() {
            return this.currentLease.availability();
        }

        private ByteBuf createLeaseFrame(Lease lease) {
            return LeaseFrameCodec.encode(this.allocator, lease.getTimeToLiveMillis(), lease.getAllowedRequests(), lease.getMetadata());
        }

        private void onTerminateEvent() {
            T ls = this.leaseStats;
            if (ls != null) {
                ls.onEvent(LeaseStats.EventType.TERMINATE);
            }
        }

        private void onUseEvent(boolean success, @Nullable T ls) {
            if (ls != null) {
                LeaseStats.EventType eventType = success ? LeaseStats.EventType.ACCEPT : LeaseStats.EventType.REJECT;
                ls.onEvent(eventType);
            }
        }

        private static LeaseImpl create(Lease lease) {
            if (lease instanceof LeaseImpl) {
                return (LeaseImpl)lease;
            }
            return LeaseImpl.create(lease.getTimeToLiveMillis(), lease.getAllowedRequests(), lease.getMetadata());
        }
    }
}

