/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.rsocket.DuplexConnection;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.SocketAcceptor;
import io.rsocket.core.DefaultConnectionSetupPayload;
import io.rsocket.core.Invalidatable;
import io.rsocket.core.PayloadValidationUtils;
import io.rsocket.core.RSocketRequester;
import io.rsocket.core.RSocketResponder;
import io.rsocket.core.ReconnectMono;
import io.rsocket.core.Resume;
import io.rsocket.core.StreamIdSupplier;
import io.rsocket.fragmentation.FragmentationDuplexConnection;
import io.rsocket.fragmentation.ReassemblyDuplexConnection;
import io.rsocket.frame.SetupFrameCodec;
import io.rsocket.frame.decoder.PayloadDecoder;
import io.rsocket.internal.ClientServerInputMultiplexer;
import io.rsocket.keepalive.KeepAliveHandler;
import io.rsocket.lease.LeaseStats;
import io.rsocket.lease.Leases;
import io.rsocket.lease.RequesterLeaseHandler;
import io.rsocket.lease.ResponderLeaseHandler;
import io.rsocket.plugins.InitializingInterceptorRegistry;
import io.rsocket.plugins.InterceptorRegistry;
import io.rsocket.resume.ClientRSocketSession;
import io.rsocket.transport.ClientTransport;
import io.rsocket.util.DefaultPayload;
import io.rsocket.util.EmptyPayload;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.annotation.Nullable;
import reactor.util.function.Tuples;
import reactor.util.retry.Retry;

public class RSocketConnector {
    private static final String CLIENT_TAG = "client";
    private static final BiConsumer<RSocket, Invalidatable> INVALIDATE_FUNCTION = (r, i) -> r.onClose().subscribe(null, __ -> i.invalidate(), i::invalidate);
    private Mono<Payload> setupPayloadMono = Mono.empty();
    private String metadataMimeType = "application/binary";
    private String dataMimeType = "application/binary";
    private Duration keepAliveInterval = Duration.ofSeconds(20L);
    private Duration keepAliveMaxLifeTime = Duration.ofSeconds(90L);
    @Nullable
    private SocketAcceptor acceptor;
    private InitializingInterceptorRegistry interceptors = new InitializingInterceptorRegistry();
    private Retry retrySpec;
    private Resume resume;
    private Supplier<Leases<?>> leasesSupplier;
    private int mtu = 0;
    private int maxInboundPayloadSize = Integer.MAX_VALUE;
    private PayloadDecoder payloadDecoder = PayloadDecoder.DEFAULT;

    private RSocketConnector() {
    }

    public static RSocketConnector create() {
        return new RSocketConnector();
    }

    public static Mono<RSocket> connectWith(ClientTransport transport) {
        return RSocketConnector.create().connect(() -> transport);
    }

    public RSocketConnector setupPayload(Mono<Payload> setupPayloadMono) {
        this.setupPayloadMono = setupPayloadMono;
        return this;
    }

    public RSocketConnector setupPayload(Payload payload) {
        if (payload instanceof DefaultPayload) {
            this.setupPayloadMono = Mono.just((Object)payload);
        } else {
            this.setupPayloadMono = Mono.just((Object)DefaultPayload.create(Objects.requireNonNull(payload)));
            payload.release();
        }
        return this;
    }

    public RSocketConnector dataMimeType(String dataMimeType) {
        this.dataMimeType = Objects.requireNonNull(dataMimeType);
        return this;
    }

    public RSocketConnector metadataMimeType(String metadataMimeType) {
        this.metadataMimeType = Objects.requireNonNull(metadataMimeType);
        return this;
    }

    public RSocketConnector keepAlive(Duration interval, Duration maxLifeTime) {
        if (!interval.negated().isNegative()) {
            throw new IllegalArgumentException("`interval` for keepAlive must be > 0");
        }
        if (!maxLifeTime.negated().isNegative()) {
            throw new IllegalArgumentException("`maxLifeTime` for keepAlive must be > 0");
        }
        this.keepAliveInterval = interval;
        this.keepAliveMaxLifeTime = maxLifeTime;
        return this;
    }

    public RSocketConnector interceptors(Consumer<InterceptorRegistry> configurer) {
        configurer.accept(this.interceptors);
        return this;
    }

    public RSocketConnector acceptor(SocketAcceptor acceptor) {
        this.acceptor = acceptor;
        return this;
    }

    public RSocketConnector reconnect(Retry retry) {
        this.retrySpec = Objects.requireNonNull(retry);
        return this;
    }

    public RSocketConnector resume(Resume resume) {
        this.resume = resume;
        return this;
    }

    public RSocketConnector lease(Supplier<Leases<? extends LeaseStats>> supplier) {
        this.leasesSupplier = supplier;
        return this;
    }

    public RSocketConnector maxInboundPayloadSize(int maxInboundPayloadSize) {
        this.maxInboundPayloadSize = ReassemblyDuplexConnection.assertInboundPayloadSize(maxInboundPayloadSize);
        return this;
    }

    public RSocketConnector fragment(int mtu) {
        this.mtu = FragmentationDuplexConnection.assertMtu(mtu);
        return this;
    }

    public RSocketConnector payloadDecoder(PayloadDecoder decoder) {
        Objects.requireNonNull(decoder);
        this.payloadDecoder = decoder;
        return this;
    }

    public Mono<RSocket> connect(ClientTransport transport) {
        return this.connect(() -> transport);
    }

    public Mono<RSocket> connect(Supplier<ClientTransport> transportSupplier) {
        return (Mono)Mono.fromSupplier(transportSupplier).flatMap(ct -> {
            int maxFrameLength = ct.maxFrameLength();
            Mono connectionMono = Mono.fromCallable(() -> {
                PayloadValidationUtils.assertValidateSetup(maxFrameLength, this.maxInboundPayloadSize, this.mtu);
                return ct;
            }).flatMap(transport -> transport.connect()).map(connection -> this.mtu > 0 ? new FragmentationDuplexConnection((DuplexConnection)connection, this.mtu, this.maxInboundPayloadSize, CLIENT_TAG) : new ReassemblyDuplexConnection((DuplexConnection)connection, this.maxInboundPayloadSize));
            return connectionMono.flatMap(connection -> this.setupPayloadMono.defaultIfEmpty((Object)EmptyPayload.INSTANCE).map(setupPayload -> Tuples.of((Object)connection, (Object)setupPayload)).doOnError(ex -> connection.dispose()).doOnCancel(() -> ((DuplexConnection)connection).dispose())).flatMap(tuple -> {
                DuplexConnection wrappedConnection;
                KeepAliveHandler keepAliveHandler;
                ByteBuf resumeToken;
                DuplexConnection connection = (DuplexConnection)tuple.getT1();
                Payload setupPayload = (Payload)tuple.getT2();
                if (this.resume != null) {
                    resumeToken = this.resume.getTokenSupplier().get();
                    ClientRSocketSession session = new ClientRSocketSession(connection, this.resume.getSessionDuration(), this.resume.getRetry(), this.resume.getStoreFactory(CLIENT_TAG).apply((ByteBuf)resumeToken), this.resume.getStreamTimeout(), this.resume.isCleanupStoreOnKeepAlive()).continueWith((Mono<DuplexConnection>)connectionMono).resumeToken(resumeToken);
                    keepAliveHandler = new KeepAliveHandler.ResumableKeepAliveHandler(session.resumableConnection());
                    wrappedConnection = session.resumableConnection();
                } else {
                    resumeToken = Unpooled.EMPTY_BUFFER;
                    keepAliveHandler = new KeepAliveHandler.DefaultKeepAliveHandler(connection);
                    wrappedConnection = connection;
                }
                ClientServerInputMultiplexer multiplexer = new ClientServerInputMultiplexer(wrappedConnection, this.interceptors, true);
                boolean leaseEnabled = this.leasesSupplier != null;
                Leases<?> leases = leaseEnabled ? this.leasesSupplier.get() : null;
                RequesterLeaseHandler requesterLeaseHandler = leaseEnabled ? new RequesterLeaseHandler.Impl(CLIENT_TAG, leases.receiver()) : RequesterLeaseHandler.None;
                RSocketRequester rSocketRequester = new RSocketRequester(multiplexer.asClientConnection(), this.payloadDecoder, StreamIdSupplier.clientSupplier(), this.mtu, maxFrameLength, (int)this.keepAliveInterval.toMillis(), (int)this.keepAliveMaxLifeTime.toMillis(), keepAliveHandler, requesterLeaseHandler, Schedulers.single((Scheduler)Schedulers.parallel()));
                RSocket wrappedRSocketRequester = this.interceptors.initRequester(rSocketRequester);
                ByteBuf setupFrame = SetupFrameCodec.encode(wrappedConnection.alloc(), leaseEnabled, (int)this.keepAliveInterval.toMillis(), (int)this.keepAliveMaxLifeTime.toMillis(), resumeToken, this.metadataMimeType, this.dataMimeType, setupPayload);
                SocketAcceptor acceptor = this.acceptor != null ? this.acceptor : SocketAcceptor.with(new RSocket(){});
                DefaultConnectionSetupPayload setup = new DefaultConnectionSetupPayload(setupFrame);
                return this.interceptors.initSocketAcceptor(acceptor).accept(setup, wrappedRSocketRequester).flatMap(rSocketHandler -> {
                    RSocket wrappedRSocketHandler = this.interceptors.initResponder((RSocket)rSocketHandler);
                    ResponderLeaseHandler responderLeaseHandler = leaseEnabled ? new ResponderLeaseHandler.Impl<LeaseStats>(CLIENT_TAG, wrappedConnection.alloc(), leases.sender(), leases.stats()) : ResponderLeaseHandler.None;
                    RSocketResponder rSocketResponder = new RSocketResponder(multiplexer.asServerConnection(), wrappedRSocketHandler, this.payloadDecoder, responderLeaseHandler, this.mtu, maxFrameLength);
                    return wrappedConnection.sendOne(setupFrame.retain()).thenReturn((Object)wrappedRSocketRequester);
                }).doFinally(signalType -> setup.release());
            });
        }).as(source -> {
            if (this.retrySpec != null) {
                return new ReconnectMono<RSocket>(source.retryWhen(this.retrySpec), Disposable::dispose, INVALIDATE_FUNCTION);
            }
            return source;
        });
    }
}

