/*
 * Decompiled with CFR 0.152.
 */
package reactor.blockhound.shaded.net.bytebuddy;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import reactor.blockhound.shaded.net.bytebuddy.build.CachedReturnPlugin;
import reactor.blockhound.shaded.net.bytebuddy.utility.CompoundList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeCache<T>
extends ReferenceQueue<ClassLoader> {
    private static final Class<?> NOT_FOUND = null;
    protected final Sort sort;
    protected final ConcurrentMap<StorageKey, ConcurrentMap<T, Reference<Class<?>>>> cache;

    public TypeCache(Sort sort) {
        this.sort = sort;
        this.cache = new ConcurrentHashMap();
    }

    @SuppressFBWarnings(value={"GC_UNRELATED_TYPES"}, justification="Cross-comparison is intended")
    public Class<?> find(ClassLoader classLoader, T key) {
        ConcurrentMap storage = (ConcurrentMap)this.cache.get(new LookupKey(classLoader));
        if (storage == null) {
            return NOT_FOUND;
        }
        Reference reference = (Reference)storage.get(key);
        if (reference == null) {
            return NOT_FOUND;
        }
        return (Class)reference.get();
    }

    @SuppressFBWarnings(value={"GC_UNRELATED_TYPES"}, justification="Cross-comparison is intended")
    public Class<?> insert(ClassLoader classLoader, T key, Class<?> type) {
        ConcurrentMap previous;
        ConcurrentMap<T, Reference<Class<?>>> storage = (ConcurrentHashMap)this.cache.get(new LookupKey(classLoader));
        if (storage == null && (previous = (ConcurrentMap)this.cache.putIfAbsent(new StorageKey(classLoader, this), storage = new ConcurrentHashMap())) != null) {
            storage = previous;
        }
        Reference<Class<?>> reference = this.sort.wrap(type);
        Reference<Class<?>> previous2 = storage.putIfAbsent(key, reference);
        while (previous2 != null) {
            Class<?> previousType = previous2.get();
            if (previousType != null) {
                return previousType;
            }
            if (storage.remove(key, previous2)) {
                previous2 = storage.putIfAbsent(key, reference);
                continue;
            }
            previous2 = (Reference<Class<?>>)storage.get(key);
            if (previous2 != null) continue;
            previous2 = storage.putIfAbsent(key, reference);
        }
        return type;
    }

    public Class<?> findOrInsert(ClassLoader classLoader, T key, Callable<Class<?>> lazy) {
        Class<?> type = this.find(classLoader, key);
        if (type != null) {
            return type;
        }
        try {
            return this.insert(classLoader, key, lazy.call());
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Could not create type", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> findOrInsert(ClassLoader classLoader, T key, Callable<Class<?>> lazy, Object monitor) {
        Class<?> type = this.find(classLoader, key);
        if (type != null) {
            return type;
        }
        Object object = monitor;
        synchronized (object) {
            return this.findOrInsert(classLoader, key, lazy);
        }
    }

    public void expungeStaleEntries() {
        Reference reference;
        while ((reference = this.poll()) != null) {
            this.cache.remove(reference);
        }
    }

    public void clear() {
        this.cache.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleKey {
        private final Set<String> types = new HashSet<String>();
        private transient /* synthetic */ int hashCode;

        public SimpleKey(Class<?> type, Class<?> ... additionalType) {
            this(type, Arrays.asList(additionalType));
        }

        public SimpleKey(Class<?> type, Collection<? extends Class<?>> additionalTypes) {
            this(CompoundList.of(type, new ArrayList(additionalTypes)));
        }

        public SimpleKey(Collection<? extends Class<?>> types) {
            for (Class<?> type : types) {
                this.types.add(type.getName());
            }
        }

        @CachedReturnPlugin.Enhance(value="hashCode")
        public int hashCode() {
            int n;
            int n2;
            int n3 = this.hashCode;
            if (n3 != 0) {
                n2 = 0;
            } else {
                SimpleKey simpleKey = this;
                n2 = n = simpleKey.types.hashCode();
            }
            if (n == 0) {
                n = this.hashCode;
            } else {
                this.hashCode = n;
            }
            return n;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            SimpleKey simpleKey = (SimpleKey)other;
            return this.types.equals(simpleKey.types);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WithInlineExpunction<S>
    extends TypeCache<S> {
        public WithInlineExpunction(Sort sort) {
            super(sort);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Class<?> find(ClassLoader classLoader, S key) {
            try {
                Class<?> clazz = super.find(classLoader, key);
                return clazz;
            }
            finally {
                this.expungeStaleEntries();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Class<?> insert(ClassLoader classLoader, S key, Class<?> type) {
            try {
                Class<?> clazz = super.insert(classLoader, key, type);
                return clazz;
            }
            finally {
                this.expungeStaleEntries();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Class<?> findOrInsert(ClassLoader classLoader, S key, Callable<Class<?>> builder) {
            try {
                Class<?> clazz = super.findOrInsert(classLoader, key, builder);
                return clazz;
            }
            finally {
                this.expungeStaleEntries();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Class<?> findOrInsert(ClassLoader classLoader, S key, Callable<Class<?>> builder, Object monitor) {
            try {
                Class<?> clazz = super.findOrInsert(classLoader, key, builder, monitor);
                return clazz;
            }
            finally {
                this.expungeStaleEntries();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class StorageKey
    extends WeakReference<ClassLoader> {
        private final int hashCode;

        protected StorageKey(ClassLoader classLoader, ReferenceQueue<? super ClassLoader> referenceQueue) {
            super(classLoader, referenceQueue);
            this.hashCode = System.identityHashCode(classLoader);
        }

        public int hashCode() {
            return this.hashCode;
        }

        @SuppressFBWarnings(value={"EQ_CHECK_FOR_OPERAND_NOT_COMPATIBLE_WITH_THIS"}, justification="Cross-comparison is intended")
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof LookupKey) {
                LookupKey lookupKey = (LookupKey)other;
                return this.hashCode == lookupKey.hashCode && this.get() == lookupKey.classLoader;
            }
            if (other instanceof StorageKey) {
                StorageKey storageKey = (StorageKey)other;
                return this.hashCode == storageKey.hashCode && this.get() == storageKey.get();
            }
            return false;
        }
    }

    protected static class LookupKey {
        private final ClassLoader classLoader;
        private final int hashCode;

        protected LookupKey(ClassLoader classLoader) {
            this.classLoader = classLoader;
            this.hashCode = System.identityHashCode(classLoader);
        }

        public int hashCode() {
            return this.hashCode;
        }

        @SuppressFBWarnings(value={"EQ_CHECK_FOR_OPERAND_NOT_COMPATIBLE_WITH_THIS"}, justification="Cross-comparison is intended")
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof LookupKey) {
                return this.classLoader == ((LookupKey)other).classLoader;
            }
            if (other instanceof StorageKey) {
                StorageKey storageKey = (StorageKey)other;
                return this.hashCode == storageKey.hashCode && this.classLoader == storageKey.get();
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sort {
        WEAK{

            @Override
            protected Reference<Class<?>> wrap(Class<?> type) {
                return new WeakReference(type);
            }
        }
        ,
        SOFT{

            @Override
            protected Reference<Class<?>> wrap(Class<?> type) {
                return new SoftReference(type);
            }
        };


        protected abstract Reference<Class<?>> wrap(Class<?> var1);
    }
}

