/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.channel;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.netty.buffer.ByteBufAllocatorMetric;
import io.netty.buffer.PooledByteBufAllocatorMetric;
import io.netty.util.internal.PlatformDependent;
import java.util.concurrent.ConcurrentMap;

final class ByteBufAllocatorMetrics {
    static final ByteBufAllocatorMetrics INSTANCE = new ByteBufAllocatorMetrics();
    final ConcurrentMap<String, ByteBufAllocatorMetric> cache = PlatformDependent.newConcurrentHashMap();
    static final MeterRegistry registry = Metrics.globalRegistry;
    static final String NAME = "reactor.netty.%s.bytebuf.allocator";
    static final String USED_HEAP_MEMORY = ".used.heap.memory";
    static final String USED_DIRECT_MEMORY = ".used.direct.memory";
    static final String HEAP_ARENAS = ".heap.arenas";
    static final String DIRECT_ARENAS = ".direct.arenas";
    static final String THREAD_LOCAL_CACHES = ".threadlocal.caches";
    static final String TINY_CACHE_SIZE = ".tiny.cache.size";
    static final String SMALL_CACHE_SIZE = ".small.cache.size";
    static final String NORMAL_CACHE_SIZE = ".normal.cache.size";
    static final String CHUNK_SIZE = ".chunk.size";
    static final String ID = "id";

    private ByteBufAllocatorMetrics() {
    }

    void registerMetrics(String allocName, ByteBufAllocatorMetric metrics) {
        this.cache.computeIfAbsent(metrics.hashCode() + "", key -> {
            String name = String.format(NAME, allocName);
            Gauge.builder((String)(name + USED_HEAP_MEMORY), (Object)metrics, ByteBufAllocatorMetric::usedHeapMemory).description("The number of the bytes of the heap memory.").tags(new String[]{ID, key}).register(registry);
            Gauge.builder((String)(name + USED_DIRECT_MEMORY), (Object)metrics, ByteBufAllocatorMetric::usedDirectMemory).description("The number of the bytes of the direct memory.").tags(new String[]{ID, key}).register(registry);
            if (metrics instanceof PooledByteBufAllocatorMetric) {
                PooledByteBufAllocatorMetric pooledMetrics = (PooledByteBufAllocatorMetric)metrics;
                Gauge.builder((String)(name + HEAP_ARENAS), (Object)pooledMetrics, PooledByteBufAllocatorMetric::numHeapArenas).description("The number of heap arenas.").tags(new String[]{ID, key}).register(registry);
                Gauge.builder((String)(name + DIRECT_ARENAS), (Object)pooledMetrics, PooledByteBufAllocatorMetric::numDirectArenas).description("The number of direct arenas.").tags(new String[]{ID, key}).register(registry);
                Gauge.builder((String)(name + THREAD_LOCAL_CACHES), (Object)pooledMetrics, PooledByteBufAllocatorMetric::numThreadLocalCaches).description("The number of thread local caches.").tags(new String[]{ID, key}).register(registry);
                Gauge.builder((String)(name + TINY_CACHE_SIZE), (Object)pooledMetrics, PooledByteBufAllocatorMetric::tinyCacheSize).description("The size of the tiny cache.").tags(new String[]{ID, key}).register(registry);
                Gauge.builder((String)(name + SMALL_CACHE_SIZE), (Object)pooledMetrics, PooledByteBufAllocatorMetric::smallCacheSize).description("The size of the small cache.").tags(new String[]{ID, key}).register(registry);
                Gauge.builder((String)(name + NORMAL_CACHE_SIZE), (Object)pooledMetrics, PooledByteBufAllocatorMetric::normalCacheSize).description("The size of the normal cache.").tags(new String[]{ID, key}).register(registry);
                Gauge.builder((String)(name + CHUNK_SIZE), (Object)pooledMetrics, PooledByteBufAllocatorMetric::chunkSize).description("The chunk size for an arena.").tags(new String[]{ID, key}).register(registry);
            }
            return metrics;
        });
    }
}

