/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.channel;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufAllocatorMetric;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.logging.LoggingHandler;
import io.netty.resolver.AddressResolverGroup;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import reactor.core.Exceptions;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.AddressResolverGroupMetrics;
import reactor.netty.channel.ByteBufAllocatorMetrics;
import reactor.netty.channel.ChannelMetricsHandler;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.netty.channel.ChannelOperations;
import reactor.util.Logger;
import reactor.util.Loggers;

public abstract class BootstrapHandlers {
    static final boolean SSL_CLIENT_DEBUG = Boolean.parseBoolean(System.getProperty("reactor.netty.tcp.ssl.client.debug", "false"));
    static final boolean SSL_SERVER_DEBUG = Boolean.parseBoolean(System.getProperty("reactor.netty.tcp.ssl.server.debug", "false"));
    static final Logger log = Loggers.getLogger(BootstrapHandlers.class);
    static final ChannelOption<ChannelOperations.OnSetup> OPS_OPTION = ChannelOption.valueOf((String)"ops_factory");
    static final ChannelOption<ConnectionObserver> OBSERVER_OPTION = ChannelOption.valueOf((String)"connectionObserver");

    public static void finalizeHandler(ServerBootstrap b, ChannelOperations.OnSetup opsFactory, ConnectionObserver childListener) {
        Objects.requireNonNull(b, "bootstrap");
        Objects.requireNonNull(opsFactory, "ops");
        Objects.requireNonNull(childListener, "childListener");
        BootstrapPipelineHandler pipeline = null;
        ChannelHandler handler = b.config().childHandler();
        if (handler instanceof BootstrapPipelineHandler) {
            pipeline = (BootstrapPipelineHandler)handler;
        }
        b.childHandler((ChannelHandler)new BootstrapInitializerHandler(pipeline, opsFactory, childListener));
    }

    public static void finalizeHandler(Bootstrap b, ChannelOperations.OnSetup opsFactory, ConnectionObserver listener) {
        Objects.requireNonNull(b, "bootstrap");
        Objects.requireNonNull(listener, "listener");
        BootstrapPipelineHandler pipeline = null;
        ChannelHandler handler = b.config().handler();
        if (handler instanceof BootstrapPipelineHandler) {
            pipeline = (BootstrapPipelineHandler)handler;
        }
        if (pipeline != null) {
            BootstrapPipelineHandler newPipeline = new BootstrapPipelineHandler(pipeline);
            for (int i = 0; i < newPipeline.size(); ++i) {
                PipelineConfiguration pipelineConfiguration = (PipelineConfiguration)newPipeline.get(i);
                if (pipelineConfiguration.deferredConsumer == null) continue;
                newPipeline.set(i, new PipelineConfiguration(pipelineConfiguration.deferredConsumer.apply((AbstractBootstrap<?, ?>)b), pipelineConfiguration.name));
            }
            b.handler((ChannelHandler)new BootstrapInitializerHandler(newPipeline, opsFactory, listener));
        } else {
            b.handler((ChannelHandler)new BootstrapInitializerHandler(null, opsFactory, listener));
        }
    }

    @Nullable
    public static <C> C findConfiguration(Class<C> clazz, @Nullable ChannelHandler handler) {
        Objects.requireNonNull(clazz, "configuration type");
        if (handler instanceof BootstrapPipelineHandler) {
            BootstrapPipelineHandler rph = (BootstrapPipelineHandler)handler;
            for (PipelineConfiguration aRph : rph) {
                if (clazz.isInstance(aRph.consumer)) {
                    return (C)aRph.consumer;
                }
                if (!clazz.isInstance(aRph.deferredConsumer)) continue;
                return (C)aRph.deferredConsumer;
            }
        }
        return null;
    }

    public static ServerBootstrap removeConfiguration(ServerBootstrap b, String name) {
        Objects.requireNonNull(b, "bootstrap");
        Objects.requireNonNull(name, "name");
        if (b.config().childHandler() != null) {
            b.childHandler(BootstrapHandlers.removeConfiguration(b.config().childHandler(), name));
        }
        return b;
    }

    public static Bootstrap removeConfiguration(Bootstrap b, String name) {
        Objects.requireNonNull(b, "bootstrap");
        Objects.requireNonNull(name, "name");
        if (b.config().handler() != null) {
            b.handler(BootstrapHandlers.removeConfiguration(b.config().handler(), name));
        }
        return b;
    }

    public static void channelOperationFactory(AbstractBootstrap<?, ?> b, ChannelOperations.OnSetup opsFactory) {
        Objects.requireNonNull(b, "bootstrap");
        Objects.requireNonNull(opsFactory, "opsFactory");
        b.option(OPS_OPTION, (Object)opsFactory);
    }

    public static ChannelOperations.OnSetup channelOperationFactory(AbstractBootstrap<?, ?> b) {
        Objects.requireNonNull(b, "bootstrap");
        ChannelOperations.OnSetup ops = (ChannelOperations.OnSetup)b.config().options().get(OPS_OPTION);
        if (ops == null) {
            return ChannelOperations.OnSetup.empty();
        }
        b.option(OPS_OPTION, null);
        return ops;
    }

    public static void connectionObserver(AbstractBootstrap<?, ?> b, ConnectionObserver connectionObserver) {
        Objects.requireNonNull(b, "bootstrap");
        Objects.requireNonNull(connectionObserver, "connectionObserver");
        b.option(OBSERVER_OPTION, (Object)connectionObserver);
    }

    public static ConnectionObserver connectionObserver(AbstractBootstrap<?, ?> b) {
        Objects.requireNonNull(b, "bootstrap");
        ConnectionObserver obs = (ConnectionObserver)b.config().options().get(OBSERVER_OPTION);
        if (obs == null) {
            return ConnectionObserver.emptyListener();
        }
        b.option(OBSERVER_OPTION, null);
        return obs;
    }

    public static void childConnectionObserver(ServerBootstrap b, ConnectionObserver connectionObserver) {
        Objects.requireNonNull(b, "bootstrap");
        Objects.requireNonNull(connectionObserver, "connectionObserver");
        b.childOption(OBSERVER_OPTION, (Object)connectionObserver);
    }

    public static ConnectionObserver childConnectionObserver(ServerBootstrap b) {
        Objects.requireNonNull(b, "bootstrap");
        ConnectionObserver obs = (ConnectionObserver)b.config().childOptions().get(OBSERVER_OPTION);
        if (obs == null) {
            return ConnectionObserver.emptyListener();
        }
        b.childOption(OBSERVER_OPTION, null);
        return obs;
    }

    public static Bootstrap updateConfiguration(Bootstrap b, String name, BiConsumer<ConnectionObserver, ? super Channel> c) {
        Objects.requireNonNull(b, "bootstrap");
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(c, "configuration");
        b.handler(BootstrapHandlers.updateConfiguration(b.config().handler(), name, c));
        return b;
    }

    public static Bootstrap updateConfiguration(Bootstrap b, String name, Function<? super Bootstrap, ? extends BiConsumer<ConnectionObserver, ? super Channel>> c) {
        Objects.requireNonNull(b, "bootstrap");
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(c, "configuration");
        b.handler(BootstrapHandlers.updateConfiguration(b.config().handler(), name, c));
        return b;
    }

    public static ServerBootstrap updateConfiguration(ServerBootstrap b, String name, BiConsumer<ConnectionObserver, ? super Channel> c) {
        Objects.requireNonNull(b, "bootstrap");
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(c, "configuration");
        b.childHandler(BootstrapHandlers.updateConfiguration(b.config().childHandler(), name, c));
        return b;
    }

    public static Bootstrap updateLogSupport(Bootstrap b, LoggingHandler handler) {
        BootstrapHandlers.updateConfiguration(b, "reactor.left.loggingHandler", BootstrapHandlers.logConfiguration(handler, SSL_CLIENT_DEBUG));
        return b;
    }

    public static ServerBootstrap updateLogSupport(ServerBootstrap b, LoggingHandler handler) {
        BootstrapHandlers.updateConfiguration(b, "reactor.left.loggingHandler", BootstrapHandlers.logConfiguration(handler, SSL_SERVER_DEBUG));
        return b;
    }

    static ChannelHandler removeConfiguration(ChannelHandler handler, String name) {
        if (handler instanceof BootstrapPipelineHandler) {
            BootstrapPipelineHandler rph = new BootstrapPipelineHandler((BootstrapPipelineHandler)handler);
            for (int i = 0; i < rph.size(); ++i) {
                if (!((PipelineConfiguration)rph.get((int)i)).name.equals(name)) continue;
                rph.remove(i);
                return rph;
            }
        }
        return handler;
    }

    static BootstrapPipelineHandler getOrCreateInitializer(@Nullable ChannelHandler handler) {
        if (handler instanceof BootstrapPipelineHandler) {
            return new BootstrapPipelineHandler((BootstrapPipelineHandler)handler);
        }
        BootstrapPipelineHandler p = new BootstrapPipelineHandler(Collections.emptyList());
        if (handler != null) {
            p.add(new PipelineConfiguration((ctx, ch) -> ch.pipeline().addFirst(new ChannelHandler[]{handler}), "user"));
        }
        return p;
    }

    static ChannelHandler updateConfiguration(@Nullable ChannelHandler handler, String name, BiConsumer<ConnectionObserver, ? super Channel> c) {
        BootstrapPipelineHandler p = BootstrapHandlers.getOrCreateInitializer(handler);
        p.add(new PipelineConfiguration(c, name));
        return p;
    }

    static ChannelHandler updateConfiguration(@Nullable ChannelHandler handler, String name, Function<AbstractBootstrap<?, ?>, BiConsumer<ConnectionObserver, ? super Channel>> c) {
        BootstrapPipelineHandler p = BootstrapHandlers.getOrCreateInitializer(handler);
        p.add(new PipelineConfiguration(c, name));
        return p;
    }

    static BiConsumer<ConnectionObserver, ? super Channel> logConfiguration(LoggingHandler handler, boolean debugSsl) {
        Objects.requireNonNull(handler, "loggingHandler");
        return new LoggingHandlerSupportConsumer((ChannelHandler)handler, debugSsl);
    }

    public static ServerBootstrap updateMetricsSupport(ServerBootstrap b, ChannelMetricsRecorder recorder) {
        return BootstrapHandlers.updateConfiguration(b, "reactor.left.channelMetricsHandler", (BiConsumer<ConnectionObserver, ? super Channel>)new MetricsSupportConsumer(recorder, true));
    }

    public static Bootstrap updateMetricsSupport(Bootstrap b, ChannelMetricsRecorder recorder) {
        BootstrapHandlers.updateConfiguration(b, "reactor.left.channelMetricsHandler", new DeferredMetricsSupport(recorder, false));
        b.resolver((AddressResolverGroup)new AddressResolverGroupMetrics((AddressResolverGroup<SocketAddress>)b.config().resolver(), recorder));
        return b;
    }

    public static ServerBootstrap removeMetricsSupport(ServerBootstrap b) {
        return BootstrapHandlers.removeConfiguration(b, "reactor.left.channelMetricsHandler");
    }

    public static Bootstrap removeMetricsSupport(Bootstrap b) {
        BootstrapHandlers.removeConfiguration(b, "reactor.left.channelMetricsHandler");
        AddressResolverGroup resolver = b.config().resolver();
        if (resolver instanceof AddressResolverGroupMetrics) {
            b.resolver(((AddressResolverGroupMetrics)resolver).resolverGroup);
        }
        return b;
    }

    @Nullable
    public static Function<Bootstrap, BiConsumer<ConnectionObserver, Channel>> findMetricsSupport(Bootstrap b) {
        return BootstrapHandlers.findConfiguration(DeferredMetricsSupport.class, b.config().handler());
    }

    BootstrapHandlers() {
    }

    static final class MetricsSupportConsumer
    implements BiConsumer<ConnectionObserver, Channel> {
        final SocketAddress remoteAddress;
        final ChannelMetricsRecorder recorder;
        final boolean onServer;

        MetricsSupportConsumer(ChannelMetricsRecorder recorder, boolean onServer) {
            this(recorder, null, onServer);
        }

        MetricsSupportConsumer(ChannelMetricsRecorder recorder, @Nullable SocketAddress remoteAddress, boolean onServer) {
            this.remoteAddress = remoteAddress;
            this.recorder = recorder;
            this.onServer = onServer;
        }

        @Override
        public void accept(ConnectionObserver connectionObserver, Channel channel) {
            SocketAddress address = this.remoteAddress != null ? this.remoteAddress : channel.remoteAddress();
            channel.pipeline().addFirst("reactor.left.channelMetricsHandler", (ChannelHandler)new ChannelMetricsHandler(this.recorder, address, this.onServer));
            ByteBufAllocator alloc = channel.alloc();
            if (alloc instanceof PooledByteBufAllocator) {
                ByteBufAllocatorMetrics.INSTANCE.registerMetrics("pooled", (ByteBufAllocatorMetric)((PooledByteBufAllocator)alloc).metric());
            } else if (alloc instanceof UnpooledByteBufAllocator) {
                ByteBufAllocatorMetrics.INSTANCE.registerMetrics("unpooled", ((UnpooledByteBufAllocator)alloc).metric());
            }
        }
    }

    static final class DeferredMetricsSupport
    implements Function<Bootstrap, BiConsumer<ConnectionObserver, Channel>> {
        final ChannelMetricsRecorder recorder;
        final boolean onServer;

        DeferredMetricsSupport(ChannelMetricsRecorder recorder, boolean onServer) {
            this.recorder = recorder;
            this.onServer = onServer;
        }

        @Override
        public BiConsumer<ConnectionObserver, Channel> apply(Bootstrap bootstrap) {
            return new MetricsSupportConsumer(this.recorder, bootstrap.config().remoteAddress(), this.onServer);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeferredMetricsSupport that = (DeferredMetricsSupport)o;
            return this.onServer == that.onServer && Objects.equals(this.recorder, that.recorder);
        }

        public int hashCode() {
            return Objects.hash(this.recorder, this.onServer);
        }
    }

    static final class LoggingHandlerSupportConsumer
    implements BiConsumer<ConnectionObserver, Channel> {
        final ChannelHandler handler;
        final boolean debugSsl;

        LoggingHandlerSupportConsumer(ChannelHandler handler, boolean debugSsl) {
            this.handler = handler;
            this.debugSsl = debugSsl;
        }

        @Override
        public void accept(ConnectionObserver connectionObserver, Channel channel) {
            ChannelPipeline pipeline = channel.pipeline();
            if (pipeline.get("reactor.left.sslHandler") != null) {
                if (this.debugSsl) {
                    pipeline.addBefore("reactor.left.sslHandler", "reactor.left.sslLoggingHandler", (ChannelHandler)new LoggingHandler("reactor.netty.tcp.ssl"));
                }
                pipeline.addAfter("reactor.left.sslHandler", "reactor.left.loggingHandler", this.handler);
            } else if (pipeline.get("reactor.left.proxyHandler") != null) {
                pipeline.addBefore("reactor.left.proxyHandler", "reactor.left.proxyLoggingHandler", (ChannelHandler)new LoggingHandler("reactor.netty.proxy")).addAfter("reactor.left.proxyHandler", "reactor.left.loggingHandler", this.handler);
            } else {
                pipeline.addFirst("reactor.left.loggingHandler", this.handler);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LoggingHandlerSupportConsumer that = (LoggingHandlerSupportConsumer)o;
            return Objects.equals(this.handler, that.handler);
        }

        public int hashCode() {
            return Objects.hash(this.handler);
        }
    }

    static final class BootstrapPipelineHandler
    extends ArrayList<PipelineConfiguration>
    implements ChannelHandler {
        BootstrapPipelineHandler(Collection<? extends PipelineConfiguration> c) {
            super(c);
        }

        @Override
        public boolean add(PipelineConfiguration consumer) {
            for (int i = 0; i < this.size(); ++i) {
                if (!((PipelineConfiguration)this.get((int)i)).name.equals(consumer.name)) continue;
                this.set(i, consumer);
                return true;
            }
            return super.add(consumer);
        }

        public void handlerAdded(ChannelHandlerContext ctx) {
            throw new UnsupportedOperationException("Transient handler, missing BootstrapHandlers.finalizeHandler() call");
        }

        public void handlerRemoved(ChannelHandlerContext ctx) {
            throw new UnsupportedOperationException("Transient handler, missing BootstrapHandlers.finalizeHandler() call");
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            throw Exceptions.propagate((Throwable)cause);
        }
    }

    static final class PipelineConfiguration {
        final BiConsumer<ConnectionObserver, ? super Channel> consumer;
        final String name;
        final Function<AbstractBootstrap<?, ?>, BiConsumer<ConnectionObserver, ? super Channel>> deferredConsumer;

        PipelineConfiguration(BiConsumer<ConnectionObserver, ? super Channel> consumer, String name) {
            this.consumer = consumer;
            this.name = name;
            this.deferredConsumer = null;
        }

        PipelineConfiguration(Function<AbstractBootstrap<?, ?>, BiConsumer<ConnectionObserver, ? super Channel>> deferredConsumer, String name) {
            this.consumer = null;
            this.name = name;
            this.deferredConsumer = deferredConsumer;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PipelineConfiguration that = (PipelineConfiguration)o;
            return Objects.equals(this.consumer, that.consumer) && Objects.equals(this.name, that.name) && Objects.equals(this.deferredConsumer, that.deferredConsumer);
        }

        public int hashCode() {
            return Objects.hash(this.consumer, this.name, this.deferredConsumer);
        }
    }

    @ChannelHandler.Sharable
    static final class BootstrapInitializerHandler
    extends ChannelInitializer<Channel> {
        final BootstrapPipelineHandler pipeline;
        final ConnectionObserver listener;
        final ChannelOperations.OnSetup opsFactory;

        BootstrapInitializerHandler(@Nullable BootstrapPipelineHandler pipeline, ChannelOperations.OnSetup opsFactory, ConnectionObserver listener) {
            this.pipeline = pipeline;
            this.opsFactory = opsFactory;
            this.listener = listener;
        }

        protected void initChannel(Channel ch) {
            if (this.pipeline != null) {
                for (PipelineConfiguration pipelineConfiguration : this.pipeline) {
                    pipelineConfiguration.consumer.accept(this.listener, (Channel)ch);
                }
            }
            ChannelOperations.addReactiveBridge(ch, this.opsFactory, this.listener);
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(ch, "Initialized pipeline {}"), new Object[]{ch.pipeline().toString()});
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ctx.fireExceptionCaught(cause);
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            ctx.fireChannelInactive();
        }
    }
}

