/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.channel;

import io.micrometer.core.instrument.Gauge;
import io.netty.buffer.ByteBufAllocatorMetric;
import io.netty.buffer.PooledByteBufAllocatorMetric;
import io.netty.util.internal.PlatformDependent;
import java.util.concurrent.ConcurrentMap;
import reactor.netty.Metrics;

final class ByteBufAllocatorMetrics {
    static final ByteBufAllocatorMetrics INSTANCE = new ByteBufAllocatorMetrics();
    final ConcurrentMap<String, ByteBufAllocatorMetric> cache = PlatformDependent.newConcurrentHashMap();
    static final String NAME = "reactor.netty.%s.bytebuf.allocator";

    private ByteBufAllocatorMetrics() {
    }

    void registerMetrics(String allocType, ByteBufAllocatorMetric metrics) {
        this.cache.computeIfAbsent(metrics.hashCode() + "", key -> {
            String name = String.format(NAME, allocType);
            String[] tags = new String[]{"id", key};
            ByteBufAllocatorMetrics.registerMetricsInternal(name, metrics, tags);
            tags = new String[]{"id", key, "type", allocType};
            ByteBufAllocatorMetrics.registerMetricsInternal("reactor.netty.bytebuf.allocator", metrics, tags);
            return metrics;
        });
    }

    private static void registerMetricsInternal(String name, ByteBufAllocatorMetric metrics, String ... tags) {
        Gauge.builder((String)(name + ".used.heap.memory"), (Object)metrics, ByteBufAllocatorMetric::usedHeapMemory).description("The number of the bytes of the heap memory.").tags(tags).register(Metrics.REGISTRY);
        Gauge.builder((String)(name + ".used.direct.memory"), (Object)metrics, ByteBufAllocatorMetric::usedDirectMemory).description("The number of the bytes of the direct memory.").tags(tags).register(Metrics.REGISTRY);
        if (metrics instanceof PooledByteBufAllocatorMetric) {
            PooledByteBufAllocatorMetric pooledMetrics = (PooledByteBufAllocatorMetric)metrics;
            Gauge.builder((String)(name + ".heap.arenas"), (Object)pooledMetrics, PooledByteBufAllocatorMetric::numHeapArenas).description("The number of heap arenas.").tags(tags).register(Metrics.REGISTRY);
            Gauge.builder((String)(name + ".direct.arenas"), (Object)pooledMetrics, PooledByteBufAllocatorMetric::numDirectArenas).description("The number of direct arenas.").tags(tags).register(Metrics.REGISTRY);
            Gauge.builder((String)(name + ".threadlocal.caches"), (Object)pooledMetrics, PooledByteBufAllocatorMetric::numThreadLocalCaches).description("The number of thread local caches.").tags(tags).register(Metrics.REGISTRY);
            Gauge.builder((String)(name + ".tiny.cache.size"), (Object)pooledMetrics, PooledByteBufAllocatorMetric::tinyCacheSize).description("The size of the tiny cache.").tags(tags).register(Metrics.REGISTRY);
            Gauge.builder((String)(name + ".small.cache.size"), (Object)pooledMetrics, PooledByteBufAllocatorMetric::smallCacheSize).description("The size of the small cache.").tags(tags).register(Metrics.REGISTRY);
            Gauge.builder((String)(name + ".normal.cache.size"), (Object)pooledMetrics, PooledByteBufAllocatorMetric::normalCacheSize).description("The size of the normal cache.").tags(tags).register(Metrics.REGISTRY);
            Gauge.builder((String)(name + ".chunk.size"), (Object)pooledMetrics, PooledByteBufAllocatorMetric::chunkSize).description("The chunk size for an arena.").tags(tags).register(Metrics.REGISTRY);
        }
    }
}

