/*
 * Decompiled with CFR 0.152.
 */
package io.openvidu.java.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import io.openvidu.java.client.MediaMode;
import io.openvidu.java.client.RecordingMode;
import io.openvidu.java.client.RecordingProperties;
import io.openvidu.java.client.VideoCodec;
import java.lang.reflect.Type;
import java.util.Map;

public class SessionProperties {
    private MediaMode mediaMode;
    private RecordingMode recordingMode;
    private RecordingProperties defaultRecordingProperties;
    private String customSessionId;
    private String mediaNode;
    private VideoCodec forcedVideoCodec;
    private VideoCodec forcedVideoCodecResolved;
    private Boolean allowTranscoding;

    protected SessionProperties() {
        this.mediaMode = MediaMode.ROUTED;
        this.recordingMode = RecordingMode.MANUAL;
        this.defaultRecordingProperties = new RecordingProperties.Builder().build();
        this.customSessionId = "";
        this.mediaNode = "";
    }

    private SessionProperties(MediaMode mediaMode, RecordingMode recordingMode, RecordingProperties defaultRecordingProperties, String customSessionId, String mediaNode, VideoCodec forcedVideoCodec, VideoCodec forcedVideoCodecResolved, Boolean allowTranscoding) {
        this.mediaMode = mediaMode;
        this.recordingMode = recordingMode;
        this.defaultRecordingProperties = defaultRecordingProperties;
        this.customSessionId = customSessionId;
        this.mediaNode = mediaNode;
        this.forcedVideoCodec = forcedVideoCodec;
        this.forcedVideoCodecResolved = forcedVideoCodecResolved;
        this.allowTranscoding = allowTranscoding;
    }

    public MediaMode mediaMode() {
        return this.mediaMode;
    }

    public RecordingMode recordingMode() {
        return this.recordingMode;
    }

    public RecordingProperties defaultRecordingProperties() {
        return this.defaultRecordingProperties;
    }

    public String customSessionId() {
        return this.customSessionId;
    }

    public String mediaNode() {
        return this.mediaNode;
    }

    public VideoCodec forcedVideoCodec() {
        return this.forcedVideoCodec;
    }

    public VideoCodec forcedVideoCodecResolved() {
        return this.forcedVideoCodecResolved;
    }

    public Boolean isTranscodingAllowed() {
        return this.allowTranscoding;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("mediaMode", this.mediaMode.name());
        json.addProperty("recordingMode", this.recordingMode.name());
        json.add("defaultRecordingProperties", (JsonElement)this.defaultRecordingProperties.toJson());
        json.addProperty("customSessionId", this.customSessionId);
        if (this.mediaNode != null && !this.mediaNode.isEmpty()) {
            JsonObject mediaNodeJson = new JsonObject();
            mediaNodeJson.addProperty("id", this.mediaNode);
            json.add("mediaNode", (JsonElement)mediaNodeJson);
        }
        if (this.forcedVideoCodec != null) {
            json.addProperty("forcedVideoCodec", this.forcedVideoCodec.name());
        }
        if (this.allowTranscoding != null) {
            json.addProperty("allowTranscoding", this.allowTranscoding);
        }
        return json;
    }

    public static Builder fromJson(Map<String, ?> params) throws IllegalArgumentException {
        Builder builder = new Builder();
        String customSessionId = null;
        if (params != null) {
            Boolean allowTranscoding;
            String forcedVideoCodecStr;
            String recordingModeString;
            String mediaModeString;
            try {
                mediaModeString = (String)params.get("mediaMode");
                recordingModeString = (String)params.get("recordingMode");
                customSessionId = (String)params.get("customSessionId");
                forcedVideoCodecStr = (String)params.get("forcedVideoCodec");
                allowTranscoding = (Boolean)params.get("allowTranscoding");
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Type error in some parameter: " + e.getMessage());
            }
            VideoCodec forcedVideoCodec = null;
            try {
                forcedVideoCodec = VideoCodec.valueOf(forcedVideoCodecStr);
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid value for parameter 'forcedVideoCodec': " + e.getMessage());
            }
            try {
                String mediaNode;
                if (recordingModeString != null) {
                    RecordingMode recordingMode = RecordingMode.valueOf(recordingModeString);
                    builder = builder.recordingMode(recordingMode);
                }
                if (mediaModeString != null) {
                    MediaMode mediaMode = MediaMode.valueOf(mediaModeString);
                    builder = builder.mediaMode(mediaMode);
                }
                if (customSessionId != null && !customSessionId.isEmpty()) {
                    if (!SessionProperties.isValidCustomSessionId(customSessionId)) {
                        throw new IllegalArgumentException("Parameter 'customSessionId' is wrong. Must be an alphanumeric string [a-zA-Z0-9_-]");
                    }
                    builder = builder.customSessionId(customSessionId);
                }
                if (forcedVideoCodec != null) {
                    builder = builder.forcedVideoCodec(forcedVideoCodec);
                    builder = builder.forcedVideoCodecResolved(forcedVideoCodec);
                }
                if (allowTranscoding != null) {
                    builder = builder.allowTranscoding(allowTranscoding);
                }
                JsonObject defaultRecordingPropertiesJson = null;
                if (params.get("defaultRecordingProperties") != null) {
                    try {
                        defaultRecordingPropertiesJson = new Gson().toJsonTree(params.get("defaultRecordingProperties"), Map.class).getAsJsonObject();
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Error in parameter 'defaultRecordingProperties'. It is not a valid JSON object");
                    }
                }
                if (defaultRecordingPropertiesJson != null) {
                    try {
                        String jsonString = defaultRecordingPropertiesJson.toString();
                        RecordingProperties.Builder recBuilder = RecordingProperties.fromJson((Map)new Gson().fromJson(jsonString, Map.class), null);
                        RecordingProperties defaultRecordingProperties = recBuilder.build();
                        builder = builder.defaultRecordingProperties(defaultRecordingProperties);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Parameter 'defaultRecordingProperties' is not valid: " + e.getMessage());
                    }
                }
                if ((mediaNode = SessionProperties.getMediaNodeProperty(params)) != null) {
                    builder = builder.mediaNode(mediaNode);
                }
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Some parameter is not valid. " + e.getMessage());
            }
        }
        return builder;
    }

    public static String getMediaNodeProperty(Map<?, ?> params) throws IllegalArgumentException {
        if (params.containsKey("mediaNode") && params.get("mediaNode") != null) {
            String mediaNode;
            JsonObject mediaNodeJson;
            try {
                mediaNodeJson = JsonParser.parseString((String)params.get("mediaNode").toString()).getAsJsonObject();
            }
            catch (Exception e) {
                try {
                    Gson gson = new Gson();
                    Type gsonType = new TypeToken<Map>(){}.getType();
                    String gsonString = gson.toJson(params.get("mediaNode"), gsonType);
                    mediaNodeJson = JsonParser.parseString((String)gsonString).getAsJsonObject();
                }
                catch (Exception e2) {
                    throw new IllegalArgumentException("Error in parameter 'mediaNode'. It is not a valid JSON object");
                }
            }
            if (!mediaNodeJson.has("id")) {
                throw new IllegalArgumentException("Error in parameter 'mediaNode'. Property 'id' not found");
            }
            try {
                JsonPrimitive primitive = mediaNodeJson.get("id").getAsJsonPrimitive();
                if (!primitive.isString()) {
                    throw new IllegalArgumentException("Type error in parameter 'mediaNode.id': not a String");
                }
                mediaNode = primitive.getAsString();
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Type error in parameter 'mediaNode.id': " + e.getMessage());
            }
            return mediaNode;
        }
        return null;
    }

    private static boolean isValidCustomSessionId(String customSessionId) {
        return customSessionId.matches("[a-zA-Z0-9_-]+");
    }

    public static class Builder {
        private MediaMode mediaMode = DefaultValues.mediaMode;
        private RecordingMode recordingMode = DefaultValues.recordingMode;
        private RecordingProperties defaultRecordingProperties = DefaultValues.defaultRecordingProperties;
        private String customSessionId = "";
        private String mediaNode = DefaultValues.mediaNode;
        private VideoCodec forcedVideoCodec = DefaultValues.forcedVideoCodec;
        private VideoCodec forcedVideoCodecResolved = DefaultValues.forcedVideoCodecResolved;
        private Boolean allowTranscoding = DefaultValues.allowTranscoding;

        public SessionProperties build() {
            return new SessionProperties(this.mediaMode, this.recordingMode, this.defaultRecordingProperties, this.customSessionId, this.mediaNode, this.forcedVideoCodec, this.forcedVideoCodecResolved, this.allowTranscoding);
        }

        public Builder mediaMode(MediaMode mediaMode) {
            this.mediaMode = mediaMode;
            return this;
        }

        public Builder recordingMode(RecordingMode recordingMode) {
            this.recordingMode = recordingMode;
            return this;
        }

        public Builder defaultRecordingProperties(RecordingProperties defaultRecordingProperties) {
            this.defaultRecordingProperties = defaultRecordingProperties;
            return this;
        }

        public Builder customSessionId(String customSessionId) {
            this.customSessionId = customSessionId;
            return this;
        }

        public Builder mediaNode(String mediaNodeId) {
            this.mediaNode = mediaNodeId;
            return this;
        }

        public Builder forcedVideoCodec(VideoCodec forcedVideoCodec) {
            this.forcedVideoCodec = forcedVideoCodec;
            return this;
        }

        public Builder forcedVideoCodecResolved(VideoCodec forcedVideoCodec) {
            this.forcedVideoCodecResolved = forcedVideoCodec;
            return this;
        }

        public Builder allowTranscoding(Boolean allowTranscoding) {
            this.allowTranscoding = allowTranscoding;
            return this;
        }
    }

    public static class DefaultValues {
        public static final MediaMode mediaMode = MediaMode.ROUTED;
        public static final RecordingMode recordingMode = RecordingMode.MANUAL;
        public static final RecordingProperties defaultRecordingProperties = new RecordingProperties.Builder().build();
        public static final String customSessionId = "";
        public static final String mediaNode = null;
        public static final VideoCodec forcedVideoCodec = VideoCodec.MEDIA_SERVER_PREFERRED;
        public static final VideoCodec forcedVideoCodecResolved = VideoCodec.NONE;
        public static final Boolean allowTranscoding = false;
    }
}

