/*
 * Decompiled with CFR 0.152.
 */
package io.openvidu.java.client;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.openvidu.java.client.Connection;
import io.openvidu.java.client.ConnectionProperties;
import io.openvidu.java.client.MediaMode;
import io.openvidu.java.client.OpenVidu;
import io.openvidu.java.client.OpenViduHttpException;
import io.openvidu.java.client.OpenViduJavaClientException;
import io.openvidu.java.client.OpenViduRole;
import io.openvidu.java.client.Publisher;
import io.openvidu.java.client.RecordingMode;
import io.openvidu.java.client.RecordingProperties;
import io.openvidu.java.client.SessionProperties;
import io.openvidu.java.client.TokenOptions;
import io.openvidu.java.client.VideoCodec;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session {
    private static final Logger log = LoggerFactory.getLogger(Session.class);
    private String sessionId;
    private long createdAt;
    private OpenVidu openVidu;
    private SessionProperties properties;
    private Map<String, Connection> connections = new ConcurrentHashMap<String, Connection>();
    private boolean recording = false;
    private boolean broadcasting = false;

    protected Session(OpenVidu openVidu) throws OpenViduJavaClientException, OpenViduHttpException {
        this.openVidu = openVidu;
        this.properties = new SessionProperties.Builder().build();
        this.getSessionHttp();
    }

    protected Session(OpenVidu openVidu, SessionProperties properties) throws OpenViduJavaClientException, OpenViduHttpException {
        this.openVidu = openVidu;
        this.properties = properties;
        this.getSessionHttp();
    }

    protected Session(OpenVidu openVidu, JsonObject json) {
        this.openVidu = openVidu;
        this.resetWithJson(json);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public long createdAt() {
        return this.createdAt;
    }

    @Deprecated
    public String generateToken() throws OpenViduJavaClientException, OpenViduHttpException {
        return this.generateToken(new TokenOptions.Builder().data("").role(OpenViduRole.PUBLISHER).build());
    }

    @Deprecated
    public String generateToken(TokenOptions tokenOptions) throws OpenViduJavaClientException, OpenViduHttpException {
        if (!this.hasSessionId()) {
            this.getSessionId();
        }
        HttpClientResponseHandler<String> responseHandler = new HttpClientResponseHandler<String>(){

            public String handleResponse(ClassicHttpResponse response) throws IOException, HttpException {
                int status = response.getCode();
                if (status == 200) {
                    String token = OpenVidu.httpResponseEntityToJson(response.getEntity()).get("id").getAsString();
                    log.info("Returning a TOKEN: {}", (Object)token);
                    return token;
                }
                throw OpenVidu.openViduHttpException(status);
            }
        };
        JsonObject json = tokenOptions.toJsonObject(this.sessionId);
        StringEntity params = new StringEntity(json.toString(), StandardCharsets.UTF_8);
        HttpPost request = new HttpPost(this.openVidu.hostname + "openvidu/api/tokens");
        request.setHeader("Content-Type", (Object)"application/json");
        request.setEntity((HttpEntity)params);
        try {
            return (String)this.openVidu.httpClient.execute((ClassicHttpRequest)request, (HttpClientResponseHandler)responseHandler);
        }
        catch (IOException e) {
            throw OpenVidu.ioExceptionToOpenViduHttpException(e);
        }
    }

    public Connection createConnection() throws OpenViduJavaClientException, OpenViduHttpException {
        return this.createConnection(new ConnectionProperties.Builder().data("").role(OpenViduRole.PUBLISHER).record(true).build());
    }

    public Connection createConnection(ConnectionProperties connectionProperties) throws OpenViduJavaClientException, OpenViduHttpException {
        if (!this.hasSessionId()) {
            this.getSessionId();
        }
        HttpClientResponseHandler<Connection> responseHandler = new HttpClientResponseHandler<Connection>(){

            public Connection handleResponse(ClassicHttpResponse response) throws IOException, HttpException {
                int status = response.getCode();
                if (status == 200) {
                    Connection connection = new Connection(OpenVidu.httpResponseEntityToJson(response.getEntity()));
                    Session.this.connections.put(connection.getConnectionId(), connection);
                    return connection;
                }
                throw OpenVidu.openViduHttpException(status);
            }
        };
        JsonObject json = connectionProperties.toJson(this.sessionId);
        StringEntity params = new StringEntity(json.toString(), StandardCharsets.UTF_8);
        HttpPost request = new HttpPost(this.openVidu.hostname + "openvidu/api/sessions/" + this.sessionId + "/connection");
        request.setHeader("Content-Type", (Object)"application/json");
        request.setEntity((HttpEntity)params);
        try {
            return (Connection)this.openVidu.httpClient.execute((ClassicHttpRequest)request, (HttpClientResponseHandler)responseHandler);
        }
        catch (IOException e) {
            throw OpenVidu.ioExceptionToOpenViduHttpException(e);
        }
    }

    public void close() throws OpenViduJavaClientException, OpenViduHttpException {
        HttpClientResponseHandler<Void> responseHandler = new HttpClientResponseHandler<Void>(){

            public Void handleResponse(ClassicHttpResponse response) throws IOException, HttpException {
                int status = response.getCode();
                if (status != 204) {
                    throw OpenVidu.openViduHttpException(status);
                }
                Session.this.openVidu.activeSessions.remove(Session.this.sessionId);
                log.info("Session {} closed", (Object)Session.this.sessionId);
                return null;
            }
        };
        HttpDelete request = new HttpDelete(this.openVidu.hostname + "openvidu/api/sessions/" + this.sessionId);
        try {
            this.openVidu.httpClient.execute((ClassicHttpRequest)request, (HttpClientResponseHandler)responseHandler);
        }
        catch (IOException e) {
            throw OpenVidu.ioExceptionToOpenViduHttpException(e);
        }
    }

    public boolean fetch() throws OpenViduJavaClientException, OpenViduHttpException {
        final String beforeJSON = this.toJson();
        HttpClientResponseHandler<Boolean> responseHandler = new HttpClientResponseHandler<Boolean>(){

            public Boolean handleResponse(ClassicHttpResponse response) throws IOException, HttpException {
                int status = response.getCode();
                if (status == 200) {
                    Session.this.resetWithJson(OpenVidu.httpResponseEntityToJson(response.getEntity()));
                    String afterJSON = Session.this.toJson();
                    boolean hasChanged = !beforeJSON.equals(afterJSON);
                    log.info("Session info fetched for session '{}'. Any change: {}", (Object)Session.this.sessionId, (Object)hasChanged);
                    return hasChanged;
                }
                throw OpenVidu.openViduHttpException(status);
            }
        };
        HttpGet request = new HttpGet(this.openVidu.hostname + "openvidu/api/sessions/" + this.sessionId + "?pendingConnections=true");
        try {
            return (Boolean)this.openVidu.httpClient.execute((ClassicHttpRequest)request, (HttpClientResponseHandler)responseHandler);
        }
        catch (IOException e) {
            throw OpenVidu.ioExceptionToOpenViduHttpException(e);
        }
    }

    public void forceDisconnect(Connection connection) throws OpenViduJavaClientException, OpenViduHttpException {
        this.forceDisconnect(connection.getConnectionId());
    }

    public void forceDisconnect(final String connectionId) throws OpenViduJavaClientException, OpenViduHttpException {
        HttpClientResponseHandler<Void> responseHandler = new HttpClientResponseHandler<Void>(){

            public Void handleResponse(ClassicHttpResponse response) throws IOException, HttpException {
                int status = response.getCode();
                if (status == 204) {
                    Connection connectionClosed = Session.this.connections.remove(connectionId);
                    if (connectionClosed != null) {
                        for (Publisher publisher : connectionClosed.getPublishers()) {
                            String streamId = publisher.getStreamId();
                            for (Connection connection : Session.this.connections.values()) {
                                connection.setSubscribers(connection.getSubscribers().stream().filter(subscriber -> !streamId.equals(subscriber)).collect(Collectors.toList()));
                            }
                        }
                    } else {
                        log.warn("The closed connection wasn't fetched in OpenVidu Java Client. No changes in the collection of active connections of the Session");
                    }
                } else {
                    throw OpenVidu.openViduHttpException(status);
                }
                log.info("Connection {} closed", (Object)connectionId);
                return null;
            }
        };
        HttpDelete request = new HttpDelete(this.openVidu.hostname + "openvidu/api/sessions/" + this.sessionId + "/connection/" + connectionId);
        try {
            this.openVidu.httpClient.execute((ClassicHttpRequest)request, (HttpClientResponseHandler)responseHandler);
        }
        catch (IOException e) {
            throw OpenVidu.ioExceptionToOpenViduHttpException(e);
        }
    }

    public void forceUnpublish(Publisher publisher) throws OpenViduJavaClientException, OpenViduHttpException {
        this.forceUnpublish(publisher.getStreamId());
    }

    public void forceUnpublish(final String streamId) throws OpenViduJavaClientException, OpenViduHttpException {
        HttpClientResponseHandler<Void> responseHandler = new HttpClientResponseHandler<Void>(){

            public Void handleResponse(ClassicHttpResponse response) throws IOException, HttpException {
                int status = response.getCode();
                if (status == 204) {
                    for (Connection connection : Session.this.connections.values()) {
                        if (connection.publishers.remove(streamId) != null) continue;
                        connection.subscribers.remove(streamId);
                    }
                } else {
                    throw OpenVidu.openViduHttpException(status);
                }
                log.info("Stream {} unpublished", (Object)streamId);
                return null;
            }
        };
        HttpDelete request = new HttpDelete(this.openVidu.hostname + "openvidu/api/sessions/" + this.sessionId + "/stream/" + streamId);
        try {
            this.openVidu.httpClient.execute((ClassicHttpRequest)request, (HttpClientResponseHandler)responseHandler);
        }
        catch (IOException e) {
            throw OpenVidu.ioExceptionToOpenViduHttpException(e);
        }
    }

    public Connection updateConnection(final String connectionId, final ConnectionProperties connectionProperties) throws OpenViduJavaClientException, OpenViduHttpException {
        HttpClientResponseHandler<Connection> responseHandler = new HttpClientResponseHandler<Connection>(){

            public Connection handleResponse(ClassicHttpResponse response) throws IOException, HttpException {
                int status = response.getCode();
                if (status == 200) {
                    log.info("Connection {} updated", (Object)connectionId);
                } else if (status == 204) {
                    log.info("Properties of Connection {} remain the same", (Object)connectionId);
                } else {
                    throw OpenVidu.openViduHttpException(status);
                }
                JsonObject json = OpenVidu.httpResponseEntityToJson(response.getEntity());
                Connection existingConnection = Session.this.connections.get(connectionId);
                if (existingConnection == null) {
                    Connection newConnection = new Connection(json);
                    Session.this.connections.put(connectionId, newConnection);
                    return newConnection;
                }
                existingConnection.overrideConnectionProperties(connectionProperties);
                return existingConnection;
            }
        };
        JsonObject json = connectionProperties.toJson(this.sessionId);
        StringEntity params = new StringEntity(json.toString(), StandardCharsets.UTF_8);
        HttpPatch request = new HttpPatch(this.openVidu.hostname + "openvidu/api/sessions/" + this.sessionId + "/connection/" + connectionId);
        request.setHeader("Content-Type", (Object)"application/json");
        request.setEntity((HttpEntity)params);
        try {
            return (Connection)this.openVidu.httpClient.execute((ClassicHttpRequest)request, (HttpClientResponseHandler)responseHandler);
        }
        catch (IOException e) {
            throw OpenVidu.ioExceptionToOpenViduHttpException(e);
        }
    }

    public Connection getConnection(String id) {
        return this.connections.get(id);
    }

    public List<Connection> getConnections() {
        return this.connections.values().stream().collect(Collectors.toList());
    }

    public List<Connection> getActiveConnections() {
        return this.connections.values().stream().filter(con -> "active".equals(con.getStatus())).collect(Collectors.toList());
    }

    public boolean isBeingRecorded() {
        return this.recording;
    }

    public boolean isBeingBroadcasted() {
        return this.broadcasting;
    }

    public SessionProperties getProperties() {
        return this.properties;
    }

    private boolean hasSessionId() {
        return this.sessionId != null && !this.sessionId.isEmpty();
    }

    private void getSessionHttp() throws OpenViduJavaClientException, OpenViduHttpException {
        if (this.hasSessionId()) {
            return;
        }
        HttpClientResponseHandler<Void> responseHandler = new HttpClientResponseHandler<Void>(){

            public Void handleResponse(ClassicHttpResponse response) throws IOException, HttpException {
                int status = response.getCode();
                if (status == 200) {
                    SessionProperties responseProperties;
                    JsonObject responseJson = OpenVidu.httpResponseEntityToJson(response.getEntity());
                    Session.this.sessionId = responseJson.get("id").getAsString();
                    Session.this.createdAt = responseJson.get("createdAt").getAsLong();
                    VideoCodec forcedVideoCodec = VideoCodec.valueOf(responseJson.get("forcedVideoCodec").getAsString());
                    Boolean allowTranscoding = responseJson.get("allowTranscoding").getAsBoolean();
                    Session.this.properties = responseProperties = new SessionProperties.Builder().mediaMode(Session.this.properties.mediaMode()).recordingMode(Session.this.properties.recordingMode()).defaultRecordingProperties(Session.this.properties.defaultRecordingProperties()).customSessionId(Session.this.properties.customSessionId()).mediaNode(Session.this.properties.mediaNode()).forcedVideoCodec(forcedVideoCodec).allowTranscoding(allowTranscoding).build();
                    log.info("Session '{}' created", (Object)Session.this.sessionId);
                } else if (status == 409) {
                    Session.this.sessionId = Session.this.properties.customSessionId();
                    try {
                        Session.this.fetch();
                    }
                    catch (OpenViduHttpException | OpenViduJavaClientException e) {
                        throw OpenVidu.openViduException(e);
                    }
                } else {
                    throw OpenVidu.openViduHttpException(status);
                }
                return null;
            }
        };
        JsonObject json = this.properties.toJson();
        StringEntity params = new StringEntity(json.toString(), StandardCharsets.UTF_8);
        HttpPost request = new HttpPost(this.openVidu.hostname + "openvidu/api/sessions");
        request.setHeader("Content-Type", (Object)"application/json");
        request.setEntity((HttpEntity)params);
        try {
            this.openVidu.httpClient.execute((ClassicHttpRequest)request, (HttpClientResponseHandler)responseHandler);
        }
        catch (IOException e) {
            throw OpenVidu.ioExceptionToOpenViduHttpException(e);
        }
    }

    protected void setIsBeingRecorded(boolean recording) {
        this.recording = recording;
    }

    protected void setIsBeingBroadcasted(boolean broadcasting) {
        this.broadcasting = broadcasting;
    }

    protected Session resetWithJson(JsonObject json) {
        this.sessionId = json.get("sessionId").getAsString();
        this.createdAt = json.get("createdAt").getAsLong();
        this.recording = json.get("recording").getAsBoolean();
        this.broadcasting = json.get("broadcasting").getAsBoolean();
        SessionProperties.Builder builder = new SessionProperties.Builder().mediaMode(MediaMode.valueOf(json.get("mediaMode").getAsString())).recordingMode(RecordingMode.valueOf(json.get("recordingMode").getAsString()));
        if (json.has("defaultRecordingProperties")) {
            String jsonString = json.get("defaultRecordingProperties").getAsJsonObject().toString();
            RecordingProperties.Builder recBuilder = RecordingProperties.fromJson((Map)new Gson().fromJson(jsonString, Map.class), null);
            builder.defaultRecordingProperties(recBuilder.build());
        }
        if (json.has("customSessionId")) {
            builder.customSessionId(json.get("customSessionId").getAsString());
        }
        if (json.has("forcedVideoCodec")) {
            builder.forcedVideoCodec(VideoCodec.valueOf(json.get("forcedVideoCodec").getAsString()));
        }
        if (json.has("allowTranscoding")) {
            builder.allowTranscoding(json.get("allowTranscoding").getAsBoolean());
        }
        this.properties = builder.build();
        JsonArray jsonArrayConnections = json.get("connections").getAsJsonObject().get("content").getAsJsonArray();
        HashSet fetchedConnectionIds = new HashSet();
        jsonArrayConnections.forEach(connectionJsonElement -> {
            JsonObject connectionJson = connectionJsonElement.getAsJsonObject();
            Connection connectionObj = new Connection(connectionJson);
            String id = connectionObj.getConnectionId();
            fetchedConnectionIds.add(id);
            this.connections.computeIfPresent(id, (cId, c) -> {
                c = c.resetWithJson(connectionJson);
                return c;
            });
            this.connections.computeIfAbsent(id, cId -> connectionObj);
        });
        this.connections.entrySet().removeIf(entry -> !fetchedConnectionIds.contains(((Connection)entry.getValue()).getConnectionId()));
        return this;
    }

    protected String toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("sessionId", this.sessionId);
        json.addProperty("createdAt", (Number)this.createdAt);
        json.addProperty("recording", Boolean.valueOf(this.recording));
        json.addProperty("broadcasting", Boolean.valueOf(this.broadcasting));
        JsonObject sessionPropertiesJson = this.properties.toJson();
        for (Map.Entry entry : sessionPropertiesJson.entrySet()) {
            json.add((String)entry.getKey(), ((JsonElement)entry.getValue()).deepCopy());
        }
        JsonObject connections = new JsonObject();
        connections.addProperty("numberOfElements", (Number)this.getConnections().size());
        JsonArray jsonArrayConnections = new JsonArray();
        this.getConnections().forEach(con -> jsonArrayConnections.add((JsonElement)con.toJson()));
        connections.add("content", (JsonElement)jsonArrayConnections);
        json.add("connections", (JsonElement)connections);
        return json.toString();
    }
}

