/*
 * Decompiled with CFR 0.152.
 */
package io.openvidu.java.client;

import com.google.gson.JsonObject;

public class Publisher {
    private String streamId;
    private long createdAt;
    private boolean hasVideo;
    private boolean hasAudio;
    private Boolean audioActive;
    private Boolean videoActive;
    private Integer frameRate;
    private String typeOfVideo;
    private String videoDimensions;

    protected Publisher(JsonObject json) {
        this.resetWithJson(json);
    }

    public String getStreamId() {
        return this.streamId;
    }

    public long createdAt() {
        return this.createdAt;
    }

    public boolean hasVideo() {
        return this.hasVideo;
    }

    public boolean hasAudio() {
        return this.hasAudio;
    }

    public Boolean isAudioActive() {
        return this.audioActive;
    }

    public Boolean isVideoActive() {
        return this.videoActive;
    }

    public Integer getFrameRate() {
        return this.frameRate;
    }

    public String getTypeOfVideo() {
        return this.typeOfVideo;
    }

    public String getVideoDimensions() {
        return this.videoDimensions;
    }

    protected JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("streamId", this.streamId);
        json.addProperty("hasAudio", Boolean.valueOf(this.hasAudio()));
        json.addProperty("hasVideo", Boolean.valueOf(this.hasVideo()));
        json.addProperty("audioActive", this.isAudioActive());
        json.addProperty("videoActive", this.isVideoActive());
        json.addProperty("frameRate", (Number)this.getFrameRate());
        json.addProperty("typeOfVideo", this.getTypeOfVideo());
        json.addProperty("videoDimensions", this.getVideoDimensions());
        return json;
    }

    protected Publisher resetWithJson(JsonObject json) {
        this.streamId = json.get("streamId").getAsString();
        this.createdAt = json.get("createdAt").getAsLong();
        if (json.has("mediaOptions") && !json.get("mediaOptions").isJsonNull()) {
            JsonObject mediaOptions = json.get("mediaOptions").getAsJsonObject();
            this.hasAudio = mediaOptions.get("hasAudio").getAsBoolean();
            this.hasVideo = mediaOptions.get("hasVideo").getAsBoolean();
            if (mediaOptions.has("audioActive") && !mediaOptions.get("audioActive").isJsonNull()) {
                this.audioActive = mediaOptions.get("audioActive").getAsBoolean();
            }
            if (mediaOptions.has("videoActive") && !mediaOptions.get("videoActive").isJsonNull()) {
                this.videoActive = mediaOptions.get("videoActive").getAsBoolean();
            }
            if (mediaOptions.has("frameRate") && !mediaOptions.get("frameRate").isJsonNull()) {
                this.frameRate = mediaOptions.get("frameRate").getAsInt();
            }
            if (mediaOptions.has("typeOfVideo") && !mediaOptions.get("typeOfVideo").isJsonNull()) {
                this.typeOfVideo = mediaOptions.get("typeOfVideo").getAsString();
            }
            if (mediaOptions.has("videoDimensions") && !mediaOptions.get("videoDimensions").isJsonNull()) {
                this.videoDimensions = mediaOptions.get("videoDimensions").getAsString();
            }
        }
        return this;
    }
}

