/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.export.CollectionHandle;
import io.opentelemetry.sdk.metrics.internal.state.BoundStorageHandle;
import io.opentelemetry.sdk.metrics.internal.state.DeltaAccumulation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class DeltaMetricStorage<T> {
    private final Aggregator<T> aggregator;
    private final ConcurrentHashMap<Attributes, AggregatorHandle<T>> activeCollectionStorage = new ConcurrentHashMap();
    private final List<DeltaAccumulation<T>> unreportedDeltas = new ArrayList<DeltaAccumulation<T>>();

    DeltaMetricStorage(Aggregator<T> aggregator) {
        this.aggregator = aggregator;
    }

    public BoundStorageHandle bind(Attributes attributes) {
        AggregatorHandle<T> boundAggregatorHandle;
        AggregatorHandle<T> aggregatorHandle = this.activeCollectionStorage.get(attributes);
        if (aggregatorHandle != null && aggregatorHandle.acquire()) {
            return aggregatorHandle;
        }
        aggregatorHandle = this.aggregator.createHandle();
        while ((boundAggregatorHandle = this.activeCollectionStorage.putIfAbsent(attributes, aggregatorHandle)) != null) {
            if (boundAggregatorHandle.acquire()) {
                return boundAggregatorHandle;
            }
            this.activeCollectionStorage.remove(attributes, boundAggregatorHandle);
        }
        return aggregatorHandle;
    }

    public synchronized Map<Attributes, T> collectFor(CollectionHandle collector, Set<CollectionHandle> collectors, boolean suppressCollection) {
        if (!suppressCollection) {
            this.collectSynchronousDeltaAccumulationAndReset();
        }
        HashMap result = new HashMap();
        for (DeltaAccumulation<T> point : this.unreportedDeltas) {
            if (point.wasReadBy(collector)) continue;
            DeltaMetricStorage.mergeInPlace(result, point.read(collector), this.aggregator);
        }
        this.unreportedDeltas.removeIf(delta -> delta.wasReadByAll(collectors));
        return result;
    }

    private synchronized void collectSynchronousDeltaAccumulationAndReset() {
        HashMap<Attributes, T> result = new HashMap<Attributes, T>();
        for (Map.Entry<Attributes, AggregatorHandle<T>> entry : this.activeCollectionStorage.entrySet()) {
            T accumulation;
            boolean unmappedEntry = entry.getValue().tryUnmap();
            if (unmappedEntry) {
                this.activeCollectionStorage.remove(entry.getKey(), entry.getValue());
            }
            if ((accumulation = entry.getValue().accumulateThenReset(entry.getKey())) == null) continue;
            result.put(entry.getKey(), accumulation);
        }
        if (!result.isEmpty()) {
            this.unreportedDeltas.add(new DeltaAccumulation(result));
        }
    }

    static final <T> void mergeInPlace(Map<Attributes, T> result, Map<Attributes, T> toMerge, Aggregator<T> aggregator) {
        toMerge.forEach((k, v) -> {
            if (result.containsKey(k)) {
                result.put((Attributes)k, (Object)aggregator.merge(result.get(k), v));
            } else {
                result.put((Attributes)k, (Object)v);
            }
        });
    }
}

