/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.LongGaugeData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.exemplar.ExemplarReservoir;
import io.opentelemetry.sdk.metrics.internal.aggregator.AbstractAggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.aggregator.LongAccumulation;
import io.opentelemetry.sdk.metrics.internal.aggregator.MetricDataUtils;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.resources.Resource;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nullable;

final class LongLastValueAggregator
extends AbstractAggregator<LongAccumulation> {
    private final Supplier<ExemplarReservoir> reservoirSupplier;

    LongLastValueAggregator(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, MetricDescriptor descriptor, Supplier<ExemplarReservoir> reservoirSupplier) {
        super(resource, instrumentationLibraryInfo, descriptor, false);
        this.reservoirSupplier = reservoirSupplier;
    }

    @Override
    public AggregatorHandle<LongAccumulation> createHandle() {
        return new Handle(this.reservoirSupplier.get());
    }

    @Override
    public LongAccumulation accumulateLong(long value) {
        return LongAccumulation.create(value);
    }

    @Override
    public LongAccumulation merge(LongAccumulation previous, LongAccumulation current) {
        return current;
    }

    @Override
    public MetricData toMetricData(Map<Attributes, LongAccumulation> accumulationByLabels, long startEpochNanos, long lastCollectionEpoch, long epochNanos) {
        return MetricData.createLongGauge(this.getResource(), this.getInstrumentationLibraryInfo(), this.getMetricDescriptor().getName(), this.getMetricDescriptor().getDescription(), this.getMetricDescriptor().getUnit(), LongGaugeData.create(MetricDataUtils.toLongPointList(accumulationByLabels, 0L, epochNanos)));
    }

    static final class Handle
    extends AggregatorHandle<LongAccumulation> {
        @Nullable
        private static final Long DEFAULT_VALUE = null;
        private final AtomicReference<Long> current = new AtomicReference<Long>(DEFAULT_VALUE);

        Handle(ExemplarReservoir exemplarReservoir) {
            super(exemplarReservoir);
        }

        @Override
        protected LongAccumulation doAccumulateThenReset(List<ExemplarData> exemplars) {
            return LongAccumulation.create(this.current.getAndSet(DEFAULT_VALUE), exemplars);
        }

        @Override
        protected void doRecordLong(long value) {
            this.current.set(value);
        }
    }
}

