/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class ExplicitBucketHistogramUtils {
    public static final List<Double> DEFAULT_HISTOGRAM_BUCKET_BOUNDARIES = Collections.unmodifiableList(Arrays.asList(5.0, 10.0, 25.0, 50.0, 75.0, 100.0, 250.0, 500.0, 750.0, 1000.0, 2500.0, 5000.0, 7500.0, 10000.0));

    private ExplicitBucketHistogramUtils() {
    }

    public static double[] createBoundaryArray(List<Double> boundaries) {
        return boundaries.stream().mapToDouble(i -> i).toArray();
    }

    public static int findBucketIndex(double[] boundaries, double value) {
        for (int i = 0; i < boundaries.length; ++i) {
            if (!(value <= boundaries[i])) continue;
            return i;
        }
        return boundaries.length;
    }
}

