/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.data.DoubleGaugeData;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.exemplar.ExemplarReservoir;
import io.opentelemetry.sdk.metrics.internal.aggregator.AbstractAggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.aggregator.DoubleAccumulation;
import io.opentelemetry.sdk.metrics.internal.aggregator.MetricDataUtils;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.resources.Resource;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class DoubleLastValueAggregator
extends AbstractAggregator<DoubleAccumulation> {
    private final Supplier<ExemplarReservoir> reservoirSupplier;

    DoubleLastValueAggregator(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, MetricDescriptor descriptor, Supplier<ExemplarReservoir> reservoirSupplier) {
        super(resource, instrumentationLibraryInfo, descriptor, true);
        this.reservoirSupplier = reservoirSupplier;
    }

    @Override
    public AggregatorHandle<DoubleAccumulation> createHandle() {
        return new Handle(this.reservoirSupplier.get());
    }

    @Override
    public DoubleAccumulation accumulateDouble(double value) {
        return DoubleAccumulation.create(value);
    }

    @Override
    public DoubleAccumulation merge(DoubleAccumulation previous, DoubleAccumulation current) {
        return current;
    }

    @Override
    public MetricData toMetricData(Map<Attributes, DoubleAccumulation> accumulationByLabels, long startEpochNanos, long lastCollectionEpoch, long epochNanos) {
        return MetricData.createDoubleGauge(this.getResource(), this.getInstrumentationLibraryInfo(), this.getMetricDescriptor().getName(), this.getMetricDescriptor().getDescription(), this.getMetricDescriptor().getUnit(), DoubleGaugeData.create(MetricDataUtils.toDoublePointList(accumulationByLabels, 0L, epochNanos)));
    }

    static final class Handle
    extends AggregatorHandle<DoubleAccumulation> {
        @Nullable
        private static final Double DEFAULT_VALUE = null;
        private final AtomicReference<Double> current = new AtomicReference<Double>(DEFAULT_VALUE);

        private Handle(ExemplarReservoir reservoir) {
            super(reservoir);
        }

        @Override
        protected DoubleAccumulation doAccumulateThenReset(List<ExemplarData> exemplars) {
            return DoubleAccumulation.create(this.current.getAndSet(DEFAULT_VALUE), exemplars);
        }

        @Override
        protected void doRecordDouble(double value) {
            this.current.set(value);
        }
    }
}

