/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.server;

import io.openliberty.tools.common.plugins.config.ServerConfigXmlDocument;
import io.openliberty.tools.common.plugins.config.XmlDocument;
import io.openliberty.tools.common.plugins.util.BinaryScannerUtil;
import io.openliberty.tools.common.plugins.util.PluginExecutionException;
import io.openliberty.tools.common.plugins.util.ServerFeatureUtil;
import io.openliberty.tools.maven.ServerFeatureSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingResult;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@Mojo(name="generate-features")
public class GenerateFeaturesMojo
extends ServerFeatureSupport {
    public static final String FEATURES_FILE_MESSAGE = "The Liberty Maven Plugin has generated Liberty features necessary for your application in configDropins/overrides/generated-features.xml";
    public static final String HEADER = "This file was generated by the Liberty Maven Plugin and will be overwritten on subsequent runs of the liberty:generate-features goal.\n It is recommended that you do not edit this file and that you commit this file to your version control.";
    public static final String GENERATED_FEATURES_COMMENT = "The following features were generated based on API usage detected in your application";
    public static final String NO_NEW_FEATURES_COMMENT = "No additional features generated";
    public static final String NO_CLASSES_DIR_WARNING = "Could not find classes directory to generate features against. Liberty features will not be generated. Ensure your project has first been compiled.";
    private File binaryScanner;
    @Parameter(property="classFiles")
    private List<String> classFiles;
    @Parameter(property="optimize", defaultValue="true")
    private boolean optimize;

    @Override
    protected void init() throws MojoExecutionException {
        this.skipServerConfigSetup = true;
        super.init();
    }

    public void execute() throws MojoExecutionException {
        this.init();
        if (this.skip) {
            this.getLog().info((CharSequence)"\nSkipping generate-features goal.\n");
            return;
        }
        try {
            this.generateFeatures();
        }
        catch (PluginExecutionException e) {
            throw new MojoExecutionException("Error during generation of features.", (Exception)((Object)e));
        }
    }

    private void generateFeatures() throws MojoExecutionException, PluginExecutionException {
        ProjectDependencyGraph graph = this.session.getProjectDependencyGraph();
        ArrayList<MavenProject> upstreamProjects = new ArrayList<MavenProject>();
        if (graph != null) {
            this.checkMultiModuleConflicts(graph);
            List downstreamProjects = graph.getDownstreamProjects(this.project, true);
            if (!downstreamProjects.isEmpty()) {
                this.getLog().debug((CharSequence)("Downstream projects: " + downstreamProjects));
                return;
            }
            for (MavenProject upstreamProj : graph.getUpstreamProjects(this.project, true)) {
                try {
                    upstreamProjects.add(this.getMavenProject(upstreamProj.getFile()));
                }
                catch (ProjectBuildingException e) {
                    this.getLog().debug((CharSequence)("Could not resolve the upstream project: " + upstreamProj.getFile() + " using the current Maven session. Falling back to last resolved upstream project."));
                    upstreamProjects.add(upstreamProj);
                }
            }
            if (this.containsPreviousLibertyModule(graph)) {
                return;
            }
        }
        this.binaryScanner = this.getBinaryScannerJarFromRepository();
        BinaryScannerHandler binaryScannerHandler = new BinaryScannerHandler(this.binaryScanner);
        this.getLog().debug((CharSequence)"--- Generate Features values ---");
        this.getLog().debug((CharSequence)("Binary scanner jar: " + this.binaryScanner.getName()));
        this.getLog().debug((CharSequence)("optimize generate features: " + this.optimize));
        if (this.classFiles != null && !this.classFiles.isEmpty()) {
            this.getLog().debug((CharSequence)("Generate features for the following class files: " + this.classFiles.toString()));
        }
        ServerFeatureUtil servUtil = this.getServerFeatureUtil(true, null);
        HashSet<String> generatedFiles = new HashSet<String>();
        generatedFiles.add("generated-features.xml");
        Set<Object> existingFeatures = this.getServerFeatures(servUtil, generatedFiles, this.optimize);
        HashSet<String> nonCustomFeatures = new HashSet<String>();
        for (String string : existingFeatures) {
            if (string.contains(":")) continue;
            nonCustomFeatures.add(string);
        }
        Set scannedFeatureList = null;
        String string = null;
        String mpVersion = null;
        try {
            ArrayList<MavenProject> mavenProjects = new ArrayList<MavenProject>();
            mavenProjects.addAll(upstreamProjects);
            mavenProjects.add(this.project);
            Set<String> directories = this.getClassesDirectories(mavenProjects);
            if (directories.isEmpty() && (this.classFiles == null || this.classFiles.isEmpty())) {
                this.getLog().warn((CharSequence)NO_CLASSES_DIR_WARNING);
            }
            String string2 = this.getEEVersion(mavenProjects);
            mpVersion = this.getMPVersion(mavenProjects);
            String logLocation = this.project.getBuild().getDirectory();
            String eeVersionArg = BinaryScannerUtil.composeEEVersion((String)string2);
            String mpVersionArg = BinaryScannerUtil.composeMPVersion((String)mpVersion);
            scannedFeatureList = binaryScannerHandler.runBinaryScanner(nonCustomFeatures, this.classFiles, directories, logLocation, eeVersionArg, mpVersionArg, this.optimize);
        }
        catch (BinaryScannerUtil.NoRecommendationException noRecommendation) {
            throw new MojoExecutionException(String.format("A working set of features could not be generated due to conflicts in the application\u2019s API usage: %s. Review and update your application to ensure it is not using conflicting APIs from different levels of MicroProfile, Java EE, or Jakarta EE.", noRecommendation.getConflicts()));
        }
        catch (BinaryScannerUtil.FeatureModifiedException featuresModified) {
            Set<Object> userFeatures = this.optimize ? existingFeatures : this.getServerFeatures(servUtil, generatedFiles, true);
            Set modifiedSet = featuresModified.getFeatures();
            if (modifiedSet.containsAll(userFeatures)) {
                this.getLog().debug((CharSequence)"FeatureModifiedException, modifiedSet containsAll userFeatures, pass modifiedSet on to generateFeatures");
                this.getLog().warn((CharSequence)featuresModified.getMessage());
                scannedFeatureList = modifiedSet;
            }
            Set allAppFeatures = featuresModified.getSuggestions();
            allAppFeatures.addAll(userFeatures);
            this.getLog().debug((CharSequence)"FeatureModifiedException, combine suggestions from scanner with user features in error msg");
            throw new MojoExecutionException(String.format("A working set of features could not be generated due to conflicts between configured features and the application's API usage: %s. Review and update your server configuration and application to ensure they are not using conflicting features and APIs from different levels of MicroProfile, Java EE, or Jakarta EE. Refer to the following set of suggested features for guidance: %s.", allAppFeatures, modifiedSet));
        }
        catch (BinaryScannerUtil.RecommendationSetException showRecommendation) {
            if (showRecommendation.isExistingFeaturesConflict()) {
                throw new MojoExecutionException(String.format("A working set of features could not be generated due to conflicts between configured features: %s. Review and update your server configuration to ensure it is not using conflicting features from different levels of MicroProfile, Java EE, or Jakarta EE. Refer to the following set of suggested features for guidance: %s.", showRecommendation.getConflicts(), showRecommendation.getSuggestions()));
            }
            throw new MojoExecutionException(String.format("A working set of features could not be generated due to conflicts between configured features and the application's API usage: %s. Review and update your server configuration and application to ensure they are not using conflicting features and APIs from different levels of MicroProfile, Java EE, or Jakarta EE. Refer to the following set of suggested features for guidance: %s.", showRecommendation.getConflicts(), showRecommendation.getSuggestions()));
        }
        catch (BinaryScannerUtil.FeatureUnavailableException featureUnavailable) {
            throw new MojoExecutionException(String.format("A working set of features could not be generated due to conflicts in the required features: %s and required levels of MicroProfile: %s, Java EE or Jakarta EE: %s. Review and update your application to ensure it is using the correct levels of MicroProfile, Java EE, or Jakarta EE, or consider removing the following set of features: %s.", featureUnavailable.getConflicts(), featureUnavailable.getMPLevel(), featureUnavailable.getEELevel(), featureUnavailable.getUnavailableFeatures()));
        }
        catch (BinaryScannerUtil.IllegalTargetComboException illegalCombo) {
            throw new MojoExecutionException(String.format("The Java EE or Jakarta EE version number %s specified in the build file in combination with the MicroProfile version number %s specified in the build file is not supported for feature generation.", string, mpVersion));
        }
        catch (BinaryScannerUtil.IllegalTargetException illegalTargets) {
            String messages = BinaryScannerUtil.buildInvalidArgExceptionMessage((String)illegalTargets.getEELevel(), (String)illegalTargets.getMPLevel(), string, mpVersion);
            throw new MojoExecutionException(messages);
        }
        catch (PluginExecutionException x) {
            Throwable o = x.getCause();
            if (o != null) {
                this.getLog().debug((CharSequence)("Caused by exception:" + x.getCause().getClass().getName()));
                this.getLog().debug((CharSequence)("Caused by exception message:" + x.getCause().getMessage()));
            }
            throw new MojoExecutionException("Failed to generate a working set of features. " + x.getMessage(), (Exception)((Object)x));
        }
        HashSet missingLibertyFeatures = new HashSet();
        if (scannedFeatureList != null) {
            missingLibertyFeatures.addAll(scannedFeatureList);
            servUtil.setLowerCaseFeatures(false);
            Set<Object> userDefinedFeatures = this.optimize ? existingFeatures : servUtil.getServerFeatures(this.configDirectory, this.serverXmlFile, new HashMap(), generatedFiles);
            this.getLog().debug((CharSequence)("User defined features:" + userDefinedFeatures));
            servUtil.setLowerCaseFeatures(true);
            if (userDefinedFeatures != null) {
                missingLibertyFeatures.removeAll(userDefinedFeatures);
            }
        }
        this.getLog().debug((CharSequence)("Features detected by binary scanner which are not in server.xml" + missingLibertyFeatures));
        File newServerXmlSrc = new File(this.configDirectory, "configDropins/overrides/generated-features.xml");
        File serverXml = this.findConfigFile("server.xml", this.serverXmlFile);
        ServerConfigXmlDocument doc = this.getServerXmlDocFromConfig(serverXml);
        this.getLog().debug((CharSequence)("Xml document we'll try to update after generate features doc=" + doc + " file=" + serverXml));
        try {
            if (missingLibertyFeatures.size() > 0) {
                Set<String> existingGeneratedFeatures = this.getGeneratedFeatures(servUtil, newServerXmlSrc);
                if (!missingLibertyFeatures.equals(existingGeneratedFeatures)) {
                    ServerConfigXmlDocument configDocument = ServerConfigXmlDocument.newInstance();
                    configDocument.createComment(HEADER);
                    Element featureManagerElem = configDocument.createFeatureManager();
                    configDocument.createComment(featureManagerElem, GENERATED_FEATURES_COMMENT);
                    for (String missing : missingLibertyFeatures) {
                        this.getLog().debug((CharSequence)String.format("Adding missing feature %s to %s.", missing, "configDropins/overrides/generated-features.xml"));
                        configDocument.createFeature(missing);
                    }
                    this.getLog().info((CharSequence)("Generated the following features: " + missingLibertyFeatures));
                    configDocument.writeXMLDocument(newServerXmlSrc);
                    this.getLog().debug((CharSequence)("Created file " + newServerXmlSrc));
                    this.addGenerationCommentToConfig(doc, serverXml);
                } else {
                    this.getLog().info((CharSequence)("Regenerated the following features: " + missingLibertyFeatures));
                }
            } else {
                this.getLog().info((CharSequence)"No additional features were generated.");
                if (newServerXmlSrc.exists()) {
                    ServerConfigXmlDocument configDocument = ServerConfigXmlDocument.newInstance();
                    configDocument.createComment(HEADER);
                    Element featureManagerElem = configDocument.createFeatureManager();
                    configDocument.createComment(featureManagerElem, NO_NEW_FEATURES_COMMENT);
                    configDocument.writeXMLDocument(newServerXmlSrc);
                }
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            this.getLog().debug((CharSequence)"Exception creating the server features file", (Throwable)e);
            throw new MojoExecutionException("Automatic generation of features failed. Error attempting to create the generated-features.xml. Ensure your id has write permission to the server configuration directory.", e);
        }
    }

    private Set<String> getServerFeatures(ServerFeatureUtil servUtil, Set<String> generatedFiles, boolean excludeGenerated) {
        servUtil.setLowerCaseFeatures(false);
        HashSet<String> existingFeatures = servUtil.getServerFeatures(this.configDirectory, this.serverXmlFile, new HashMap(), excludeGenerated ? generatedFiles : null);
        if (existingFeatures == null) {
            existingFeatures = new HashSet<String>();
        }
        servUtil.setLowerCaseFeatures(true);
        return existingFeatures;
    }

    private Set<String> getGeneratedFeatures(ServerFeatureUtil servUtil, File generatedFeaturesFile) {
        servUtil.setLowerCaseFeatures(false);
        HashSet<String> genFeatSet = new HashSet<String>();
        servUtil.getServerXmlFeatures(genFeatSet, this.configDirectory, generatedFeaturesFile, null, null);
        servUtil.setLowerCaseFeatures(true);
        return genFeatSet;
    }

    private File getBinaryScannerJarFromRepository() throws PluginExecutionException {
        try {
            return this.getArtifact("com.ibm.websphere.appmod.tools", "binary-app-scanner", "jar", "[21.0.0.5-SNAPSHOT,)").getFile();
        }
        catch (Exception e) {
            throw new PluginExecutionException("Could not retrieve the artifact com.ibm.websphere.appmod.tools.binary-app-scanner needed for liberty:generate-features. Ensure you have a connection to Maven Central or another repository that contains the com.ibm.websphere.appmod.tools.binary-app-scanner.jar configured in your pom.xml.", (Throwable)e);
        }
    }

    private File findConfigFile(String fileName, File specificFile) {
        if (specificFile != null && specificFile.exists()) {
            return specificFile;
        }
        File f = new File(this.configDirectory, fileName);
        if (this.configDirectory != null && f.exists()) {
            return f;
        }
        return null;
    }

    private ServerConfigXmlDocument getServerXmlDocFromConfig(File serverXml) {
        if (serverXml == null || !serverXml.exists()) {
            return null;
        }
        try {
            return ServerConfigXmlDocument.newInstance((File)serverXml);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            this.getLog().debug((CharSequence)"Exception creating server.xml object model", (Throwable)e);
            return null;
        }
    }

    private void removeGenerationCommentFromConfig(ServerConfigXmlDocument doc, File serverXml) {
        if (doc == null) {
            return;
        }
        try {
            doc.removeFMComment(FEATURES_FILE_MESSAGE);
            doc.writeXMLDocument(serverXml);
        }
        catch (IOException | TransformerException e) {
            this.getLog().debug((CharSequence)"Exception removing comment from server.xml", (Throwable)e);
        }
    }

    private void addGenerationCommentToConfig(ServerConfigXmlDocument doc, File serverXml) {
        if (doc == null) {
            return;
        }
        try {
            if (doc.createFMComment(FEATURES_FILE_MESSAGE)) {
                doc.writeXMLDocument(serverXml);
                XmlDocument.addNewlineBeforeFirstElement((File)serverXml);
            }
        }
        catch (IOException | TransformerException e) {
            this.getLog().debug((CharSequence)"Exception adding comment to server.xml", (Throwable)e);
        }
    }

    private Set<String> getClassesDirectories(List<MavenProject> mavenProjects) throws MojoExecutionException {
        HashSet<String> dirs = new HashSet<String>();
        String classesDirName = null;
        this.getLog().debug((CharSequence)("For binary scanner gathering Java build output directories for Maven projects, size=" + mavenProjects.size()));
        for (MavenProject mavenProject : mavenProjects) {
            classesDirName = this.getClassesDirectory(mavenProject.getBuild().getOutputDirectory());
            if (classesDirName == null) continue;
            dirs.add(classesDirName);
        }
        for (String s : dirs) {
            this.getLog().debug((CharSequence)("Found dir:" + s));
        }
        return dirs;
    }

    private String getClassesDirectory(String outputDir) {
        File classesDir = new File(outputDir);
        try {
            if (classesDir.exists()) {
                return classesDir.getCanonicalPath();
            }
        }
        catch (IOException x) {
            String classesDirAbsPath = classesDir.getAbsolutePath();
            this.getLog().debug((CharSequence)("IOException obtaining canonical path name for a project's classes directory: " + classesDirAbsPath));
            return classesDirAbsPath;
        }
        return null;
    }

    public String getEEVersion(List<MavenProject> mavenProjects) {
        String eeVersion = null;
        if (mavenProjects != null) {
            HashSet<String> eeVersionsDetected = new HashSet<String>();
            for (MavenProject mavenProject : mavenProjects) {
                try {
                    String ver = this.getEEVersion(mavenProject);
                    this.getLog().debug((CharSequence)("Java and/or Jakarta EE umbrella dependency found in project: " + mavenProject.getName()));
                    if (ver == null) continue;
                    eeVersionsDetected.add(ver);
                }
                catch (NoUmbrellaDependencyException noUmbrellaDependencyException) {}
            }
            if (!eeVersionsDetected.isEmpty()) {
                eeVersion = (String)eeVersionsDetected.iterator().next();
                for (String ver : eeVersionsDetected) {
                    if (ver.compareTo(eeVersion) <= 0) continue;
                    eeVersion = ver;
                }
            }
            if (eeVersionsDetected.size() > 1) {
                this.getLog().debug((CharSequence)("Multiple Java and/or Jakarta EE versions found across multiple project modules, using the latest version (" + eeVersion + ") found to generate Liberty features."));
            }
        }
        return eeVersion;
    }

    private String getEEVersion(MavenProject project) throws NoUmbrellaDependencyException {
        if (project != null) {
            List dependencies = project.getDependencies();
            for (Dependency d : dependencies) {
                if (!d.getScope().equals("provided") || (!d.getGroupId().equals("javax") || !d.getArtifactId().equals("javaee-api")) && (!d.getGroupId().equals("jakarta.platform") || !d.getArtifactId().equals("jakarta.jakartaee-api"))) continue;
                return d.getVersion();
            }
        }
        throw new NoUmbrellaDependencyException();
    }

    public String getMPVersion(List<MavenProject> mavenProjects) {
        String mpVersion = null;
        if (mavenProjects != null) {
            HashSet<String> mpVersionsDetected = new HashSet<String>();
            for (MavenProject mavenProject : mavenProjects) {
                try {
                    String ver = this.getMPVersion(mavenProject);
                    this.getLog().debug((CharSequence)("MicroProfile umbrella dependency found in project: " + mavenProject.getName()));
                    if (ver == null) continue;
                    mpVersionsDetected.add(ver);
                }
                catch (NoUmbrellaDependencyException noUmbrellaDependencyException) {}
            }
            if (!mpVersionsDetected.isEmpty()) {
                mpVersion = (String)mpVersionsDetected.iterator().next();
                for (String ver : mpVersionsDetected) {
                    if (ver.compareTo(mpVersion) <= 0) continue;
                    mpVersion = ver;
                }
            }
            if (mpVersionsDetected.size() > 1) {
                this.getLog().debug((CharSequence)("Multiple MicroProfile versions found across multiple project modules, using the latest version (" + mpVersion + ") found to generate Liberty features."));
            }
        }
        return mpVersion;
    }

    public String getMPVersion(MavenProject project) throws NoUmbrellaDependencyException {
        if (project != null) {
            List dependencies = project.getDependencies();
            for (Dependency d : dependencies) {
                if (!d.getScope().equals("provided") || !d.getGroupId().equals("org.eclipse.microprofile") || !d.getArtifactId().equals("microprofile")) continue;
                return d.getVersion();
            }
        }
        throw new NoUmbrellaDependencyException();
    }

    private MavenProject getMavenProject(File buildFile) throws ProjectBuildingException {
        ProjectBuildingResult build = this.mavenProjectBuilder.build(buildFile, this.session.getProjectBuildingRequest().setResolveDependencies(true));
        return build.getProject();
    }

    public class NoUmbrellaDependencyException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    private class BinaryScannerHandler
    extends BinaryScannerUtil {
        BinaryScannerHandler(File scannerFile) {
            super(scannerFile);
        }

        public void debug(String msg) {
            GenerateFeaturesMojo.this.getLog().debug((CharSequence)msg);
        }

        public void debug(String msg, Throwable t) {
            GenerateFeaturesMojo.this.getLog().debug((CharSequence)msg, t);
        }

        public void error(String msg) {
            GenerateFeaturesMojo.this.getLog().error((CharSequence)msg);
        }

        public void warn(String msg) {
            GenerateFeaturesMojo.this.getLog().warn((CharSequence)msg);
        }

        public void info(String msg) {
            GenerateFeaturesMojo.this.getLog().info((CharSequence)msg);
        }

        public boolean isDebugEnabled() {
            return GenerateFeaturesMojo.this.getLog().isDebugEnabled();
        }
    }
}

