/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.maven.applications;

import io.openliberty.tools.common.plugins.config.LooseApplication;
import io.openliberty.tools.common.plugins.config.LooseConfigData;
import io.openliberty.tools.maven.utils.MavenProjectUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.w3c.dom.DOMException;

public class LooseWarApplication
extends LooseApplication {
    protected final MavenProject project;
    protected final Log log;

    public LooseWarApplication(MavenProject project, LooseConfigData config, Log log) {
        super(project.getBuild().getDirectory(), config);
        this.project = project;
        this.log = log;
    }

    public static boolean isExploded(MavenProject project) {
        boolean isExplodedWar = false;
        List<Path> dynamicWebResources = LooseWarApplication.getFilteredWebSourceDirectories(project);
        if (!dynamicWebResources.isEmpty() || LooseWarApplication.isUsingOverlays(project)) {
            isExplodedWar = true;
        }
        return isExplodedWar;
    }

    public boolean isExploded() {
        return LooseWarApplication.isExploded(this.project);
    }

    public void addSourceDir() throws IOException {
        Path warSourceDir = this.getWarSourceDirectory();
        this.config.addDir(warSourceDir.toFile(), "/");
    }

    public Path getWarSourceDirectory() {
        return LooseWarApplication.getWarSourceDirectory(this.project);
    }

    private static Path getWarSourceDirectory(MavenProject project) {
        Path baseDir = Paths.get(project.getBasedir().getAbsolutePath(), new String[0]);
        String warSourceDir = MavenProjectUtil.getPluginConfiguration(project, "org.apache.maven.plugins", "maven-war-plugin", "warSourceDirectory");
        if (warSourceDir == null) {
            warSourceDir = "src/main/webapp";
        }
        return baseDir.resolve(warSourceDir);
    }

    private Path getWebAppDirectory(MavenProject project) {
        Xpp3Dom webAppDirConfig;
        Xpp3Dom dom = project.getGoalConfiguration("org.apache.maven.plugins", "maven-war-plugin", null, null);
        String webAppDirStr = null;
        if (dom != null && (webAppDirConfig = dom.getChild("webappDirectory")) != null) {
            webAppDirStr = webAppDirConfig.getValue();
        }
        if (webAppDirStr != null) {
            return Paths.get(webAppDirStr, new String[0]);
        }
        return Paths.get(project.getBuild().getDirectory(), project.getBuild().getFinalName());
    }

    public static List<Path> getFilteredWebSourceDirectories(MavenProject project) {
        ArrayList<Path> retVal = new ArrayList<Path>();
        Path baseDirPath = Paths.get(project.getBasedir().getAbsolutePath(), new String[0]);
        for (Xpp3Dom resource : LooseWarApplication.getWebResourcesConfigurations(project)) {
            boolean filtered;
            Xpp3Dom dir = resource.getChild("directory");
            Xpp3Dom filtering = resource.getChild("filtering");
            if (dir == null || filtering == null || !(filtered = Boolean.parseBoolean(filtering.getValue()))) continue;
            retVal.add(baseDirPath.resolve(dir.getValue()));
        }
        if (LooseWarApplication.isFilteringDeploymentDescriptors(project)) {
            retVal.add(LooseWarApplication.getWarSourceDirectory(project));
        }
        return retVal;
    }

    public List<Path> getFilteredWebSourceDirectories() {
        return LooseWarApplication.getFilteredWebSourceDirectories(this.project);
    }

    private static boolean isFilteringDeploymentDescriptors(MavenProject project) {
        Xpp3Dom fdd;
        Boolean retVal = false;
        Xpp3Dom dom = project.getGoalConfiguration("org.apache.maven.plugins", "maven-war-plugin", null, null);
        if (dom != null && (fdd = dom.getChild("filteringDeploymentDescriptors")) != null) {
            retVal = Boolean.parseBoolean(fdd.getValue());
        }
        return retVal;
    }

    public boolean isFilteringDeploymentDescriptors() {
        return LooseWarApplication.isFilteringDeploymentDescriptors(this.project);
    }

    public static boolean isUsingOverlays(MavenProject project) {
        boolean overlaysEnabled = false;
        List<Dependency> overlayDependencies = LooseWarApplication.getWarDependencies(project);
        List<Xpp3Dom> overlayConfigurations = LooseWarApplication.getOverlayConfigurations(project);
        if (!overlayDependencies.isEmpty() || !overlayConfigurations.isEmpty()) {
            overlaysEnabled = true;
        }
        return overlaysEnabled;
    }

    private static List<Xpp3Dom> getOverlayConfigurations(MavenProject project) {
        Xpp3Dom[] overlayList;
        Xpp3Dom overlays;
        ArrayList<Xpp3Dom> retVal = new ArrayList<Xpp3Dom>();
        Xpp3Dom dom = project.getGoalConfiguration("org.apache.maven.plugins", "maven-war-plugin", null, null);
        if (dom != null && (overlays = dom.getChild("overlays")) != null && (overlayList = overlays.getChildren("overlay")) != null) {
            for (int i = 0; i < overlayList.length; ++i) {
                retVal.add(overlayList[i]);
            }
        }
        return retVal;
    }

    private static List<Dependency> getWarDependencies(MavenProject project) {
        ArrayList<Dependency> overlayDependencies = new ArrayList<Dependency>();
        List deps = project.getDependencies();
        for (Dependency dep : deps) {
            if (!dep.getType().equals("war")) continue;
            overlayDependencies.add(dep);
        }
        return overlayDependencies;
    }

    public static List<Xpp3Dom> getWebResourcesConfigurations(MavenProject project) {
        Xpp3Dom[] resources;
        Xpp3Dom web;
        ArrayList<Xpp3Dom> retVal = new ArrayList<Xpp3Dom>();
        Xpp3Dom dom = project.getGoalConfiguration("org.apache.maven.plugins", "maven-war-plugin", null, null);
        if (dom != null && (web = dom.getChild("webResources")) != null && (resources = web.getChildren("resource")) != null) {
            for (int i = 0; i < resources.length; ++i) {
                Xpp3Dom dir = resources[i].getChild("directory");
                if (dir == null) continue;
                retVal.add(resources[i]);
            }
        }
        return retVal;
    }

    private void addWebResourcesConfigurationPaths(boolean onlyUnfiltered) throws DOMException, IOException {
        HashSet<Path> handled = new HashSet<Path>();
        Path baseDirPath = Paths.get(this.project.getBasedir().getAbsolutePath(), new String[0]);
        for (Xpp3Dom resource : LooseWarApplication.getWebResourcesConfigurations(this.project)) {
            Xpp3Dom dir = resource.getChild("directory");
            Xpp3Dom target = resource.getChild("targetPath");
            Xpp3Dom filtering = resource.getChild("filtering");
            Path resolvedDir = baseDirPath.resolve(dir.getValue());
            if (handled.contains(resolvedDir)) {
                this.log.warn((CharSequence)("Ignoring webResources dir: " + dir.getValue() + ", already have entry for path: " + resolvedDir));
                continue;
            }
            if (onlyUnfiltered && filtering != null && Boolean.parseBoolean(filtering.getValue())) continue;
            String targetPath = "/";
            if (target != null) {
                targetPath = "/" + target.getValue();
            }
            this.addOutputDir(this.getDocumentRoot(), resolvedDir.toFile(), targetPath);
            handled.add(resolvedDir);
        }
    }

    public void addAllWebResourcesConfigurationPaths() throws DOMException, IOException {
        this.addWebResourcesConfigurationPaths(false);
    }

    public void addNonFilteredWebResourcesConfigurationPaths() throws DOMException, IOException {
        this.addWebResourcesConfigurationPaths(true);
    }

    public Path getWebAppDirectory() {
        return this.getWebAppDirectory(this.project);
    }
}

