/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.util.internal;

import io.netty5.util.internal.Cleaner;
import io.netty5.util.internal.PlatformDependent;
import io.netty5.util.internal.PlatformDependent0;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import java.security.AccessController;

final class CleanerJava9
implements Cleaner {
    private static final InternalLogger logger;
    private static final MethodHandle INVOKE_CLEANER_HANDLE;

    CleanerJava9() {
    }

    static boolean isSupported() {
        return INVOKE_CLEANER_HANDLE != null;
    }

    @Override
    public void freeDirectBuffer(ByteBuffer buffer) {
        if (System.getSecurityManager() == null) {
            try {
                INVOKE_CLEANER_HANDLE.invokeExact(buffer);
            }
            catch (RuntimeException exception) {
                throw exception;
            }
            catch (Throwable throwable) {
                PlatformDependent.throwException(throwable);
            }
        } else {
            CleanerJava9.freeDirectBufferPrivileged(buffer);
        }
    }

    private static void freeDirectBufferPrivileged(ByteBuffer buffer) {
        Exception error = AccessController.doPrivileged(() -> {
            try {
                INVOKE_CLEANER_HANDLE.invokeExact(PlatformDependent0.UNSAFE, buffer);
            }
            catch (RuntimeException exception) {
                return exception;
            }
            catch (Throwable throwable) {
                PlatformDependent.throwException(throwable);
            }
            return null;
        });
        if (error != null) {
            PlatformDependent.throwException(error);
        }
    }

    static {
        Throwable error;
        MethodHandle invokeCleanerHandle;
        logger = InternalLoggerFactory.getInstance(CleanerJava9.class);
        if (PlatformDependent0.hasUnsafe()) {
            ByteBuffer buffer = ByteBuffer.allocateDirect(1);
            Object maybeInvokeMethodHandle = AccessController.doPrivileged(() -> {
                try {
                    MethodHandles.Lookup lookup = MethodHandles.lookup();
                    MethodHandle m = lookup.findVirtual(PlatformDependent0.UNSAFE.getClass(), "invokeCleaner", MethodType.methodType(Void.TYPE, ByteBuffer.class)).bindTo(PlatformDependent0.UNSAFE);
                    m.invokeExact(buffer);
                    return m;
                }
                catch (Throwable cause) {
                    return cause;
                }
            });
            if (maybeInvokeMethodHandle instanceof Throwable) {
                invokeCleanerHandle = null;
                error = (Throwable)maybeInvokeMethodHandle;
            } else {
                invokeCleanerHandle = (MethodHandle)maybeInvokeMethodHandle;
                error = null;
            }
        } else {
            invokeCleanerHandle = null;
            error = new UnsupportedOperationException("sun.misc.Unsafe unavailable");
        }
        if (error == null) {
            logger.debug("java.nio.ByteBuffer.cleaner(): available");
        } else {
            logger.debug("java.nio.ByteBuffer.cleaner(): unavailable", error);
        }
        INVOKE_CLEANER_HANDLE = invokeCleanerHandle;
    }
}

