/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.util.concurrent;

import io.netty5.util.concurrent.DefaultThreadFactory;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.GlobalEventExecutor;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.concurrent.PromiseTask;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class UnorderedThreadPoolEventExecutor
implements EventExecutor {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(UnorderedThreadPoolEventExecutor.class);
    private final Promise<Void> terminationFuture = GlobalEventExecutor.INSTANCE.newPromise();
    private final InnerScheduledThreadPoolExecutor executor;

    public UnorderedThreadPoolEventExecutor(int corePoolSize) {
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(UnorderedThreadPoolEventExecutor.class);
        this.executor = new InnerScheduledThreadPoolExecutor(this, corePoolSize, threadFactory);
    }

    public UnorderedThreadPoolEventExecutor(int corePoolSize, ThreadFactory threadFactory) {
        this.executor = new InnerScheduledThreadPoolExecutor(this, corePoolSize, threadFactory);
    }

    public UnorderedThreadPoolEventExecutor(int corePoolSize, RejectedExecutionHandler handler) {
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(UnorderedThreadPoolEventExecutor.class);
        this.executor = new InnerScheduledThreadPoolExecutor(this, corePoolSize, threadFactory, handler);
    }

    public UnorderedThreadPoolEventExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        this.executor = new InnerScheduledThreadPoolExecutor(this, corePoolSize, threadFactory, handler);
    }

    @Override
    public boolean inEventLoop(Thread thread) {
        return false;
    }

    @Override
    public boolean isShuttingDown() {
        return this.isShutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.awaitTermination(timeout, unit);
    }

    @Override
    public Future<Void> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        this.executor.shutdown();
        return this.terminationFuture();
    }

    @Override
    public Future<Void> terminationFuture() {
        return this.terminationFuture.asFuture();
    }

    @Override
    public Future<Void> schedule(Runnable task, long delay, TimeUnit unit) {
        return (Future)((Object)this.executor.schedule(task, delay, unit));
    }

    @Override
    public <V> Future<V> schedule(Callable<V> task, long delay, TimeUnit unit) {
        return (Future)((Object)this.executor.schedule(task, delay, unit));
    }

    @Override
    public Future<Void> scheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
        return (Future)((Object)this.executor.scheduleAtFixedRate(task, initialDelay, period, unit));
    }

    @Override
    public Future<Void> scheduleWithFixedDelay(Runnable task, long initialDelay, long delay, TimeUnit unit) {
        return (Future)((Object)this.executor.scheduleWithFixedDelay(task, initialDelay, delay, unit));
    }

    @Override
    public Future<Void> submit(Runnable task) {
        return (Future)((Object)this.executor.submit(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return (Future)((Object)this.executor.submit(task, result));
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return (Future)((Object)this.executor.submit(task));
    }

    @Override
    public void execute(Runnable task) {
        this.executor.schedule(new NonNotifyRunnable(task), 0L, TimeUnit.NANOSECONDS);
    }

    BlockingQueue<Runnable> getQueue() {
        return this.executor.getQueue();
    }

    private static final class InnerScheduledThreadPoolExecutor
    extends ScheduledThreadPoolExecutor {
        private final EventExecutor eventExecutor;

        InnerScheduledThreadPoolExecutor(EventExecutor eventExecutor, int corePoolSize, ThreadFactory threadFactory) {
            super(corePoolSize, threadFactory);
            this.eventExecutor = eventExecutor;
        }

        InnerScheduledThreadPoolExecutor(EventExecutor eventExecutor, int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
            super(corePoolSize, threadFactory, handler);
            this.eventExecutor = eventExecutor;
        }

        @Override
        protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> task) {
            return runnable instanceof NonNotifyRunnable ? task : new RunnableScheduledFutureTask(this.eventExecutor, runnable, task);
        }

        @Override
        protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> callable, RunnableScheduledFuture<V> task) {
            return new RunnableScheduledFutureTask<V>(this.eventExecutor, callable, task);
        }
    }

    private static final class NonNotifyRunnable
    implements Runnable {
        private final Runnable task;

        NonNotifyRunnable(Runnable task) {
            this.task = task;
        }

        @Override
        public void run() {
            this.task.run();
        }
    }

    private static final class RunnableScheduledFutureTask<V>
    extends PromiseTask<V>
    implements RunnableScheduledFuture<V> {
        private final RunnableScheduledFuture<V> future;

        RunnableScheduledFutureTask(EventExecutor executor, Runnable runnable, RunnableScheduledFuture<V> future) {
            super(executor, runnable, null);
            this.future = future;
        }

        RunnableScheduledFutureTask(EventExecutor executor, Callable<V> callable, RunnableScheduledFuture<V> future) {
            super(executor, callable);
            this.future = future;
        }

        @Override
        public void run() {
            block5: {
                if (!this.isPeriodic()) {
                    super.run();
                } else if (!this.isDone()) {
                    try {
                        this.future.run();
                    }
                    catch (Throwable cause) {
                        if (this.tryFailureInternal(cause)) break block5;
                        logger.warn("Failure during execution of task", cause);
                    }
                }
            }
        }

        @Override
        public boolean isPeriodic() {
            return this.future.isPeriodic();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.future.getDelay(unit);
        }

        @Override
        public int compareTo(Delayed o) {
            return this.future.compareTo(o);
        }
    }
}

