/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.util.concurrent;

import io.netty5.util.concurrent.AbstractScheduledEventExecutor;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.FutureCompletionStage;
import io.netty5.util.concurrent.FutureContextListener;
import io.netty5.util.concurrent.FutureListener;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.concurrent.RunnableScheduledFuture;
import io.netty5.util.internal.DefaultPriorityQueue;
import io.netty5.util.internal.StringUtil;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;

final class RunnableScheduledFutureAdapter<V>
implements AbstractScheduledEventExecutor.RunnableScheduledFutureNode<V> {
    private static final AtomicLong NEXT_TASK_ID = new AtomicLong();
    private final long id = NEXT_TASK_ID.getAndIncrement();
    private long deadlineNanos;
    private final long periodNanos;
    private int queueIndex = -1;
    private final AbstractScheduledEventExecutor executor;
    private final Promise<V> promise;
    private final Future<V> future;
    private final Callable<V> callable;

    RunnableScheduledFutureAdapter(AbstractScheduledEventExecutor executor, Promise<V> promise, Callable<V> callable, long deadlineNanos, long periodNanos) {
        this.executor = Objects.requireNonNull(executor, "executor");
        this.promise = Objects.requireNonNull(promise, "promise");
        this.future = promise.asFuture();
        this.callable = Objects.requireNonNull(callable, "callable");
        this.deadlineNanos = deadlineNanos;
        this.periodNanos = periodNanos;
    }

    @Override
    public EventExecutor executor() {
        return this.executor;
    }

    @Override
    public long deadlineNanos() {
        return this.deadlineNanos;
    }

    @Override
    public long delayNanos() {
        return this.delayNanos(this.executor.getCurrentTimeNanos());
    }

    @Override
    public long delayNanos(long currentTimeNanos) {
        return RunnableScheduledFutureAdapter.deadlineToDelayNanos(currentTimeNanos, this.deadlineNanos);
    }

    private static long deadlineToDelayNanos(long currentTimeNanos, long deadlineNanos) {
        return deadlineNanos == 0L ? 0L : Math.max(0L, deadlineNanos - currentTimeNanos);
    }

    @Override
    public int compareTo(RunnableScheduledFuture<?> o) {
        if (this == o) {
            return 0;
        }
        RunnableScheduledFutureAdapter that = (RunnableScheduledFutureAdapter)o;
        long d = this.deadlineNanos() - that.deadlineNanos();
        if (d < 0L) {
            return -1;
        }
        if (d > 0L) {
            return 1;
        }
        if (this.id < that.id) {
            return -1;
        }
        if (this.id == that.id) {
            throw new Error();
        }
        return 1;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RunnableScheduledFutureAdapter) {
            RunnableScheduledFutureAdapter adaptor = (RunnableScheduledFutureAdapter)obj;
            return this.id == adaptor.id;
        }
        return false;
    }

    @Override
    public void run() {
        try {
            if (!this.isPeriodic()) {
                if (this.promise.setUncancellable()) {
                    V result = this.callable.call();
                    this.promise.setSuccess(result);
                }
            } else if (!this.isCancelled()) {
                this.callable.call();
                if (!this.executor.isShutdown()) {
                    long p = this.periodNanos;
                    this.deadlineNanos = p > 0L ? (this.deadlineNanos += p) : this.executor.getCurrentTimeNanos() - p;
                    if (!this.isCancelled()) {
                        this.executor.schedule(this);
                    }
                }
            }
        }
        catch (Throwable cause) {
            this.promise.setFailure(cause);
        }
    }

    @Override
    public boolean cancel() {
        boolean canceled = this.future.cancel();
        if (canceled) {
            this.executor.removeScheduled(this);
        }
        return canceled;
    }

    @Override
    public boolean isSuccess() {
        return this.promise.isSuccess();
    }

    @Override
    public boolean isFailed() {
        return this.promise.isFailed();
    }

    @Override
    public boolean isCancellable() {
        return this.promise.isCancellable();
    }

    @Override
    public Throwable cause() {
        return this.promise.cause();
    }

    @Override
    public RunnableScheduledFuture<V> addListener(FutureListener<? super V> listener) {
        this.future.addListener(listener);
        return this;
    }

    @Override
    public <C> RunnableScheduledFuture<V> addListener(C context, FutureContextListener<? super C, ? super V> listener) {
        this.future.addListener(context, listener);
        return this;
    }

    @Override
    public V getNow() {
        return this.promise.getNow();
    }

    @Override
    public boolean isPeriodic() {
        return this.periodNanos != 0L;
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.promise.isDone();
    }

    @Override
    public FutureCompletionStage<V> asStage() {
        return this.future.asStage();
    }

    @Override
    public int priorityQueueIndex(DefaultPriorityQueue<?> queue) {
        return this.queueIndex;
    }

    @Override
    public void priorityQueueIndex(DefaultPriorityQueue<?> queue, int i) {
        this.queueIndex = i;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64).append(StringUtil.simpleClassName(this)).append('@').append(Integer.toHexString(this.hashCode()));
        if (!this.isDone()) {
            buf.append("(incomplete)");
        } else {
            Throwable cause = this.cause();
            if (cause != null) {
                buf.append("(failure: ").append(cause).append(')');
            } else {
                V result = this.getNow();
                if (result == null) {
                    buf.append("(success)");
                } else {
                    buf.append("(success: ").append(result).append(')');
                }
            }
        }
        return buf.append(" task: ").append(this.callable).append(", id: ").append(this.id).append(", deadline: ").append(this.deadlineNanos).append(", period: ").append(this.periodNanos).append(')').toString();
    }
}

