/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.util.concurrent;

import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.FutureCompletionStage;
import io.netty5.util.concurrent.FutureContextListener;
import io.netty5.util.concurrent.FutureListener;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.concurrent.RunnableFuture;
import io.netty5.util.internal.StringUtil;
import java.util.Objects;
import java.util.concurrent.Callable;

final class RunnableFutureAdapter<V>
implements RunnableFuture<V> {
    private final Promise<V> promise;
    private final Future<V> future;
    private final Callable<V> task;

    RunnableFutureAdapter(Promise<V> promise, Callable<V> task) {
        this.promise = Objects.requireNonNull(promise, "promise");
        this.task = Objects.requireNonNull(task, "task");
        this.future = promise.asFuture();
    }

    @Override
    public EventExecutor executor() {
        return this.promise.executor();
    }

    @Override
    public boolean isSuccess() {
        return this.promise.isSuccess();
    }

    @Override
    public boolean isFailed() {
        return this.promise.isFailed();
    }

    @Override
    public boolean isCancellable() {
        return this.promise.isCancellable();
    }

    @Override
    public Throwable cause() {
        return this.promise.cause();
    }

    @Override
    public RunnableFuture<V> addListener(FutureListener<? super V> listener) {
        this.future.addListener(listener);
        return this;
    }

    @Override
    public <C> RunnableFuture<V> addListener(C context, FutureContextListener<? super C, ? super V> listener) {
        this.future.addListener(context, listener);
        return this;
    }

    @Override
    public V getNow() {
        return this.promise.getNow();
    }

    @Override
    public void run() {
        try {
            if (this.promise.setUncancellable()) {
                V result = this.task.call();
                this.promise.setSuccess(result);
            }
        }
        catch (Throwable e) {
            this.promise.setFailure(e);
        }
    }

    @Override
    public boolean cancel() {
        return this.future.cancel();
    }

    @Override
    public boolean isCancelled() {
        return this.promise.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.promise.isDone();
    }

    @Override
    public FutureCompletionStage<V> asStage() {
        return this.future.asStage();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64).append(StringUtil.simpleClassName(this)).append('@').append(Integer.toHexString(this.hashCode()));
        if (!this.isDone()) {
            buf.append("(incomplete)");
        } else {
            Throwable cause = this.cause();
            if (cause != null) {
                buf.append("(failure: ").append(cause).append(')');
            } else {
                V result = this.getNow();
                if (result == null) {
                    buf.append("(success)");
                } else {
                    buf.append("(success: ").append(result).append(')');
                }
            }
        }
        return buf.append(" task: ").append(this.task).append(')').toString();
    }
}

