/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.util.concurrent;

import io.netty5.util.concurrent.RejectedExecutionHandler;
import io.netty5.util.internal.ObjectUtil;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

public final class RejectedExecutionHandlers {
    private static final RejectedExecutionHandler REJECT = (task, executor) -> {
        throw new RejectedExecutionException();
    };

    private RejectedExecutionHandlers() {
    }

    public static RejectedExecutionHandler reject() {
        return REJECT;
    }

    public static RejectedExecutionHandler backoff(int retries, long backoffAmount, TimeUnit unit) {
        ObjectUtil.checkPositive(retries, "retries");
        long backOffNanos = unit.toNanos(backoffAmount);
        return (task, executor) -> {
            if (!executor.inEventLoop()) {
                for (int i = 0; i < retries; ++i) {
                    executor.wakeup(false);
                    LockSupport.parkNanos(backOffNanos);
                    if (!executor.offerTask(task)) continue;
                    return;
                }
            }
            throw new RejectedExecutionException();
        };
    }
}

