/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.util.concurrent;

import io.netty5.util.concurrent.DefaultThreadFactory;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.EventExecutorGroup;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.FutureListener;
import io.netty5.util.concurrent.GlobalEventExecutor;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.concurrent.RejectedExecutionHandler;
import io.netty5.util.concurrent.RejectedExecutionHandlers;
import io.netty5.util.concurrent.SingleThreadEventExecutor;
import io.netty5.util.concurrent.ThreadPerTaskExecutor;
import io.netty5.util.internal.EmptyArrays;
import io.netty5.util.internal.ObjectUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class MultithreadEventExecutorGroup
implements EventExecutorGroup {
    private final EventExecutor[] children;
    private final List<EventExecutor> readonlyChildren;
    private final AtomicInteger terminatedChildren = new AtomicInteger();
    private final Promise<Void> terminationFuture = GlobalEventExecutor.INSTANCE.newPromise();
    private final boolean powerOfTwo;
    private final AtomicLong idx = new AtomicLong();

    public MultithreadEventExecutorGroup(int nThreads, ThreadFactory threadFactory) {
        this(nThreads, threadFactory, SingleThreadEventExecutor.DEFAULT_MAX_PENDING_EXECUTOR_TASKS, RejectedExecutionHandlers.reject());
    }

    public MultithreadEventExecutorGroup(int nThreads, Executor executor) {
        this(nThreads, executor, SingleThreadEventExecutor.DEFAULT_MAX_PENDING_EXECUTOR_TASKS, RejectedExecutionHandlers.reject());
    }

    public MultithreadEventExecutorGroup(int nThreads, ThreadFactory threadFactory, int maxPendingTasks, RejectedExecutionHandler rejectedHandler) {
        this(nThreads, threadFactory, maxPendingTasks, rejectedHandler, EmptyArrays.EMPTY_OBJECTS);
    }

    public MultithreadEventExecutorGroup(int nThreads, Executor executor, int maxPendingTasks, RejectedExecutionHandler rejectedHandler) {
        this(nThreads, executor, maxPendingTasks, rejectedHandler, EmptyArrays.EMPTY_OBJECTS);
    }

    protected MultithreadEventExecutorGroup(int nThreads, ThreadFactory threadFactory, int maxPendingTasks, RejectedExecutionHandler rejectedHandler, Object ... args) {
        this(nThreads, threadFactory == null ? null : new ThreadPerTaskExecutor(threadFactory), maxPendingTasks, rejectedHandler, args);
    }

    protected MultithreadEventExecutorGroup(int nThreads, Executor executor, int maxPendingTasks, RejectedExecutionHandler rejectedHandler, Object ... args) {
        ObjectUtil.checkPositive(nThreads, "nThreads");
        if (executor == null) {
            executor = new ThreadPerTaskExecutor(new DefaultThreadFactory(this.getClass()));
        }
        this.children = new EventExecutor[nThreads];
        this.powerOfTwo = MultithreadEventExecutorGroup.isPowerOfTwo(this.children.length);
        for (int i = 0; i < nThreads; ++i) {
            boolean success = false;
            try {
                this.children[i] = this.newChild(executor, maxPendingTasks, rejectedHandler, args);
                success = true;
                continue;
            }
            catch (Exception e) {
                throw new IllegalStateException("failed to create a child event executor", e);
            }
            finally {
                if (!success) {
                    int j;
                    for (j = 0; j < i; ++j) {
                        this.children[j].shutdownGracefully();
                    }
                    for (j = 0; j < i; ++j) {
                        EventExecutor e = this.children[j];
                        try {
                            while (!e.isTerminated()) {
                                e.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
                            }
                            continue;
                        }
                        catch (InterruptedException interrupted) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                    }
                }
            }
        }
        FutureListener terminationListener = future -> {
            if (this.terminatedChildren.incrementAndGet() == this.children.length) {
                this.terminationFuture.setSuccess(null);
            }
        };
        for (EventExecutor e : this.children) {
            e.terminationFuture().addListener(terminationListener);
        }
        this.readonlyChildren = Collections.unmodifiableList(Arrays.asList(this.children));
    }

    protected final List<EventExecutor> executors() {
        return this.readonlyChildren;
    }

    @Override
    public EventExecutor next() {
        if (this.powerOfTwo) {
            return this.children[(int)this.idx.getAndIncrement() & this.children.length - 1];
        }
        return this.children[(int)Math.abs(this.idx.getAndIncrement() % (long)this.children.length)];
    }

    private static boolean isPowerOfTwo(int val) {
        return (val & -val) == val;
    }

    @Override
    public Iterator<EventExecutor> iterator() {
        return this.executors().iterator();
    }

    public final int executorCount() {
        return this.executors().size();
    }

    protected EventExecutor newChild(Executor executor, int maxPendingTasks, RejectedExecutionHandler rejectedExecutionHandler, Object ... args) {
        assert (args.length == 0);
        return new SingleThreadEventExecutor(executor, maxPendingTasks, rejectedExecutionHandler);
    }

    @Override
    public final Future<Void> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        for (EventExecutor l : this.children) {
            l.shutdownGracefully(quietPeriod, timeout, unit);
        }
        return this.terminationFuture();
    }

    @Override
    public final Future<Void> terminationFuture() {
        return this.terminationFuture.asFuture();
    }

    @Override
    public final boolean isShuttingDown() {
        for (EventExecutor l : this.children) {
            if (l.isShuttingDown()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean isShutdown() {
        for (EventExecutor l : this.children) {
            if (l.isShutdown()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean isTerminated() {
        for (EventExecutor l : this.children) {
            if (l.isTerminated()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        block0: for (EventExecutor l : this.children) {
            long timeLeft;
            while ((timeLeft = deadline - System.nanoTime()) > 0L) {
                if (!l.awaitTermination(timeLeft, TimeUnit.NANOSECONDS)) continue;
                continue block0;
            }
            break block0;
        }
        return this.isTerminated();
    }
}

