/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.util.concurrent;

import io.netty5.util.concurrent.DefaultPromise;
import io.netty5.util.concurrent.EventExecutorGroup;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.FuturePromiseFactory;
import io.netty5.util.concurrent.Promise;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public interface EventExecutor
extends EventExecutorGroup,
FuturePromiseFactory {
    @Override
    default public EventExecutor next() {
        return this;
    }

    @Override
    default public Iterator<EventExecutor> iterator() {
        return Collections.singleton(this).iterator();
    }

    default public boolean inEventLoop() {
        return this.inEventLoop(Thread.currentThread());
    }

    public boolean inEventLoop(Thread var1);

    @Override
    default public <V> Promise<V> newPromise() {
        return new DefaultPromise(this);
    }

    @Override
    default public <V> Future<V> newSucceededFuture(V result) {
        return DefaultPromise.newSuccessfulPromise(this, result).asFuture();
    }

    @Override
    default public <V> Future<V> newFailedFuture(Throwable cause) {
        return DefaultPromise.newFailedPromise(this, cause).asFuture();
    }

    @Override
    public Future<Void> submit(Runnable var1);

    @Override
    public <T> Future<T> submit(Runnable var1, T var2);

    @Override
    public <T> Future<T> submit(Callable<T> var1);

    @Override
    public Future<Void> schedule(Runnable var1, long var2, TimeUnit var4);

    @Override
    public <V> Future<V> schedule(Callable<V> var1, long var2, TimeUnit var4);

    @Override
    public Future<Void> scheduleAtFixedRate(Runnable var1, long var2, long var4, TimeUnit var6);

    @Override
    public Future<Void> scheduleWithFixedDelay(Runnable var1, long var2, long var4, TimeUnit var6);

    @Override
    public void execute(Runnable var1);
}

