/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.util.concurrent;

import io.netty5.util.concurrent.BlockingOperationException;
import io.netty5.util.concurrent.DefaultFutureListeners;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.FutureCompletionStage;
import io.netty5.util.concurrent.FutureContextListener;
import io.netty5.util.concurrent.FutureListener;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.internal.StringUtil;
import io.netty5.util.internal.ThrowableUtil;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class DefaultPromise<V>
implements Promise<V>,
Future<V>,
FutureCompletionStage<V>,
java.util.concurrent.Future<V> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultPromise.class);
    private static final InternalLogger rejectedExecutionLogger = InternalLoggerFactory.getInstance(DefaultPromise.class.getName() + ".rejectedExecution");
    private static final AtomicReferenceFieldUpdater<DefaultPromise, Object> RESULT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultPromise.class, Object.class, "result");
    private static final Object SUCCESS = new Object();
    private static final Object UNCANCELLABLE = new Object();
    private static final CauseHolder CANCELLATION_CAUSE_HOLDER = new CauseHolder(StacklessCancellationException.newInstance(DefaultPromise.class, "cancel(...)"));
    private static final StackTraceElement[] CANCELLATION_STACK = DefaultPromise.CANCELLATION_CAUSE_HOLDER.cause.getStackTrace();
    static final Object NULL_CONTEXT = new Object();
    private volatile Object result;
    private final EventExecutor executor;
    private Object listeners;
    private short waiters;
    private static final Executor SAME_AS_FUTURE = task -> {
        throw new UnsupportedOperationException("Marker executor. Should never be called!");
    };

    protected DefaultPromise(EventExecutor executor) {
        this.executor = Objects.requireNonNull(executor, "executor");
    }

    static <V> Promise<V> newSuccessfulPromise(EventExecutor executor, V result) {
        return new DefaultPromise<V>(executor, result);
    }

    static <V> Promise<V> newFailedPromise(EventExecutor executor, Throwable cause) {
        return new DefaultPromise<V>(cause, executor);
    }

    private DefaultPromise(EventExecutor executor, Object result) {
        this.executor = Objects.requireNonNull(executor, "executor");
        this.result = result == null ? SUCCESS : result;
    }

    private DefaultPromise(Throwable cause, EventExecutor executor) {
        this.executor = Objects.requireNonNull(executor, "executor");
        this.result = new CauseHolder(Objects.requireNonNull(cause, "cause"));
    }

    @Override
    public Promise<V> setSuccess(V result) {
        if (this.setSuccess0(result)) {
            return this;
        }
        throw new IllegalStateException("complete already: " + this);
    }

    @Override
    public boolean trySuccess(V result) {
        return this.setSuccess0(result);
    }

    @Override
    public Promise<V> setFailure(Throwable cause) {
        if (this.setFailure0(cause)) {
            return this;
        }
        throw new IllegalStateException("complete already: " + this, cause);
    }

    @Override
    public boolean tryFailure(Throwable cause) {
        return this.setFailure0(cause);
    }

    @Override
    public boolean setUncancellable() {
        return RESULT_UPDATER.compareAndSet(this, null, UNCANCELLABLE);
    }

    @Override
    public Future<V> asFuture() {
        return this;
    }

    @Override
    public boolean isSuccess() {
        Object result = this.result;
        return result != null && result != UNCANCELLABLE && !(result instanceof CauseHolder);
    }

    @Override
    public boolean isFailed() {
        return this.result instanceof CauseHolder;
    }

    @Override
    public boolean isCancellable() {
        return this.result == null;
    }

    @Override
    public Throwable cause() {
        return this.cause0(this.result);
    }

    private Throwable cause0(Object result) {
        if (!DefaultPromise.isDone0(result)) {
            throw new IllegalStateException("Cannot call cause() on a future that has not completed.");
        }
        if (!(result instanceof CauseHolder)) {
            return null;
        }
        if (result == CANCELLATION_CAUSE_HOLDER) {
            LeanCancellationException ce = new LeanCancellationException();
            if (RESULT_UPDATER.compareAndSet(this, CANCELLATION_CAUSE_HOLDER, new CauseHolder(ce))) {
                return ce;
            }
            result = this.result;
        }
        return ((CauseHolder)result).cause;
    }

    @Override
    public Future<V> addListener(FutureListener<? super V> listener) {
        Objects.requireNonNull(listener, "listener");
        this.addListener0(listener, null);
        if (this.isDone()) {
            this.notifyListeners();
        }
        return this;
    }

    @Override
    public <C> Future<V> addListener(C context, FutureContextListener<? super C, ? super V> listener) {
        Objects.requireNonNull(listener, "listener");
        this.addListener0(listener, context == null ? NULL_CONTEXT : context);
        if (this.isDone()) {
            this.notifyListeners();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FutureCompletionStage<V> await() throws InterruptedException {
        if (this.isDone()) {
            return this;
        }
        if (Thread.interrupted()) {
            throw new InterruptedException(this.toString());
        }
        this.checkDeadLock();
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            while (!this.isDone()) {
                this.incWaiters();
                try {
                    this.wait();
                }
                finally {
                    this.decWaiters();
                }
            }
        }
        return this;
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.await0(unit.toNanos(timeout), true);
    }

    @Override
    public V getNow() {
        Object result = this.result;
        if (!DefaultPromise.isDone0(result)) {
            throw new IllegalStateException("Cannot call getNow() on a future that has not completed.");
        }
        if (result instanceof CauseHolder || result == SUCCESS) {
            return null;
        }
        return (V)result;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        Object result = this.result;
        if (!DefaultPromise.isDone0(result)) {
            this.await();
            result = this.result;
        }
        if (result == SUCCESS || result == UNCANCELLABLE) {
            return null;
        }
        Throwable cause = this.cause0(result);
        if (cause == null) {
            return (V)result;
        }
        if (cause instanceof CancellationException) {
            throw (CancellationException)cause;
        }
        throw new ExecutionException(cause);
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Object result = this.result;
        if (!DefaultPromise.isDone0(result)) {
            if (!this.await(timeout, unit)) {
                throw new TimeoutException();
            }
            result = this.result;
        }
        if (result == SUCCESS || result == UNCANCELLABLE) {
            return null;
        }
        Throwable cause = this.cause0(result);
        if (cause == null) {
            return (V)result;
        }
        if (cause instanceof CancellationException) {
            throw (CancellationException)cause;
        }
        throw new ExecutionException(cause);
    }

    @Override
    public boolean cancel() {
        if (RESULT_UPDATER.compareAndSet(this, null, CANCELLATION_CAUSE_HOLDER)) {
            if (this.checkNotifyWaiters()) {
                this.notifyListeners();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isCancelled() {
        return DefaultPromise.isCancelled0(this.result);
    }

    @Override
    public boolean isDone() {
        return DefaultPromise.isDone0(this.result);
    }

    @Override
    public FutureCompletionStage<V> sync() throws InterruptedException {
        this.await();
        this.rethrowIfFailed();
        return this;
    }

    public String toString() {
        return this.toStringBuilder().toString();
    }

    protected StringBuilder toStringBuilder() {
        StringBuilder buf = new StringBuilder(64).append(StringUtil.simpleClassName(this)).append('@').append(Integer.toHexString(this.hashCode()));
        Object result = this.result;
        if (result == SUCCESS) {
            buf.append("(success)");
        } else if (result == UNCANCELLABLE) {
            buf.append("(uncancellable)");
        } else if (result instanceof CauseHolder) {
            buf.append("(failure: ").append(((CauseHolder)result).cause).append(')');
        } else if (result != null) {
            buf.append("(success: ").append(result).append(')');
        } else {
            buf.append("(incomplete)");
        }
        return buf;
    }

    @Override
    public final EventExecutor executor() {
        return this.executor;
    }

    protected void checkDeadLock() {
        this.checkDeadLock(this.executor);
    }

    protected final void checkDeadLock(EventExecutor executor) {
        if (executor.inEventLoop()) {
            throw new BlockingOperationException(this.toString());
        }
    }

    private void notifyListeners() {
        DefaultPromise.safeExecute(this.executor(), new NotifyListeners(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersNow() {
        Object listeners;
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            if (this.listeners == null) {
                return;
            }
            listeners = this.listeners;
            this.listeners = null;
        }
        while (true) {
            if (listeners instanceof DefaultFutureListeners) {
                this.notifyListeners0((DefaultFutureListeners)listeners);
            } else {
                DefaultPromise.notifyListener0(this, (FutureListener)listeners);
            }
            defaultPromise = this;
            synchronized (defaultPromise) {
                if (this.listeners == null) {
                    return;
                }
                listeners = this.listeners;
                this.listeners = null;
            }
        }
    }

    private void notifyListeners0(DefaultFutureListeners listeners) {
        listeners.notifyListeners(this, logger);
    }

    static <V> void notifyListener0(Future<V> future, FutureListener<? super V> l) {
        block2: {
            try {
                l.operationComplete(future);
            }
            catch (Throwable t) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("An exception was thrown by " + l.getClass().getName() + ".operationComplete()", t);
            }
        }
    }

    private synchronized void addListener0(Object listener, Object context) {
        if (this.listeners == null && context == null) {
            this.listeners = listener;
        } else if (this.listeners instanceof DefaultFutureListeners) {
            ((DefaultFutureListeners)this.listeners).add(listener, context);
        } else {
            DefaultFutureListeners listeners = new DefaultFutureListeners();
            if (this.listeners != null) {
                listeners.add(this.listeners, null);
            }
            listeners.add(listener, context);
            this.listeners = listeners;
        }
    }

    private boolean setSuccess0(V result) {
        return this.setValue0(result == null ? SUCCESS : result);
    }

    private boolean setFailure0(Throwable cause) {
        return this.setValue0(new CauseHolder(Objects.requireNonNull(cause, "cause")));
    }

    private boolean setValue0(Object objResult) {
        if (RESULT_UPDATER.compareAndSet(this, null, objResult) || RESULT_UPDATER.compareAndSet(this, UNCANCELLABLE, objResult)) {
            if (this.checkNotifyWaiters()) {
                this.notifyListeners();
            }
            return true;
        }
        return false;
    }

    private synchronized boolean checkNotifyWaiters() {
        if (this.waiters > 0) {
            this.notifyAll();
        }
        return this.listeners != null;
    }

    private void incWaiters() {
        if (this.waiters == Short.MAX_VALUE) {
            throw new IllegalStateException("too many waiters: " + this);
        }
        this.waiters = (short)(this.waiters + 1);
    }

    private void decWaiters() {
        this.waiters = (short)(this.waiters - 1);
    }

    private void rethrowIfFailed() {
        Throwable cause = this.cause();
        if (cause == null) {
            return;
        }
        if (cause instanceof CancellationException) {
            throw (CancellationException)cause;
        }
        throw new CompletionException(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean await0(long timeoutNanos, boolean interruptable) throws InterruptedException {
        if (this.isDone()) {
            return true;
        }
        if (timeoutNanos <= 0L) {
            return this.isDone();
        }
        if (interruptable && Thread.interrupted()) {
            throw new InterruptedException(this.toString());
        }
        this.checkDeadLock();
        long startTime = System.nanoTime();
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            boolean interrupted = false;
            try {
                long waitTime = timeoutNanos;
                while (!this.isDone() && waitTime > 0L) {
                    this.incWaiters();
                    try {
                        this.wait(waitTime / 1000000L, (int)(waitTime % 1000000L));
                    }
                    catch (InterruptedException e) {
                        if (interruptable) {
                            throw e;
                        }
                        interrupted = true;
                    }
                    finally {
                        this.decWaiters();
                    }
                    if (this.isDone()) {
                        boolean bl = true;
                        return bl;
                    }
                    waitTime = timeoutNanos - (System.nanoTime() - startTime);
                }
                boolean bl = this.isDone();
                return bl;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private static boolean isCancelled0(Object result) {
        return result instanceof CauseHolder && ((CauseHolder)result).cause instanceof CancellationException;
    }

    private static boolean isDone0(Object result) {
        return result != null && result != UNCANCELLABLE;
    }

    static void safeExecute(EventExecutor executor, Runnable task) {
        try {
            executor.execute(task);
        }
        catch (Throwable t) {
            rejectedExecutionLogger.error("Failed to submit a listener notification task. Event loop shut down?", t);
        }
    }

    @Override
    public FutureCompletionStage<V> asStage() {
        return this;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.cancel();
    }

    @Override
    public Future<V> future() {
        return this;
    }

    @Override
    public <U> FutureCompletionStage<U> thenApply(Function<? super V, ? extends U> fn) {
        return this.thenApplyAsync((Function)fn, SAME_AS_FUTURE);
    }

    @Override
    public <U> FutureCompletionStage<U> thenApplyAsync(Function<? super V, ? extends U> fn) {
        return this.thenApplyAsync((Function)fn, (Executor)ForkJoinPool.commonPool());
    }

    @Override
    public FutureCompletionStage<Void> thenAccept(Consumer<? super V> action) {
        return this.thenAcceptAsync((Consumer)action, SAME_AS_FUTURE);
    }

    @Override
    public FutureCompletionStage<Void> thenAcceptAsync(Consumer<? super V> action) {
        return this.thenAcceptAsync((Consumer)action, (Executor)ForkJoinPool.commonPool());
    }

    @Override
    public FutureCompletionStage<Void> thenRun(Runnable action) {
        return this.thenRunAsync(action, SAME_AS_FUTURE);
    }

    @Override
    public FutureCompletionStage<Void> thenRunAsync(Runnable action) {
        return this.thenRunAsync(action, ForkJoinPool.commonPool());
    }

    @Override
    public <U, V1> FutureCompletionStage<V1> thenCombine(CompletionStage<? extends U> other, BiFunction<? super V, ? super U, ? extends V1> fn) {
        return this.thenCombineAsync((CompletionStage)other, (BiFunction)fn, SAME_AS_FUTURE);
    }

    @Override
    public <U, V1> FutureCompletionStage<V1> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super V, ? super U, ? extends V1> fn) {
        return this.thenCombineAsync((CompletionStage)other, (BiFunction)fn, (Executor)ForkJoinPool.commonPool());
    }

    @Override
    public <U> FutureCompletionStage<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super V, ? super U> action) {
        return this.thenAcceptBothAsync((CompletionStage)other, (BiConsumer)action, SAME_AS_FUTURE);
    }

    @Override
    public <U> FutureCompletionStage<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super V, ? super U> action) {
        return this.thenAcceptBothAsync((CompletionStage)other, (BiConsumer)action, (Executor)ForkJoinPool.commonPool());
    }

    @Override
    public FutureCompletionStage<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return this.runAfterBothAsync((CompletionStage)other, action, SAME_AS_FUTURE);
    }

    @Override
    public FutureCompletionStage<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return this.runAfterBothAsync((CompletionStage)other, action, (Executor)ForkJoinPool.commonPool());
    }

    @Override
    public <U> FutureCompletionStage<U> applyToEither(CompletionStage<? extends V> other, Function<? super V, U> fn) {
        return this.applyToEitherAsync((CompletionStage)other, (Function)fn, SAME_AS_FUTURE);
    }

    @Override
    public <U> FutureCompletionStage<U> applyToEitherAsync(CompletionStage<? extends V> other, Function<? super V, U> fn) {
        return this.applyToEitherAsync((CompletionStage)other, (Function)fn, (Executor)ForkJoinPool.commonPool());
    }

    @Override
    public FutureCompletionStage<Void> acceptEither(CompletionStage<? extends V> other, Consumer<? super V> action) {
        return this.acceptEitherAsync((CompletionStage)other, (Consumer)action, SAME_AS_FUTURE);
    }

    @Override
    public FutureCompletionStage<Void> acceptEitherAsync(CompletionStage<? extends V> other, Consumer<? super V> action) {
        return this.acceptEitherAsync((CompletionStage)other, (Consumer)action, (Executor)ForkJoinPool.commonPool());
    }

    @Override
    public FutureCompletionStage<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return this.runAfterEitherAsync((CompletionStage)other, action, SAME_AS_FUTURE);
    }

    @Override
    public FutureCompletionStage<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return this.runAfterEitherAsync((CompletionStage)other, action, (Executor)ForkJoinPool.commonPool());
    }

    @Override
    public <U> FutureCompletionStage<U> thenCompose(Function<? super V, ? extends CompletionStage<U>> fn) {
        return this.thenComposeAsync((Function)fn, SAME_AS_FUTURE);
    }

    @Override
    public <U> FutureCompletionStage<U> thenComposeAsync(Function<? super V, ? extends CompletionStage<U>> fn) {
        return this.thenComposeAsync((Function)fn, (Executor)ForkJoinPool.commonPool());
    }

    @Override
    public FutureCompletionStage<V> whenComplete(BiConsumer<? super V, ? super Throwable> action) {
        return this.whenCompleteAsync((BiConsumer)action, SAME_AS_FUTURE);
    }

    @Override
    public FutureCompletionStage<V> whenCompleteAsync(BiConsumer<? super V, ? super Throwable> action) {
        return this.whenCompleteAsync((BiConsumer)action, (Executor)ForkJoinPool.commonPool());
    }

    @Override
    public <U> FutureCompletionStage<U> handle(BiFunction<? super V, Throwable, ? extends U> fn) {
        return this.handleAsync((BiFunction)fn, SAME_AS_FUTURE);
    }

    @Override
    public <U> FutureCompletionStage<U> handleAsync(BiFunction<? super V, Throwable, ? extends U> fn) {
        return this.handleAsync((BiFunction)fn, (Executor)ForkJoinPool.commonPool());
    }

    @Override
    public <U> FutureCompletionStage<U> thenApplyAsync(Function<? super V, ? extends U> fn, Executor executor) {
        Objects.requireNonNull(fn, "fn");
        Objects.requireNonNull(executor, "executor");
        Promise promise = this.executor().newPromise();
        this.addListener(future -> {
            Throwable cause = future.cause();
            if (cause == null) {
                Object value = future.getNow();
                if (DefaultPromise.executeDirectly(executor)) {
                    DefaultPromise.thenApplyAsync0(promise, value, fn);
                } else {
                    DefaultPromise.safeExecute(executor, () -> DefaultPromise.thenApplyAsync0(promise, value, fn), promise);
                }
            } else {
                promise.setFailure(cause);
            }
        });
        return promise.asFuture().asStage();
    }

    private static <U, V> void thenApplyAsync0(Promise<U> promise, V value, Function<? super V, ? extends U> fn) {
        U result;
        try {
            result = fn.apply(value);
        }
        catch (Throwable cause) {
            promise.setFailure(cause);
            return;
        }
        promise.setSuccess(result);
    }

    @Override
    public FutureCompletionStage<Void> thenAcceptAsync(Consumer<? super V> action, Executor executor) {
        Objects.requireNonNull(action, "action");
        Objects.requireNonNull(executor, "executor");
        Promise promise = this.executor().newPromise();
        this.addListener(future -> {
            Throwable cause = future.cause();
            if (cause == null) {
                Object value = future.getNow();
                if (DefaultPromise.executeDirectly(executor)) {
                    DefaultPromise.thenAcceptAsync0(promise, value, action);
                } else {
                    DefaultPromise.safeExecute(executor, () -> DefaultPromise.thenAcceptAsync0(promise, value, action), promise);
                }
            } else {
                promise.setFailure(cause);
            }
        });
        return promise.asFuture().asStage();
    }

    private static <U, V> void thenAcceptAsync0(Promise<U> promise, V value, Consumer<? super V> action) {
        try {
            action.accept(value);
            promise.setSuccess(null);
        }
        catch (Throwable cause) {
            promise.setFailure(cause);
        }
    }

    @Override
    public FutureCompletionStage<Void> thenRunAsync(Runnable action, Executor executor) {
        return this.thenAcceptAsync((T ignore) -> action.run(), executor);
    }

    @Override
    public <U, V1> FutureCompletionStage<V1> thenCombineAsync(CompletionStage<? extends U> other, final BiFunction<? super V, ? super U, ? extends V1> fn, Executor executor) {
        Objects.requireNonNull(other, "other");
        Objects.requireNonNull(fn, "fn");
        Objects.requireNonNull(executor, "executor");
        final Promise promise = this.executor().newPromise();
        final AtomicReference<Marker> reference = new AtomicReference<Marker>(Marker.EMPTY);
        abstract class CombineBiConsumer<T1, T2, T>
        implements BiConsumer<T, Throwable> {
            final /* synthetic */ AtomicReference val$reference;
            final /* synthetic */ Promise val$promise;
            final /* synthetic */ BiFunction val$fn;

            CombineBiConsumer() {
                this.val$reference = atomicReference;
                this.val$promise = promise;
                this.val$fn = biFunction;
            }

            @Override
            public void accept(T v, Throwable error) {
                if (error == null) {
                    if (!this.val$reference.compareAndSet(Marker.EMPTY, v)) {
                        Object rawValue = this.val$reference.get();
                        if (rawValue == Marker.ERROR) {
                            return;
                        }
                        this.applyAndNotify0(this.val$promise, v, rawValue, this.val$fn);
                    }
                } else if (this.val$reference.getAndSet(Marker.ERROR) != Marker.ERROR) {
                    this.val$promise.setFailure(error);
                }
            }

            abstract void applyAndNotify0(Promise<V1> var1, T1 var2, T2 var3, BiFunction<? super V, ? super U, ? extends V1> var4);
        }
        this.whenCompleteAsync((BiConsumer)new CombineBiConsumer<V, U, V>(){
            {
                super(DefaultPromise.this, atomicReference, promise2, biFunction);
            }

            @Override
            void applyAndNotify0(Promise<V1> promise2, V value1, U value2, BiFunction<? super V, ? super U, ? extends V1> fn2) {
                DefaultPromise.applyAndNotify(promise2, value1, value2, fn2);
            }
        }, executor);
        other.whenCompleteAsync(new CombineBiConsumer<U, V, U>(){
            {
                super(DefaultPromise.this, atomicReference, promise2, biFunction);
            }

            @Override
            void applyAndNotify0(Promise<V1> promise2, U value1, V value2, BiFunction<? super V, ? super U, ? extends V1> fn2) {
                DefaultPromise.applyAndNotify(promise2, value2, value1, fn2);
            }
        }, this.otherExecutor(executor));
        return promise.asFuture().asStage();
    }

    private Executor otherExecutor(Executor executor) {
        return executor == SAME_AS_FUTURE ? this.executor() : executor;
    }

    @Override
    public <U> FutureCompletionStage<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super V, ? super U> action, Executor executor) {
        Objects.requireNonNull(action, "action");
        return this.thenCombineAsync((CompletionStage)other, (T value, U value2) -> {
            action.accept((Object)value, (Object)value2);
            return null;
        }, executor);
    }

    @Override
    public FutureCompletionStage<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        Objects.requireNonNull(action, "action");
        return this.thenCombineAsync(other, (T ignoreThisValue, U ignoreOtherValue) -> {
            action.run();
            return null;
        }, executor);
    }

    @Override
    public <U> FutureCompletionStage<U> applyToEitherAsync(CompletionStage<? extends V> other, final Function<? super V, U> fn, Executor executor) {
        Objects.requireNonNull(other, "other");
        Objects.requireNonNull(fn, "fn");
        Promise promise = this.executor().newPromise();
        AtomicBiConsumer consumer = new AtomicBiConsumer<V, U>(promise){
            private static final long serialVersionUID = -8454630185124276599L;

            @Override
            protected U apply(V value) {
                return fn.apply(value);
            }
        };
        this.whenCompleteAsync((BiConsumer)consumer, executor);
        other.whenCompleteAsync(consumer, this.otherExecutor(executor));
        return promise.asFuture().asStage();
    }

    @Override
    public FutureCompletionStage<Void> acceptEitherAsync(CompletionStage<? extends V> other, final Consumer<? super V> action, Executor executor) {
        Objects.requireNonNull(other, "other");
        Objects.requireNonNull(action, "action");
        Promise promise = this.executor().newPromise();
        AtomicBiConsumer consumer = new AtomicBiConsumer<V, Void>(promise){
            private static final long serialVersionUID = -8429618092318150682L;

            @Override
            protected Void apply(V value) {
                action.accept(value);
                return null;
            }
        };
        this.whenCompleteAsync((BiConsumer)consumer, executor);
        other.whenCompleteAsync(consumer, this.otherExecutor(executor));
        return promise.asFuture().asStage();
    }

    @Override
    public FutureCompletionStage<Void> runAfterEitherAsync(CompletionStage<?> other, final Runnable action, Executor executor) {
        Objects.requireNonNull(other, "other");
        Objects.requireNonNull(action, "action");
        Promise promise = this.executor().newPromise();
        AtomicBiConsumer<Object, Void> consumer = new AtomicBiConsumer<Object, Void>(promise){
            private static final long serialVersionUID = 5994110691767731494L;

            @Override
            protected Void apply(Object value) {
                action.run();
                return null;
            }
        };
        this.whenCompleteAsync(consumer, executor);
        other.whenCompleteAsync(consumer, this.otherExecutor(executor));
        return promise.asFuture().asStage();
    }

    @Override
    public <U> FutureCompletionStage<U> thenComposeAsync(Function<? super V, ? extends CompletionStage<U>> fn, Executor executor) {
        Objects.requireNonNull(fn, "fn");
        Objects.requireNonNull(executor, "executor");
        Promise promise = this.executor().newPromise();
        this.addListener(f -> {
            Throwable cause = f.cause();
            if (cause == null) {
                Object value = f.getNow();
                if (DefaultPromise.executeDirectly(executor)) {
                    DefaultPromise.thenComposeAsync0(promise, fn, value);
                } else {
                    DefaultPromise.safeExecute(executor, () -> DefaultPromise.thenComposeAsync0(promise, fn, value), promise);
                }
            } else {
                promise.setFailure(cause);
            }
        });
        return promise.asFuture().asStage();
    }

    private static <V, U> void thenComposeAsync0(Promise<U> promise, Function<? super V, ? extends CompletionStage<U>> fn, V value) {
        CompletionStage<U> result;
        try {
            result = fn.apply(value);
        }
        catch (Throwable cause) {
            promise.setFailure(cause);
            return;
        }
        result.whenComplete((? super T v, ? super Throwable error) -> {
            if (error == null) {
                promise.setSuccess(v);
            } else {
                promise.setFailure((Throwable)error);
            }
        });
    }

    @Override
    public FutureCompletionStage<V> exceptionally(Function<Throwable, ? extends V> fn) {
        Objects.requireNonNull(fn, "fn");
        Promise promise = this.executor().newPromise();
        this.addListener(f -> {
            Throwable error = f.cause();
            if (error == null) {
                Object value = f.getNow();
                promise.setSuccess(value);
            } else {
                Object result;
                try {
                    result = fn.apply(error);
                }
                catch (Throwable cause) {
                    promise.setFailure(cause);
                    return;
                }
                promise.setSuccess(result);
            }
        });
        return promise.asFuture().asStage();
    }

    @Override
    public FutureCompletionStage<V> whenCompleteAsync(BiConsumer<? super V, ? super Throwable> action, Executor executor) {
        Objects.requireNonNull(action, "action");
        Objects.requireNonNull(executor, "executor");
        Promise promise = this.executor().newPromise();
        this.addListener(f -> {
            if (DefaultPromise.executeDirectly(executor)) {
                DefaultPromise.whenCompleteAsync0(promise, f, action);
            } else {
                DefaultPromise.safeExecute(executor, () -> DefaultPromise.whenCompleteAsync0(promise, f, action), promise);
            }
        });
        return promise.asFuture().asStage();
    }

    private static <V> void whenCompleteAsync0(Promise<V> promise, Future<? extends V> f, BiConsumer<? super V, ? super Throwable> action) {
        Throwable cause = f.cause();
        Object value = cause == null ? (Object)f.getNow() : null;
        try {
            action.accept(value, cause);
        }
        catch (Throwable error) {
            promise.setFailure(error);
            return;
        }
        if (cause == null) {
            promise.setSuccess(value);
        } else {
            promise.setFailure(cause);
        }
    }

    @Override
    public <U> FutureCompletionStage<U> handleAsync(BiFunction<? super V, Throwable, ? extends U> fn, Executor executor) {
        Objects.requireNonNull(fn, "fn");
        Objects.requireNonNull(executor, "executor");
        Promise promise = this.executor().newPromise();
        this.addListener(f -> {
            if (DefaultPromise.executeDirectly(executor)) {
                DefaultPromise.handleAsync0(promise, f, fn);
            } else {
                DefaultPromise.safeExecute(executor, () -> DefaultPromise.handleAsync0(promise, f, fn), promise);
            }
        });
        return promise.asFuture().asStage();
    }

    private static <U, V> void handleAsync0(Promise<U> promise, Future<? super V> f, BiFunction<? super V, Throwable, ? extends U> fn) {
        Throwable cause = f.cause();
        DefaultPromise.applyAndNotify(promise, cause == null ? (V)f.getNow() : null, cause, fn);
    }

    private static <U, V, T> void applyAndNotify(Promise<U> promise, V value, T value2, BiFunction<? super V, ? super T, ? extends U> fn) {
        U result;
        try {
            result = fn.apply(value, value2);
        }
        catch (Throwable error) {
            promise.setFailure(error);
            return;
        }
        promise.setSuccess(result);
    }

    private static boolean executeDirectly(Executor executor) {
        return executor == SAME_AS_FUTURE;
    }

    private static void safeExecute(Executor executor, Runnable task, Promise<?> promise) {
        try {
            executor.execute(task);
        }
        catch (Throwable cause) {
            promise.setFailure(cause);
        }
    }

    private static final class StacklessCancellationException
    extends CancellationException {
        private static final long serialVersionUID = -2974906711413716191L;

        private StacklessCancellationException() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }

        static StacklessCancellationException newInstance(Class<?> clazz, String method) {
            return ThrowableUtil.unknownStackTrace(new StacklessCancellationException(), clazz, method);
        }
    }

    private static abstract class AtomicBiConsumer<V, U>
    extends AtomicReference<Object>
    implements BiConsumer<V, Throwable> {
        private static final long serialVersionUID = 880039612531973027L;
        private final Promise<U> promise;

        AtomicBiConsumer(Promise<U> promise) {
            super(Marker.EMPTY);
            this.promise = promise;
        }

        @Override
        public void accept(V v, Throwable error) {
            if (error == null) {
                if (this.compareAndSet(Marker.EMPTY, v)) {
                    U value;
                    try {
                        value = this.apply(v);
                    }
                    catch (Throwable cause) {
                        this.promise.setFailure(cause);
                        return;
                    }
                    this.promise.setSuccess(value);
                }
            } else if (this.compareAndSet(Marker.EMPTY, Marker.ERROR)) {
                this.promise.setFailure(error);
            }
        }

        protected abstract U apply(V var1);
    }

    private static enum Marker {
        EMPTY,
        ERROR;

    }

    private static final class CauseHolder {
        final Throwable cause;

        CauseHolder(Throwable cause) {
            this.cause = cause;
        }
    }

    private static final class NotifyListeners
    implements Runnable {
        private final DefaultPromise<?> promise;

        private NotifyListeners(DefaultPromise<?> promise) {
            this.promise = promise;
        }

        @Override
        public void run() {
            this.promise.notifyListenersNow();
        }
    }

    private static final class LeanCancellationException
    extends CancellationException {
        private static final long serialVersionUID = 2794674970981187807L;

        private LeanCancellationException() {
        }

        @Override
        public Throwable fillInStackTrace() {
            this.setStackTrace(CANCELLATION_STACK);
            return this;
        }

        @Override
        public String toString() {
            return CancellationException.class.getName();
        }
    }
}

