/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.util;

import io.netty5.util.ReferenceCountUtil;
import io.netty5.util.ReferenceCounted;
import io.netty5.util.Send;

public interface Resource<T extends Resource<T>>
extends AutoCloseable {
    public Send<T> send();

    @Override
    public void close();

    public boolean isAccessible();

    default public T touch(Object hint) {
        return (T)this;
    }

    public static void dispose(Object obj) {
        if (obj instanceof AutoCloseable) {
            try {
                ((AutoCloseable)obj).close();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException("Exception from closing object", e);
            }
        } else if (ReferenceCountUtil.isReferenceCounted(obj)) {
            ReferenceCountUtil.release(obj);
        }
    }

    public static boolean isAccessible(Object obj, boolean expectedDefault) {
        if (obj instanceof Resource) {
            return ((Resource)obj).isAccessible();
        }
        if (obj instanceof ReferenceCounted) {
            return ((ReferenceCounted)obj).refCnt() > 0;
        }
        return expectedDefault;
    }

    public static void touch(Object obj, Object hint) {
        if (obj instanceof Resource) {
            ((Resource)obj).touch(hint);
        } else if (obj instanceof ReferenceCounted) {
            ((ReferenceCounted)obj).touch(hint);
        }
    }
}

