/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http.websocketx.extensions.compression;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.CompositeBuffer;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.embedded.EmbeddedChannel;
import io.netty5.handler.codec.CodecException;
import io.netty5.handler.codec.compression.ZlibCodecFactory;
import io.netty5.handler.codec.compression.ZlibWrapper;
import io.netty5.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.WebSocketFrame;
import io.netty5.handler.codec.http.websocketx.extensions.WebSocketExtensionDecoder;
import io.netty5.handler.codec.http.websocketx.extensions.WebSocketExtensionFilter;
import io.netty5.util.Send;
import io.netty5.util.internal.SilentDispose;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Supplier;

abstract class DeflateDecoder
extends WebSocketExtensionDecoder {
    static final Supplier<Buffer> FRAME_TAIL;
    static final int FRAME_TAIL_LENGTH;
    private final boolean noContext;
    private final WebSocketExtensionFilter extensionDecoderFilter;
    private EmbeddedChannel decoder;

    DeflateDecoder(boolean noContext, WebSocketExtensionFilter extensionDecoderFilter) {
        this.noContext = noContext;
        this.extensionDecoderFilter = Objects.requireNonNull(extensionDecoderFilter, "extensionDecoderFilter");
    }

    protected WebSocketExtensionFilter extensionDecoderFilter() {
        return this.extensionDecoderFilter;
    }

    protected abstract boolean appendFrameTail(WebSocketFrame var1);

    protected abstract int newRsv(WebSocketFrame var1);

    protected final void decode(ChannelHandlerContext ctx, WebSocketFrame msg) throws Exception {
        throw new UnsupportedOperationException("DeflateDecoder uses decodeAndClose().");
    }

    protected void decodeAndClose(ChannelHandlerContext ctx, WebSocketFrame msg) throws Exception {
        WebSocketFrame outMsg;
        Buffer decompressedContent = this.decompressContent(ctx, msg);
        if (msg instanceof TextWebSocketFrame) {
            outMsg = new TextWebSocketFrame(msg.isFinalFragment(), this.newRsv(msg), decompressedContent);
        } else if (msg instanceof BinaryWebSocketFrame) {
            outMsg = new BinaryWebSocketFrame(msg.isFinalFragment(), this.newRsv(msg), decompressedContent);
        } else if (msg instanceof ContinuationWebSocketFrame) {
            outMsg = new ContinuationWebSocketFrame(msg.isFinalFragment(), this.newRsv(msg), decompressedContent);
        } else {
            SilentDispose.tryPropagatingDispose((Object)((Object)msg));
            throw new CodecException("unexpected frame type: " + ((Object)((Object)msg)).getClass().getName());
        }
        ctx.fireChannelRead((Object)outMsg);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.cleanup();
        super.handlerRemoved(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.cleanup();
        super.channelInactive(ctx);
    }

    private Buffer decompressContent(ChannelHandlerContext ctx, WebSocketFrame msg) {
        Buffer partUncompressedContent;
        if (this.decoder == null) {
            if (!(msg instanceof TextWebSocketFrame) && !(msg instanceof BinaryWebSocketFrame)) {
                throw new CodecException("unexpected initial frame type: " + ((Object)((Object)msg)).getClass().getName());
            }
            this.decoder = new EmbeddedChannel(new ChannelHandler[]{ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.NONE)});
        }
        boolean readable = msg.binaryData().readableBytes() > 0;
        boolean emptyDeflateBlock = DeflateDecoder.isEmptyDeflateBlock(msg.binaryData());
        this.decoder.writeInbound(new Object[]{msg.binaryData()});
        if (this.appendFrameTail(msg)) {
            this.decoder.writeInbound(new Object[]{FRAME_TAIL.get()});
        }
        ArrayList<Send> bufferList = new ArrayList<Send>();
        while ((partUncompressedContent = (Buffer)this.decoder.readInbound()) != null) {
            if (partUncompressedContent.readableBytes() == 0) {
                partUncompressedContent.close();
                continue;
            }
            bufferList.add(partUncompressedContent.send());
        }
        CompositeBuffer compositeDecompressedContent = ctx.bufferAllocator().compose(bufferList);
        if (!emptyDeflateBlock && readable && compositeDecompressedContent.countReadableComponents() <= 0 && !(msg instanceof ContinuationWebSocketFrame)) {
            compositeDecompressedContent.close();
            throw new CodecException("cannot read uncompressed buffer");
        }
        if (msg.isFinalFragment() && this.noContext) {
            this.cleanup();
        }
        return compositeDecompressedContent;
    }

    private static boolean isEmptyDeflateBlock(Buffer binaryData) {
        return binaryData.readableBytes() == 1 && binaryData.getByte(binaryData.readerOffset()) == 0;
    }

    private void cleanup() {
        if (this.decoder != null) {
            this.decoder.finishAndReleaseAll();
            this.decoder = null;
        }
    }

    static {
        byte[] frameTail = new byte[]{0, 0, -1, -1};
        FRAME_TAIL = DefaultBufferAllocators.preferredAllocator().constBufferSupplier(frameTail);
        FRAME_TAIL_LENGTH = frameTail.length;
    }
}

