/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http.websocketx;

import io.netty5.buffer.BufferAllocator;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelOutboundInvoker;
import io.netty5.channel.ChannelPipeline;
import io.netty5.channel.SimpleChannelInboundHandler;
import io.netty5.handler.codec.http.FullHttpRequest;
import io.netty5.handler.codec.http.FullHttpResponse;
import io.netty5.handler.codec.http.HttpClientCodec;
import io.netty5.handler.codec.http.HttpContentDecompressor;
import io.netty5.handler.codec.http.HttpHeaderNames;
import io.netty5.handler.codec.http.HttpObjectAggregator;
import io.netty5.handler.codec.http.HttpRequestEncoder;
import io.netty5.handler.codec.http.HttpResponse;
import io.netty5.handler.codec.http.HttpResponseDecoder;
import io.netty5.handler.codec.http.HttpScheme;
import io.netty5.handler.codec.http.headers.HttpHeaders;
import io.netty5.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.WebSocketClientHandshakeException;
import io.netty5.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.netty5.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.netty5.handler.codec.http.websocketx.WebSocketScheme;
import io.netty5.handler.codec.http.websocketx.WebSocketVersion;
import io.netty5.util.AsciiString;
import io.netty5.util.NetUtil;
import io.netty5.util.ReferenceCountUtil;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class WebSocketClientHandshaker {
    protected static final int DEFAULT_FORCE_CLOSE_TIMEOUT_MILLIS = 10000;
    private final URI uri;
    private final WebSocketVersion version;
    private volatile boolean handshakeComplete;
    private volatile long forceCloseTimeoutMillis = 10000L;
    private volatile int forceCloseInit;
    private static final AtomicIntegerFieldUpdater<WebSocketClientHandshaker> FORCE_CLOSE_INIT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(WebSocketClientHandshaker.class, "forceCloseInit");
    private volatile boolean forceCloseComplete;
    private final String expectedSubprotocol;
    private volatile String actualSubprotocol;
    protected final HttpHeaders customHeaders;
    private final int maxFramePayloadLength;
    private final boolean absoluteUpgradeUrl;

    protected WebSocketClientHandshaker(URI uri, WebSocketVersion version, String subprotocol, HttpHeaders customHeaders, int maxFramePayloadLength) {
        this(uri, version, subprotocol, customHeaders, maxFramePayloadLength, 10000L);
    }

    protected WebSocketClientHandshaker(URI uri, WebSocketVersion version, String subprotocol, HttpHeaders customHeaders, int maxFramePayloadLength, long forceCloseTimeoutMillis) {
        this(uri, version, subprotocol, customHeaders, maxFramePayloadLength, forceCloseTimeoutMillis, false);
    }

    protected WebSocketClientHandshaker(URI uri, WebSocketVersion version, String subprotocol, HttpHeaders customHeaders, int maxFramePayloadLength, long forceCloseTimeoutMillis, boolean absoluteUpgradeUrl) {
        this.uri = uri;
        this.version = version;
        this.expectedSubprotocol = subprotocol;
        this.customHeaders = customHeaders;
        this.maxFramePayloadLength = maxFramePayloadLength;
        this.forceCloseTimeoutMillis = forceCloseTimeoutMillis;
        this.absoluteUpgradeUrl = absoluteUpgradeUrl;
    }

    public URI uri() {
        return this.uri;
    }

    public WebSocketVersion version() {
        return this.version;
    }

    public int maxFramePayloadLength() {
        return this.maxFramePayloadLength;
    }

    public boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    private void setHandshakeComplete() {
        this.handshakeComplete = true;
    }

    public String expectedSubprotocol() {
        return this.expectedSubprotocol;
    }

    public String actualSubprotocol() {
        return this.actualSubprotocol;
    }

    private void setActualSubprotocol(String actualSubprotocol) {
        this.actualSubprotocol = actualSubprotocol;
    }

    public long forceCloseTimeoutMillis() {
        return this.forceCloseTimeoutMillis;
    }

    protected boolean isForceCloseComplete() {
        return this.forceCloseComplete;
    }

    public WebSocketClientHandshaker setForceCloseTimeoutMillis(long forceCloseTimeoutMillis) {
        this.forceCloseTimeoutMillis = forceCloseTimeoutMillis;
        return this;
    }

    public Future<Void> handshake(Channel channel) {
        HttpClientCodec codec;
        Objects.requireNonNull(channel, "channel");
        ChannelPipeline pipeline = channel.pipeline();
        HttpResponseDecoder decoder = (HttpResponseDecoder)pipeline.get(HttpResponseDecoder.class);
        if (decoder == null && (codec = (HttpClientCodec)pipeline.get(HttpClientCodec.class)) == null) {
            return channel.newFailedFuture((Throwable)new IllegalStateException("ChannelPipeline does not contain an HttpResponseDecoder or HttpClientCodec"));
        }
        FullHttpRequest request = this.newHandshakeRequest(channel.bufferAllocator());
        Promise promise = channel.newPromise();
        channel.writeAndFlush((Object)request).addListener((Object)channel, (ch, future) -> {
            if (future.isSuccess()) {
                ChannelPipeline p = ch.pipeline();
                ChannelHandlerContext ctx = p.context(HttpRequestEncoder.class);
                if (ctx == null) {
                    ctx = p.context(HttpClientCodec.class);
                }
                if (ctx == null) {
                    promise.setFailure((Throwable)new IllegalStateException("ChannelPipeline does not contain an HttpRequestEncoder or HttpClientCodec"));
                    return;
                }
                p.addAfter(ctx.name(), "ws-encoder", (ChannelHandler)this.newWebSocketEncoder());
                promise.setSuccess(null);
            } else {
                promise.setFailure(future.cause());
            }
        });
        return promise.asFuture();
    }

    protected abstract FullHttpRequest newHandshakeRequest(BufferAllocator var1);

    public final void finishHandshake(Channel channel, FullHttpResponse response) {
        ChannelHandlerContext ctx;
        HttpObjectAggregator aggregator;
        this.verify(response);
        CharSequence receivedProtocol = response.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL);
        receivedProtocol = receivedProtocol != null ? AsciiString.trim((CharSequence)receivedProtocol) : null;
        String expectedProtocol = this.expectedSubprotocol != null ? this.expectedSubprotocol : "";
        boolean protocolValid = false;
        if (expectedProtocol.isEmpty() && receivedProtocol == null) {
            protocolValid = true;
            this.setActualSubprotocol(this.expectedSubprotocol);
        } else if (!expectedProtocol.isEmpty() && receivedProtocol != null && receivedProtocol.length() > 0) {
            for (String protocol : expectedProtocol.split(",")) {
                if (!AsciiString.contentEquals((CharSequence)protocol.trim(), (CharSequence)receivedProtocol)) continue;
                protocolValid = true;
                this.setActualSubprotocol(receivedProtocol.toString());
                break;
            }
        }
        if (!protocolValid) {
            throw new WebSocketClientHandshakeException(String.format("Invalid subprotocol. Actual: %s. Expected one of: %s", receivedProtocol, this.expectedSubprotocol), response);
        }
        this.setHandshakeComplete();
        ChannelPipeline p = channel.pipeline();
        HttpContentDecompressor decompressor = (HttpContentDecompressor)p.get(HttpContentDecompressor.class);
        if (decompressor != null) {
            p.remove((ChannelHandler)decompressor);
        }
        if ((aggregator = (HttpObjectAggregator)p.get(HttpObjectAggregator.class)) != null) {
            p.remove((ChannelHandler)aggregator);
        }
        if ((ctx = p.context(HttpResponseDecoder.class)) == null) {
            ctx = p.context(HttpClientCodec.class);
            if (ctx == null) {
                throw new IllegalStateException("ChannelPipeline does not contain an HttpRequestEncoder or HttpClientCodec");
            }
            HttpClientCodec codec = (HttpClientCodec)ctx.handler();
            codec.removeOutboundHandler();
            p.addAfter(ctx.name(), "ws-decoder", (ChannelHandler)this.newWebsocketDecoder());
            channel.executor().execute(() -> p.remove((ChannelHandler)codec));
        } else {
            if (p.get(HttpRequestEncoder.class) != null) {
                p.remove(HttpRequestEncoder.class);
            }
            ChannelHandlerContext context = ctx;
            p.addAfter(context.name(), "ws-decoder", (ChannelHandler)this.newWebsocketDecoder());
            channel.executor().execute(() -> p.remove(context.handler()));
        }
    }

    public final Future<Void> processHandshake(final Channel channel, HttpResponse response) {
        if (response instanceof FullHttpResponse) {
            try {
                this.finishHandshake(channel, (FullHttpResponse)response);
                return channel.newSucceededFuture();
            }
            catch (Throwable cause) {
                return channel.newFailedFuture(cause);
            }
        }
        ChannelPipeline p = channel.pipeline();
        ChannelHandlerContext ctx = p.context(HttpResponseDecoder.class);
        if (ctx == null && (ctx = p.context(HttpClientCodec.class)) == null) {
            return channel.newFailedFuture((Throwable)new IllegalStateException("ChannelPipeline does not contain an HttpResponseDecoder or HttpClientCodec"));
        }
        final Promise promise = channel.newPromise();
        String aggregatorName = "httpAggregator";
        p.addAfter(ctx.name(), aggregatorName, new HttpObjectAggregator(8192));
        p.addAfter(aggregatorName, "handshaker", (ChannelHandler)new SimpleChannelInboundHandler<FullHttpResponse>(){

            protected void messageReceived(ChannelHandlerContext ctx, FullHttpResponse msg) throws Exception {
                ctx.pipeline().remove((ChannelHandler)this);
                try {
                    WebSocketClientHandshaker.this.finishHandshake(channel, msg);
                    promise.setSuccess(null);
                }
                catch (Throwable cause) {
                    promise.setFailure(cause);
                }
            }

            public void channelExceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                ctx.pipeline().remove((ChannelHandler)this);
                promise.setFailure(cause);
            }

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                if (!promise.isDone()) {
                    promise.tryFailure((Throwable)new ClosedChannelException());
                }
                ctx.fireChannelInactive();
            }
        });
        try {
            ctx.fireChannelRead(ReferenceCountUtil.retain((Object)response));
        }
        catch (Throwable cause) {
            promise.setFailure(cause);
        }
        return promise.asFuture();
    }

    protected abstract void verify(FullHttpResponse var1);

    protected abstract WebSocketFrameDecoder newWebsocketDecoder();

    protected abstract WebSocketFrameEncoder newWebSocketEncoder();

    public Future<Void> close(Channel channel, CloseWebSocketFrame frame) {
        Objects.requireNonNull(channel, "channel");
        return this.close0((ChannelOutboundInvoker)channel, channel, frame);
    }

    public Future<Void> close(ChannelHandlerContext ctx, CloseWebSocketFrame frame) {
        Objects.requireNonNull(ctx, "ctx");
        return this.close0((ChannelOutboundInvoker)ctx, ctx.channel(), frame);
    }

    private Future<Void> close0(ChannelOutboundInvoker invoker, Channel channel, CloseWebSocketFrame frame) {
        Future f = invoker.writeAndFlush((Object)frame);
        long forceCloseTimeoutMillis = this.forceCloseTimeoutMillis;
        WebSocketClientHandshaker handshaker = this;
        if (forceCloseTimeoutMillis <= 0L || !channel.isActive() || this.forceCloseInit != 0) {
            return f;
        }
        f.addListener(future -> {
            if (future.isSuccess() && channel.isActive() && FORCE_CLOSE_INIT_UPDATER.compareAndSet(handshaker, 0, 1)) {
                Future forceCloseFuture = channel.executor().schedule(() -> {
                    if (channel.isActive()) {
                        channel.close();
                        this.forceCloseComplete = true;
                    }
                }, forceCloseTimeoutMillis, TimeUnit.MILLISECONDS);
                channel.closeFuture().addListener(ignore -> forceCloseFuture.cancel());
            }
        });
        return f;
    }

    protected String upgradeUrl(URI wsURL) {
        if (this.absoluteUpgradeUrl) {
            return wsURL.toString();
        }
        String path = wsURL.getRawPath();
        path = path == null || path.isEmpty() ? "/" : path;
        String query = wsURL.getRawQuery();
        return query != null && !query.isEmpty() ? path + "?" + query : path;
    }

    static CharSequence websocketHostValue(URI wsURL) {
        int port = wsURL.getPort();
        if (port == -1) {
            return wsURL.getHost();
        }
        String host = wsURL.getHost();
        String scheme = wsURL.getScheme();
        if (port == HttpScheme.HTTP.port()) {
            return HttpScheme.HTTP.name().contentEquals((CharSequence)scheme) || WebSocketScheme.WS.name().contentEquals((CharSequence)scheme) ? host : NetUtil.toSocketAddressString((String)host, (int)port);
        }
        if (port == HttpScheme.HTTPS.port()) {
            return HttpScheme.HTTPS.name().contentEquals((CharSequence)scheme) || WebSocketScheme.WSS.name().contentEquals((CharSequence)scheme) ? host : NetUtil.toSocketAddressString((String)host, (int)port);
        }
        return NetUtil.toSocketAddressString((String)host, (int)port);
    }
}

