/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http.websocketx;

import io.netty5.buffer.Buffer;
import io.netty5.buffer.BufferAllocator;
import io.netty5.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty5.handler.codec.http.websocketx.WebSocketFrame;
import java.nio.charset.StandardCharsets;

public class CloseWebSocketFrame
extends WebSocketFrame {
    public CloseWebSocketFrame(BufferAllocator allocator, WebSocketCloseStatus status) {
        this(allocator, (int)CloseWebSocketFrame.requireValidStatusCode(status.code()), status.reasonText());
    }

    public CloseWebSocketFrame(BufferAllocator allocator, WebSocketCloseStatus status, String reasonText) {
        this(allocator, (int)CloseWebSocketFrame.requireValidStatusCode(status.code()), reasonText);
    }

    public CloseWebSocketFrame(BufferAllocator allocator, int statusCode, String reasonText) {
        this(allocator, true, 0, CloseWebSocketFrame.requireValidStatusCode(statusCode), reasonText);
    }

    public CloseWebSocketFrame(BufferAllocator allocator, boolean finalFragment, int rsv) {
        this(finalFragment, rsv, allocator.allocate(0));
    }

    public CloseWebSocketFrame(BufferAllocator allocator, boolean finalFragment, int rsv, int statusCode, String reasonText) {
        super(finalFragment, rsv, CloseWebSocketFrame.newBinaryData(allocator, CloseWebSocketFrame.requireValidStatusCode(statusCode), reasonText));
    }

    private static Buffer newBinaryData(BufferAllocator allocator, short statusCode, String reasonText) {
        Buffer binaryData;
        if (reasonText == null) {
            reasonText = "";
        }
        if (!reasonText.isEmpty()) {
            byte[] reasonTextBytes = reasonText.getBytes(StandardCharsets.UTF_8);
            binaryData = allocator.allocate(2 + reasonTextBytes.length);
            binaryData.writeShort(statusCode);
            binaryData.writeBytes(reasonTextBytes);
        } else {
            binaryData = allocator.allocate(2).writeShort(statusCode);
        }
        return binaryData;
    }

    public CloseWebSocketFrame(boolean finalFragment, int rsv, Buffer binaryData) {
        super(finalFragment, rsv, binaryData);
    }

    private CloseWebSocketFrame(CloseWebSocketFrame copyFrom, Buffer data) {
        super(copyFrom, data);
    }

    public int statusCode() {
        Buffer binaryData = this.binaryData();
        if (binaryData == null || binaryData.readableBytes() < 2) {
            return -1;
        }
        return binaryData.getShort(binaryData.readerOffset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String reasonText() {
        Buffer binaryData = this.binaryData();
        if (binaryData == null || binaryData.readableBytes() <= 2) {
            return "";
        }
        int base = binaryData.readerOffset();
        try {
            binaryData.skipReadableBytes(2);
            String string = binaryData.toString(StandardCharsets.UTF_8);
            return string;
        }
        finally {
            binaryData.readerOffset(base);
        }
    }

    protected WebSocketFrame receive(Buffer buf) {
        return new CloseWebSocketFrame(this, buf);
    }

    static short requireValidStatusCode(int statusCode) {
        if (WebSocketCloseStatus.isValidStatusCode(statusCode)) {
            return (short)statusCode;
        }
        throw new IllegalArgumentException("WebSocket close status code does NOT comply with RFC-6455: " + statusCode);
    }
}

