/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http.headers;

import io.netty5.handler.codec.http.HttpHeaderNames;
import io.netty5.handler.codec.http.HttpHeaderValues;
import io.netty5.handler.codec.http.headers.DefaultHttpCookiePair;
import io.netty5.handler.codec.http.headers.DefaultHttpSetCookie;
import io.netty5.handler.codec.http.headers.HeaderValidationException;
import io.netty5.handler.codec.http.headers.HttpCookiePair;
import io.netty5.handler.codec.http.headers.HttpHeaderValidationUtil;
import io.netty5.handler.codec.http.headers.HttpHeaders;
import io.netty5.handler.codec.http.headers.HttpSetCookie;
import io.netty5.util.AsciiString;
import io.netty5.util.NetUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import org.jetbrains.annotations.Nullable;

public final class HeaderUtils {
    static final int HASH_CODE_SEED = -1028477387;
    public static final BiFunction<? super CharSequence, ? super CharSequence, CharSequence> DEFAULT_HEADER_FILTER = (k, v) -> "<filtered>";

    private HeaderUtils() {
    }

    static String toString(HttpHeaders headers, BiFunction<? super CharSequence, ? super CharSequence, CharSequence> filter) {
        String simpleName = headers.getClass().getSimpleName();
        int size = headers.size();
        if (size == 0) {
            return simpleName + "[]";
        }
        StringBuilder sb = new StringBuilder(simpleName.length() + 2 + size * 20).append(simpleName).append('[');
        Iterator<Map.Entry<CharSequence, CharSequence>> itr = headers.iterator();
        if (itr.hasNext()) {
            while (true) {
                Map.Entry<CharSequence, CharSequence> e = itr.next();
                sb.append(e.getKey()).append(": ").append(filter.apply(e.getKey(), e.getValue()));
                if (!itr.hasNext()) break;
                sb.append(System.lineSeparator());
            }
        }
        return sb.append(']').toString();
    }

    public static boolean isTransferEncodingChunked(HttpHeaders headers) {
        return HeaderUtils.containsCommaSeparatedValueIgnoreCase(headers, (CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (CharSequence)HttpHeaderValues.CHUNKED);
    }

    static boolean containsCommaSeparatedValueIgnoreCase(HttpHeaders headers, CharSequence name, CharSequence value) {
        Iterator<CharSequence> values = headers.valuesIterator(name);
        while (values.hasNext()) {
            CharSequence next = values.next();
            if (!HeaderUtils.containsCommaSeparatedValueIgnoreCase(next, value)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsCommaSeparatedValueIgnoreCase(CharSequence commaSeparatedValues, CharSequence needle) {
        int start = 0;
        int commaPos = AsciiString.indexOf((CharSequence)commaSeparatedValues, (char)',', (int)0);
        if (commaPos < 0) {
            return AsciiString.contentEqualsIgnoreCase((CharSequence)commaSeparatedValues, (CharSequence)needle);
        }
        String commaSeparatedValuesStr = commaSeparatedValues.toString();
        while (commaPos >= 0) {
            String subvalue = commaSeparatedValuesStr.substring(start, commaPos).trim();
            if (AsciiString.contentEqualsIgnoreCase((CharSequence)subvalue, (CharSequence)needle)) {
                return true;
            }
            start = commaPos + 1;
            commaPos = commaSeparatedValuesStr.indexOf(44, start);
        }
        return start > 0 && AsciiString.contentEqualsIgnoreCase((CharSequence)commaSeparatedValuesStr.substring(start).trim(), (CharSequence)needle);
    }

    static void validateCookieNameAndValue(CharSequence cookieName, CharSequence cookieValue) {
        if (cookieName == null || cookieName.length() == 0) {
            throw new IllegalArgumentException("Null or empty cookie names are not allowed.");
        }
        if (cookieValue == null) {
            throw new IllegalArgumentException("Null cookie values are not allowed.");
        }
    }

    static void validateToken(CharSequence token) {
        int index = HttpHeaderValidationUtil.validateToken(token);
        if (index != -1) {
            throw new HeaderValidationException("a header name can only contain \"token\" characters, but found invalid character 0x" + Integer.toHexString(token.charAt(index)) + " at index " + index + " of header '" + token + "'.");
        }
    }

    static void validateHeaderValue(CharSequence value) {
        int index = HttpHeaderValidationUtil.validateValidHeaderValue(value);
        if (index != -1) {
            throw new HeaderValidationException("a header value contains prohibited character 0x" + Integer.toHexString(value.charAt(index)) + " at index " + index + ".");
        }
    }

    public static boolean domainMatches(CharSequence requestDomain, @Nullable CharSequence cookieDomain) {
        if (cookieDomain == null || requestDomain.length() == 0) {
            return false;
        }
        int startIndex = cookieDomain.length() - requestDomain.length();
        if (startIndex == 0) {
            return AsciiString.contentEqualsIgnoreCase((CharSequence)cookieDomain, (CharSequence)requestDomain);
        }
        boolean queryEndsInDot = requestDomain.charAt(requestDomain.length() - 1) == '.';
        return (queryEndsInDot && startIndex >= -1 && AsciiString.regionMatches((CharSequence)cookieDomain, (boolean)true, (int)(startIndex + 1), (CharSequence)requestDomain, (int)0, (int)(requestDomain.length() - 1)) || !queryEndsInDot && startIndex > 0 && AsciiString.regionMatches((CharSequence)cookieDomain, (boolean)true, (int)startIndex, (CharSequence)requestDomain, (int)0, (int)requestDomain.length())) && !NetUtil.isValidIpV4Address((CharSequence)cookieDomain) && !NetUtil.isValidIpV6Address((CharSequence)cookieDomain);
    }

    public static boolean pathMatches(CharSequence requestPath, @Nullable CharSequence cookiePath) {
        if (cookiePath == null || cookiePath.length() == 0 || requestPath.length() == 0) {
            return false;
        }
        if (requestPath.length() == cookiePath.length()) {
            return AsciiString.contentEquals((CharSequence)requestPath, (CharSequence)cookiePath);
        }
        boolean actualStartsWithSlash = cookiePath.charAt(0) == '/';
        int length = Math.min(actualStartsWithSlash ? cookiePath.length() - 1 : cookiePath.length(), requestPath.length());
        return AsciiString.regionMatches((CharSequence)requestPath, (boolean)false, (int)(requestPath.charAt(0) == '/' && !actualStartsWithSlash ? 1 : 0), (CharSequence)cookiePath, (int)0, (int)length) && (requestPath.length() > cookiePath.length() || cookiePath.charAt(length) == '/');
    }

    public static boolean isSetCookieNameMatches(CharSequence setCookieString, CharSequence setCookieName) {
        int equalsIndex = AsciiString.indexOf((CharSequence)setCookieString, (char)'=', (int)0);
        return equalsIndex > 0 && equalsIndex == setCookieName.length() && AsciiString.regionMatches((CharSequence)setCookieName, (boolean)true, (int)0, (CharSequence)setCookieString, (int)0, (int)equalsIndex);
    }

    @Nullable
    public static HttpSetCookie parseSetCookie(CharSequence setCookieString, CharSequence setCookieName, boolean validate) {
        if (HeaderUtils.isSetCookieNameMatches(setCookieString, setCookieName)) {
            return DefaultHttpSetCookie.parseSetCookie(setCookieString, validate, setCookieString.subSequence(0, setCookieName.length()), setCookieName.length() + 1);
        }
        return null;
    }

    @Nullable
    public static HttpCookiePair parseCookiePair(CharSequence cookieString, CharSequence cookiePairName) {
        int equalsIndex;
        int start = 0;
        while ((equalsIndex = AsciiString.indexOf((CharSequence)cookieString, (char)'=', (int)start)) > 0 && cookieString.length() - 1 > equalsIndex) {
            int nameLen = equalsIndex - start;
            int semiIndex = HeaderUtils.nextCookieDelimiter(cookieString, equalsIndex + 1);
            if (nameLen == cookiePairName.length() && AsciiString.regionMatches((CharSequence)cookiePairName, (boolean)true, (int)0, (CharSequence)cookieString, (int)start, (int)nameLen)) {
                return DefaultHttpCookiePair.parseCookiePair(cookieString, start, nameLen, semiIndex);
            }
            if (semiIndex < 0 || cookieString.length() - 2 <= semiIndex) break;
            start = semiIndex + 2;
        }
        return null;
    }

    @Nullable
    public static CharSequence removeCookiePairs(CharSequence cookieString, CharSequence cookiePairName) {
        int equalsIndex;
        int start = 0;
        int beginCopyIndex = 0;
        StringBuilder sb = null;
        while ((equalsIndex = AsciiString.indexOf((CharSequence)cookieString, (char)'=', (int)start)) > 0 && cookieString.length() - 1 > equalsIndex) {
            int nameLen = equalsIndex - start;
            int semiIndex = HeaderUtils.nextCookieDelimiter(cookieString, equalsIndex + 1);
            if (nameLen == cookiePairName.length() && AsciiString.regionMatches((CharSequence)cookiePairName, (boolean)true, (int)0, (CharSequence)cookieString, (int)start, (int)nameLen)) {
                if (beginCopyIndex != start) {
                    if (sb == null) {
                        sb = new StringBuilder(cookieString.length() - beginCopyIndex);
                    } else {
                        sb.append("; ");
                    }
                    sb.append(cookieString.subSequence(beginCopyIndex, start - 2));
                }
                if (semiIndex < 0 || cookieString.length() - 2 <= semiIndex) {
                    start = cookieString.length();
                    break;
                }
                beginCopyIndex = start = semiIndex + 2;
                continue;
            }
            if (semiIndex > 0) {
                if (cookieString.length() - 2 <= semiIndex) {
                    throw new IllegalArgumentException("cookie is not allowed to end with ;");
                }
                start = semiIndex + 2;
                continue;
            }
            if (beginCopyIndex == 0) break;
            if (sb == null) {
                sb = new StringBuilder(cookieString.length() - beginCopyIndex);
            } else {
                sb.append("; ");
            }
            sb.append(cookieString.subSequence(beginCopyIndex, cookieString.length()));
            break;
        }
        return sb == null ? (start == cookieString.length() ? "" : null) : sb.toString();
    }

    private static int nextCookieDelimiter(CharSequence cookieHeaderValue, int startIndex) {
        if (cookieHeaderValue instanceof AsciiString) {
            return HeaderUtils.nextCookieDelimiter((AsciiString)cookieHeaderValue, startIndex);
        }
        boolean inQuotes = false;
        int len = cookieHeaderValue.length();
        for (int i = startIndex; i < len; ++i) {
            char value = cookieHeaderValue.charAt(i);
            if (value == ';') {
                if (inQuotes) {
                    throw new IllegalArgumentException("The ; character cannot appear in quoted cookie values");
                }
                return i;
            }
            if (value != '\"') continue;
            inQuotes = !inQuotes;
        }
        return -1;
    }

    private static int nextCookieDelimiter(AsciiString cookieHeaderValue, int startIndex) {
        boolean inQuotes = false;
        int len = cookieHeaderValue.length();
        byte[] array = cookieHeaderValue.array();
        for (int i = cookieHeaderValue.arrayOffset() + startIndex; i < len; ++i) {
            char value = AsciiString.b2c((byte)array[i]);
            if (value == ';') {
                if (inQuotes) {
                    throw new IllegalArgumentException("The ; character cannot appear in quoted cookie values");
                }
                return i;
            }
            if (value != '\"') continue;
            inQuotes = !inQuotes;
        }
        return -1;
    }

    public static abstract class AbstractCookiesByNameIterator
    implements Iterator<HttpCookiePair> {
        private final CharSequence cookiePairName;
        private int nextNextStart;
        @Nullable
        private HttpCookiePair next;

        protected AbstractCookiesByNameIterator(CharSequence cookiePairName) {
            this.cookiePairName = cookiePairName;
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        @Override
        public final HttpCookiePair next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            HttpCookiePair current = this.next;
            CharSequence cookieHeaderValue = this.cookieHeaderValue();
            this.next = cookieHeaderValue == null ? null : this.findNext(cookieHeaderValue);
            return current;
        }

        @Nullable
        protected abstract CharSequence cookieHeaderValue();

        protected abstract void advanceCookieHeaderValue();

        protected final void initNext(CharSequence cookieHeaderValue) {
            this.next = this.findNext(cookieHeaderValue);
        }

        @Nullable
        private HttpCookiePair findNext(CharSequence cookieHeaderValue) {
            int equalsIndex;
            while ((equalsIndex = AsciiString.indexOf((CharSequence)cookieHeaderValue, (char)'=', (int)this.nextNextStart)) > 0 && cookieHeaderValue.length() - 1 > equalsIndex) {
                int nameLen = equalsIndex - this.nextNextStart;
                int semiIndex = HeaderUtils.nextCookieDelimiter(cookieHeaderValue, equalsIndex + 1);
                if (nameLen == this.cookiePairName.length() && AsciiString.regionMatches((CharSequence)this.cookiePairName, (boolean)true, (int)0, (CharSequence)cookieHeaderValue, (int)this.nextNextStart, (int)nameLen)) {
                    HttpCookiePair next = DefaultHttpCookiePair.parseCookiePair(cookieHeaderValue, this.nextNextStart, nameLen, semiIndex);
                    if (semiIndex > 0) {
                        if (cookieHeaderValue.length() - 2 <= semiIndex) {
                            this.advanceCookieHeaderValue();
                            this.nextNextStart = 0;
                        } else {
                            this.nextNextStart = semiIndex + 2;
                        }
                    } else {
                        this.advanceCookieHeaderValue();
                        this.nextNextStart = 0;
                    }
                    return next;
                }
                if (semiIndex > 0) {
                    if (cookieHeaderValue.length() - 2 <= semiIndex) {
                        throw new IllegalArgumentException("cookie is not allowed to end with ;");
                    }
                    this.nextNextStart = semiIndex + 2;
                    continue;
                }
                this.advanceCookieHeaderValue();
                cookieHeaderValue = this.cookieHeaderValue();
                if (cookieHeaderValue == null) break;
                this.nextNextStart = 0;
            }
            return null;
        }
    }

    public static abstract class AbstractCookiesIterator
    implements Iterator<HttpCookiePair> {
        @Nullable
        private HttpCookiePair next;
        private int nextNextStart;

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        @Override
        public final HttpCookiePair next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            HttpCookiePair current = this.next;
            CharSequence cookieHeaderValue = this.cookieHeaderValue();
            this.next = cookieHeaderValue == null ? null : this.findNext(cookieHeaderValue);
            return current;
        }

        @Nullable
        protected abstract CharSequence cookieHeaderValue();

        protected abstract void advanceCookieHeaderValue();

        protected final void initNext(CharSequence cookieHeaderValue) {
            this.next = this.findNext(cookieHeaderValue);
        }

        private HttpCookiePair findNext(CharSequence cookieHeaderValue) {
            int semiIndex = HeaderUtils.nextCookieDelimiter(cookieHeaderValue, this.nextNextStart);
            HttpCookiePair next = DefaultHttpCookiePair.parseCookiePair(cookieHeaderValue, this.nextNextStart, semiIndex);
            if (semiIndex > 0) {
                if (cookieHeaderValue.length() - 2 <= semiIndex) {
                    this.advanceCookieHeaderValue();
                    this.nextNextStart = 0;
                } else {
                    this.nextNextStart = semiIndex + 2;
                }
            } else {
                this.advanceCookieHeaderValue();
                this.nextNextStart = 0;
            }
            return next;
        }
    }
}

