/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http.headers;

import io.netty5.handler.codec.http.HttpHeaderNames;
import io.netty5.handler.codec.http.headers.DefaultHttpSetCookie;
import io.netty5.handler.codec.http.headers.HeaderUtils;
import io.netty5.handler.codec.http.headers.HeaderValidationException;
import io.netty5.handler.codec.http.headers.HttpCookiePair;
import io.netty5.handler.codec.http.headers.HttpHeaders;
import io.netty5.handler.codec.http.headers.HttpSetCookie;
import io.netty5.handler.codec.http.headers.MultiMap;
import io.netty5.util.AsciiString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultHttpHeaders
extends MultiMap<CharSequence, CharSequence>
implements HttpHeaders {
    protected final boolean validateNames;
    protected final boolean validateCookies;
    protected final boolean validateValues;

    public DefaultHttpHeaders(int arraySizeHint, boolean validateNames, boolean validateCookies, boolean validateValues) {
        super(arraySizeHint);
        this.validateNames = validateNames;
        this.validateCookies = validateCookies;
        this.validateValues = validateValues;
    }

    @Override
    public boolean contains(CharSequence key, CharSequence value) {
        return this.contains(key, value, DefaultHttpHeaders::containsCommaSeparatedTrimmedCaseSensitive);
    }

    @Override
    public boolean containsIgnoreCase(CharSequence name, CharSequence value) {
        return this.contains(name, value, DefaultHttpHeaders::containsCommaSeparatedTrimmedCaseInsensitive);
    }

    private static boolean containsCommaSeparatedTrimmedCaseSensitive(CharSequence expected, CharSequence rawNext) {
        return DefaultHttpHeaders.containsCommaSeparatedTrimmed(expected, rawNext, AsciiString::contentEquals);
    }

    private static boolean containsCommaSeparatedTrimmedCaseInsensitive(CharSequence expected, CharSequence rawNext) {
        return DefaultHttpHeaders.containsCommaSeparatedTrimmed(expected, rawNext, AsciiString::contentEqualsIgnoreCase);
    }

    private static boolean containsCommaSeparatedTrimmed(CharSequence expected, CharSequence rawNext, BiPredicate<CharSequence, CharSequence> equality) {
        int begin = 0;
        int end = AsciiString.indexOf((CharSequence)rawNext, (char)',', (int)begin);
        if (end == -1) {
            return equality.test(AsciiString.trim((CharSequence)rawNext), expected);
        }
        do {
            if (!equality.test(AsciiString.trim((CharSequence)rawNext.subSequence(begin, end)), expected)) continue;
            return true;
        } while ((end = AsciiString.indexOf((CharSequence)rawNext, (char)',', (int)(begin = end + 1))) != -1);
        if (begin < rawNext.length()) {
            return equality.test(AsciiString.trim((CharSequence)rawNext.subSequence(begin, rawNext.length())), expected);
        }
        return false;
    }

    @Override
    @Nullable
    public HttpCookiePair getCookie(CharSequence name) {
        int keyHash = this.hashCode((CharSequence)HttpHeaderNames.COOKIE);
        MultiMap.BucketHead bucketHead = this.entries[this.index(keyHash)];
        if (bucketHead == null) {
            return null;
        }
        MultiMap.MultiMapEntry e = bucketHead.entry;
        do {
            HttpCookiePair cookiePair;
            if (e.keyHash != keyHash || !AsciiString.contentEqualsIgnoreCase((CharSequence)HttpHeaderNames.COOKIE, (CharSequence)((CharSequence)e.getKey())) || (cookiePair = HeaderUtils.parseCookiePair((CharSequence)e.value, name)) == null) continue;
            return cookiePair;
        } while ((e = e.bucketNext) != null);
        return null;
    }

    @Override
    @Nullable
    public HttpSetCookie getSetCookie(CharSequence name) {
        int keyHash = this.hashCode((CharSequence)HttpHeaderNames.SET_COOKIE);
        int i = this.index(keyHash);
        MultiMap.BucketHead bucketHead = this.entries[i];
        if (bucketHead != null) {
            MultiMap.MultiMapEntry e = bucketHead.entry;
            do {
                HttpSetCookie setCookie;
                if (e.keyHash != keyHash || !AsciiString.contentEqualsIgnoreCase((CharSequence)HttpHeaderNames.SET_COOKIE, (CharSequence)((CharSequence)e.getKey())) || (setCookie = HeaderUtils.parseSetCookie((CharSequence)e.value, name, this.validateCookies)) == null) continue;
                return setCookie;
            } while ((e = e.bucketNext) != null);
        }
        return null;
    }

    @Override
    public Iterator<HttpCookiePair> getCookiesIterator() {
        int keyHash = this.hashCode((CharSequence)HttpHeaderNames.COOKIE);
        MultiMap.BucketHead bucketHead = this.entries[this.index(keyHash)];
        if (bucketHead == null) {
            return Collections.emptyIterator();
        }
        MultiMap.MultiMapEntry<CharSequence, CharSequence> e = bucketHead.entry;
        do {
            if (e.keyHash != keyHash || !AsciiString.contentEqualsIgnoreCase((CharSequence)HttpHeaderNames.COOKIE, (CharSequence)((CharSequence)e.getKey()))) continue;
            return new CookiesIterator(keyHash, e);
        } while ((e = e.bucketNext) != null);
        return Collections.emptyIterator();
    }

    @Override
    public Iterator<HttpCookiePair> getCookiesIterator(CharSequence name) {
        int keyHash = this.hashCode((CharSequence)HttpHeaderNames.COOKIE);
        MultiMap.BucketHead bucketHead = this.entries[this.index(keyHash)];
        if (bucketHead == null) {
            return Collections.emptyIterator();
        }
        MultiMap.MultiMapEntry<CharSequence, CharSequence> e = bucketHead.entry;
        do {
            if (e.keyHash != keyHash || !AsciiString.contentEqualsIgnoreCase((CharSequence)HttpHeaderNames.COOKIE, (CharSequence)((CharSequence)e.getKey()))) continue;
            return new CookiesByNameIterator(keyHash, e, name);
        } while ((e = e.bucketNext) != null);
        return Collections.emptyIterator();
    }

    @Override
    public Iterator<HttpSetCookie> getSetCookiesIterator() {
        int keyHash = this.hashCode((CharSequence)HttpHeaderNames.SET_COOKIE);
        MultiMap.BucketHead bucketHead = this.entries[this.index(keyHash)];
        if (bucketHead == null) {
            return Collections.emptyIterator();
        }
        MultiMap.MultiMapEntry<CharSequence, CharSequence> e = bucketHead.entry;
        do {
            if (e.keyHash != keyHash || !AsciiString.contentEqualsIgnoreCase((CharSequence)HttpHeaderNames.SET_COOKIE, (CharSequence)((CharSequence)e.getKey()))) continue;
            return new SetCookiesIterator(e);
        } while ((e = e.bucketNext) != null);
        return Collections.emptyIterator();
    }

    @Override
    public Iterator<HttpSetCookie> getSetCookiesIterator(CharSequence name) {
        int keyHash = this.hashCode((CharSequence)HttpHeaderNames.SET_COOKIE);
        MultiMap.BucketHead bucketHead = this.entries[this.index(keyHash)];
        if (bucketHead == null) {
            return Collections.emptyIterator();
        }
        MultiMap.MultiMapEntry<CharSequence, CharSequence> e = bucketHead.entry;
        do {
            HttpSetCookie setCookie;
            if (e.keyHash != keyHash || !AsciiString.contentEqualsIgnoreCase((CharSequence)HttpHeaderNames.SET_COOKIE, (CharSequence)((CharSequence)e.getKey())) || (setCookie = HeaderUtils.parseSetCookie((CharSequence)e.value, name, this.validateCookies)) == null) continue;
            return new SetCookiesByNameIterator(e, setCookie);
        } while ((e = e.bucketNext) != null);
        return Collections.emptyIterator();
    }

    @Override
    public Iterator<HttpSetCookie> getSetCookiesIterator(CharSequence name, CharSequence domain, CharSequence path) {
        int keyHash = this.hashCode((CharSequence)HttpHeaderNames.SET_COOKIE);
        MultiMap.BucketHead bucketHead = this.entries[this.index(keyHash)];
        if (bucketHead == null) {
            return Collections.emptyIterator();
        }
        MultiMap.MultiMapEntry<CharSequence, CharSequence> e = bucketHead.entry;
        do {
            HttpSetCookie setCookie;
            if (e.keyHash != keyHash || !AsciiString.contentEqualsIgnoreCase((CharSequence)HttpHeaderNames.SET_COOKIE, (CharSequence)((CharSequence)e.getKey())) || (setCookie = HeaderUtils.parseSetCookie((CharSequence)e.value, name, this.validateCookies)) == null || !HeaderUtils.domainMatches(domain, setCookie.domain()) || !HeaderUtils.pathMatches(path, setCookie.path())) continue;
            return new SetCookiesByNameDomainPathIterator(e, setCookie, domain, path);
        } while ((e = e.bucketNext) != null);
        return Collections.emptyIterator();
    }

    @Override
    public HttpHeaders addCookie(HttpCookiePair cookie) {
        CharSequence encoded = cookie.encoded();
        int keyHash = this.hashCode((CharSequence)HttpHeaderNames.COOKIE);
        MultiMap.BucketHead bucketHead = this.entries[this.index(keyHash)];
        if (bucketHead != null) {
            MultiMap.MultiMapEntry e = bucketHead.entry;
            do {
                if (e.keyHash != keyHash || !AsciiString.contentEqualsIgnoreCase((CharSequence)HttpHeaderNames.COOKIE, (CharSequence)((CharSequence)e.getKey()))) continue;
                e.value = e.value + "; " + this.validateValue((CharSequence)HttpHeaderNames.COOKIE, encoded);
                return this;
            } while ((e = e.bucketNext) != null);
        }
        this.put(HttpHeaderNames.COOKIE, encoded);
        return this;
    }

    @Override
    public HttpHeaders addSetCookie(HttpSetCookie cookie) {
        this.put(HttpHeaderNames.SET_COOKIE, cookie.encoded());
        return this;
    }

    @Override
    public boolean removeCookies(CharSequence name) {
        int keyHash = this.hashCode((CharSequence)HttpHeaderNames.COOKIE);
        int bucketIndex = this.index(keyHash);
        MultiMap.BucketHead bucketHead = this.entries[bucketIndex];
        if (bucketHead == null) {
            return false;
        }
        int beforeSize = this.size();
        ArrayList<CharSequence> cookiesToAdd = null;
        MultiMap.MultiMapEntry e = bucketHead.entry;
        do {
            if (e.keyHash == keyHash && AsciiString.contentEqualsIgnoreCase((CharSequence)HttpHeaderNames.COOKIE, (CharSequence)((CharSequence)e.getKey()))) {
                CharSequence newHeaderValue = HeaderUtils.removeCookiePairs((CharSequence)e.value, name);
                if (newHeaderValue != null) {
                    if (newHeaderValue.length() != 0) {
                        if (cookiesToAdd == null) {
                            cookiesToAdd = new ArrayList<CharSequence>(4);
                        }
                        cookiesToAdd.add(newHeaderValue);
                    }
                    MultiMap.MultiMapEntry tmpEntry = e;
                    e = e.bucketNext;
                    this.removeEntry(bucketHead, tmpEntry, bucketIndex);
                    continue;
                }
                e = e.bucketNext;
                continue;
            }
            e = e.bucketNext;
        } while (e != null);
        if (cookiesToAdd != null) {
            for (CharSequence cookies : cookiesToAdd) {
                this.add((CharSequence)HttpHeaderNames.COOKIE, cookies);
            }
            return true;
        }
        return beforeSize != this.size();
    }

    @Override
    public boolean removeSetCookies(CharSequence name) {
        int keyHash = this.hashCode((CharSequence)HttpHeaderNames.SET_COOKIE);
        int bucketIndex = this.index(keyHash);
        MultiMap.BucketHead bucketHead = this.entries[bucketIndex];
        if (bucketHead == null) {
            return false;
        }
        int sizeBefore = this.size();
        MultiMap.MultiMapEntry e = bucketHead.entry;
        do {
            if (e.keyHash == keyHash && AsciiString.contentEqualsIgnoreCase((CharSequence)HttpHeaderNames.SET_COOKIE, (CharSequence)((CharSequence)e.getKey())) && HeaderUtils.isSetCookieNameMatches((CharSequence)e.value, name)) {
                MultiMap.MultiMapEntry tmpEntry = e;
                e = e.bucketNext;
                this.removeEntry(bucketHead, tmpEntry, bucketIndex);
                continue;
            }
            e = e.bucketNext;
        } while (e != null);
        return sizeBefore != this.size();
    }

    @Override
    public boolean removeSetCookies(CharSequence name, CharSequence domain, CharSequence path) {
        int keyHash = this.hashCode((CharSequence)HttpHeaderNames.SET_COOKIE);
        int bucketIndex = this.index(keyHash);
        MultiMap.BucketHead bucketHead = this.entries[bucketIndex];
        if (bucketHead == null) {
            return false;
        }
        int sizeBefore = this.size();
        MultiMap.MultiMapEntry e = bucketHead.entry;
        do {
            if (e.keyHash == keyHash && AsciiString.contentEqualsIgnoreCase((CharSequence)HttpHeaderNames.SET_COOKIE, (CharSequence)((CharSequence)e.getKey()))) {
                HttpSetCookie setCookie = HeaderUtils.parseSetCookie((CharSequence)e.value, name, false);
                if (setCookie != null && HeaderUtils.domainMatches(domain, setCookie.domain()) && HeaderUtils.pathMatches(path, setCookie.path())) {
                    MultiMap.MultiMapEntry tmpEntry = e;
                    e = e.bucketNext;
                    this.removeEntry(bucketHead, tmpEntry, bucketIndex);
                    continue;
                }
                e = e.bucketNext;
                continue;
            }
            e = e.bucketNext;
        } while (e != null);
        return sizeBefore != this.size();
    }

    @Nullable
    private static MultiMap.MultiMapEntry<CharSequence, CharSequence> findCookieHeader(int cookieHeaderNameHash, @Nullable MultiMap.MultiMapEntry<CharSequence, CharSequence> current) {
        while (current != null) {
            if (current.keyHash == cookieHeaderNameHash && AsciiString.contentEqualsIgnoreCase((CharSequence)HttpHeaderNames.COOKIE, (CharSequence)current.getKey())) {
                return current;
            }
            current = current.bucketNext;
        }
        return null;
    }

    @Override
    protected CharSequence validateKey(@Nullable CharSequence name, boolean forAdd) {
        if (name == null || name.length() == 0) {
            throw new HeaderValidationException("Empty header names are not allowed");
        }
        if (this.validateNames) {
            DefaultHttpHeaders.validateHeaderName(name);
        }
        return name;
    }

    @Override
    protected CharSequence validateValue(CharSequence key, CharSequence value) {
        if (this.validateValues) {
            DefaultHttpHeaders.validateHeaderValue(value);
        }
        return value;
    }

    protected static void validateHeaderName(CharSequence name) {
        HeaderUtils.validateToken(name);
    }

    private static void validateHeaderValue(CharSequence value) {
        HeaderUtils.validateHeaderValue(value);
    }

    @Override
    public HttpHeaders copy() {
        DefaultHttpHeaders copy = new DefaultHttpHeaders(this.entries.length, this.validateNames, this.validateCookies, this.validateValues);
        copy.putAll(this);
        return copy;
    }

    @Override
    @Nullable
    public CharSequence get(CharSequence name) {
        return (CharSequence)this.getValue(name);
    }

    @Override
    @Nullable
    public CharSequence getAndRemove(CharSequence name) {
        return (CharSequence)this.removeAllAndGetFirst(name);
    }

    @Override
    public Iterator<CharSequence> valuesIterator(CharSequence name) {
        return this.getValues(name);
    }

    @Override
    public Set<CharSequence> names() {
        return this.getKeys();
    }

    @Override
    public HttpHeaders clear() {
        this.clearAll();
        return this;
    }

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> iterator() {
        return this.entryIterator();
    }

    @Override
    public HttpHeaders add(CharSequence name, CharSequence value) {
        this.put(name, value);
        return this;
    }

    @Override
    public HttpHeaders add(CharSequence name, Iterable<? extends CharSequence> values) {
        this.putAll(name, values);
        return this;
    }

    @Override
    public HttpHeaders add(CharSequence name, CharSequence ... values) {
        this.putAll(name, values);
        return this;
    }

    @Override
    public HttpHeaders add(HttpHeaders headers) {
        if (headers == this) {
            throw new IllegalArgumentException("HttpHeaders object cannot be added to itself.");
        }
        if (headers instanceof MultiMap) {
            this.putAll((MultiMap)((Object)headers));
        } else {
            for (Map.Entry<CharSequence, CharSequence> header : headers) {
                this.add(header.getKey(), header.getValue());
            }
        }
        return this;
    }

    @Override
    public HttpHeaders set(CharSequence name, CharSequence value) {
        this.putExclusive(name, value);
        return this;
    }

    @Override
    public HttpHeaders set(CharSequence name, Iterable<? extends CharSequence> values) {
        this.putExclusive(name, values);
        return this;
    }

    @Override
    public HttpHeaders set(CharSequence name, CharSequence ... values) {
        this.putExclusive(name, (V[])values);
        return this;
    }

    @Override
    public boolean remove(CharSequence name) {
        return this.removeAll(name);
    }

    @Override
    public boolean remove(CharSequence name, CharSequence value) {
        return this.remove(name, value, true);
    }

    @Override
    public boolean removeIgnoreCase(CharSequence name, CharSequence value) {
        return this.remove(name, value, false);
    }

    private boolean remove(CharSequence name, CharSequence value, boolean caseSensitive) {
        int nameHash = this.hashCode(name);
        int bucketIndex = this.index(nameHash);
        MultiMap.BucketHead bucketHead = this.entries[bucketIndex];
        if (bucketHead == null) {
            return false;
        }
        int sizeBefore = this.size();
        MultiMap.MultiMapEntry e = bucketHead.entry;
        do {
            if (e.keyHash == nameHash && this.equals(name, (CharSequence)e.getKey()) && (caseSensitive ? AsciiString.contentEquals((CharSequence)value, (CharSequence)((CharSequence)e.value)) : AsciiString.contentEqualsIgnoreCase((CharSequence)value, (CharSequence)((CharSequence)e.value)))) {
                MultiMap.MultiMapEntry tmpEntry = e;
                e = e.bucketNext;
                this.removeEntry(bucketHead, tmpEntry, bucketIndex);
                continue;
            }
            e = e.bucketNext;
        } while (e != null);
        return sizeBefore != this.size();
    }

    @Override
    public String toString() {
        return this.toString(HeaderUtils.DEFAULT_HEADER_FILTER);
    }

    @Override
    protected int hashCode(CharSequence name) {
        return AsciiString.hashCode((CharSequence)name);
    }

    @Override
    protected boolean equals(CharSequence name1, CharSequence name2) {
        return AsciiString.contentEqualsIgnoreCase((CharSequence)name1, (CharSequence)name2);
    }

    @Override
    protected boolean isKeyEqualityCompatible(MultiMap<? extends CharSequence, ? extends CharSequence> multiMap) {
        return multiMap.getClass().equals(this.getClass());
    }

    @Override
    protected int hashCodeForValue(CharSequence value) {
        return value.hashCode();
    }

    @Override
    protected boolean equalsForValue(CharSequence value1, CharSequence value2) {
        return AsciiString.contentEquals((CharSequence)value1, (CharSequence)value2);
    }

    private final class SetCookiesByNameDomainPathIterator
    implements Iterator<HttpSetCookie> {
        private final CharSequence domain;
        private final CharSequence path;
        @Nullable
        private HttpSetCookie next;
        @Nullable
        private MultiMap.MultiMapEntry<CharSequence, CharSequence> nextEntry;
        @Nullable
        private MultiMap.MultiMapEntry<CharSequence, CharSequence> previous;

        SetCookiesByNameDomainPathIterator(@NotNull MultiMap.MultiMapEntry<CharSequence, CharSequence> first, HttpSetCookie next, @NotNull CharSequence domain, CharSequence path) {
            this.domain = domain;
            this.path = path;
            this.next = next;
            this.nextEntry = first;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public HttpSetCookie next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            assert (this.nextEntry != null);
            HttpSetCookie currentCookie = this.next;
            this.previous = this.nextEntry;
            this.next = null;
            this.nextEntry = this.nextEntry.bucketNext;
            while (this.nextEntry != null) {
                if (this.nextEntry.keyHash == this.previous.keyHash && AsciiString.contentEqualsIgnoreCase((CharSequence)HttpHeaderNames.SET_COOKIE, (CharSequence)this.nextEntry.getKey())) {
                    this.next = HeaderUtils.parseSetCookie((CharSequence)this.nextEntry.value, currentCookie.name(), DefaultHttpHeaders.this.validateCookies);
                    if (this.next != null && HeaderUtils.domainMatches(this.domain, this.next.domain()) && HeaderUtils.pathMatches(this.path, this.next.path())) break;
                }
                this.nextEntry = this.nextEntry.bucketNext;
            }
            return currentCookie;
        }

        @Override
        public void remove() {
            if (this.previous == null) {
                throw new IllegalStateException();
            }
            int i = DefaultHttpHeaders.this.index(this.previous.keyHash);
            DefaultHttpHeaders.this.removeEntry(DefaultHttpHeaders.this.entries[i], this.previous, i);
            this.previous = null;
        }
    }

    private final class SetCookiesByNameIterator
    implements Iterator<HttpSetCookie> {
        @Nullable
        private HttpSetCookie next;
        @Nullable
        private MultiMap.MultiMapEntry<CharSequence, CharSequence> nextEntry;
        @Nullable
        private MultiMap.MultiMapEntry<CharSequence, CharSequence> previous;

        SetCookiesByNameIterator(@NotNull MultiMap.MultiMapEntry<CharSequence, CharSequence> first, HttpSetCookie next) {
            this.next = next;
            this.nextEntry = first;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public HttpSetCookie next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            assert (this.nextEntry != null);
            HttpSetCookie currentCookie = this.next;
            this.previous = this.nextEntry;
            this.next = null;
            this.nextEntry = this.nextEntry.bucketNext;
            while (this.nextEntry != null) {
                if (this.nextEntry.keyHash == this.previous.keyHash && AsciiString.contentEqualsIgnoreCase((CharSequence)HttpHeaderNames.SET_COOKIE, (CharSequence)this.nextEntry.getKey())) {
                    this.next = HeaderUtils.parseSetCookie((CharSequence)this.nextEntry.value, currentCookie.name(), DefaultHttpHeaders.this.validateCookies);
                    if (this.next != null) break;
                }
                this.nextEntry = this.nextEntry.bucketNext;
            }
            return currentCookie;
        }

        @Override
        public void remove() {
            if (this.previous == null) {
                throw new IllegalStateException();
            }
            int i = DefaultHttpHeaders.this.index(this.previous.keyHash);
            DefaultHttpHeaders.this.removeEntry(DefaultHttpHeaders.this.entries[i], this.previous, i);
            this.previous = null;
        }
    }

    private final class SetCookiesIterator
    implements Iterator<HttpSetCookie> {
        @Nullable
        private MultiMap.MultiMapEntry<CharSequence, CharSequence> current;
        @Nullable
        private MultiMap.MultiMapEntry<CharSequence, CharSequence> previous;

        SetCookiesIterator(MultiMap.MultiMapEntry<CharSequence, CharSequence> first) {
            this.current = first;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public HttpSetCookie next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            this.previous = this.current;
            this.current = this.findNext(this.current.bucketNext);
            return DefaultHttpSetCookie.parseSetCookie((CharSequence)this.previous.value, DefaultHttpHeaders.this.validateCookies);
        }

        @Override
        public void remove() {
            if (this.previous == null) {
                throw new IllegalStateException();
            }
            int i = DefaultHttpHeaders.this.index(this.previous.keyHash);
            DefaultHttpHeaders.this.removeEntry(DefaultHttpHeaders.this.entries[i], this.previous, i);
            this.previous = null;
        }

        @Nullable
        private MultiMap.MultiMapEntry<CharSequence, CharSequence> findNext(@Nullable MultiMap.MultiMapEntry<CharSequence, CharSequence> e) {
            assert (this.previous != null);
            while (e != null) {
                if (e.keyHash == this.previous.keyHash && AsciiString.contentEqualsIgnoreCase((CharSequence)HttpHeaderNames.SET_COOKIE, (CharSequence)e.getKey())) {
                    return e;
                }
                e = e.bucketNext;
            }
            return null;
        }
    }

    private static final class CookiesByNameIterator
    extends HeaderUtils.AbstractCookiesByNameIterator {
        private final int cookieHeaderNameHash;
        @Nullable
        private MultiMap.MultiMapEntry<CharSequence, CharSequence> current;

        CookiesByNameIterator(int cookieHeaderNameHash, @NotNull MultiMap.MultiMapEntry<CharSequence, CharSequence> first, CharSequence name) {
            super(name);
            this.cookieHeaderNameHash = cookieHeaderNameHash;
            this.current = first;
            this.initNext((CharSequence)this.current.value);
        }

        @Override
        @Nullable
        protected CharSequence cookieHeaderValue() {
            return this.current == null ? null : (CharSequence)this.current.value;
        }

        @Override
        protected void advanceCookieHeaderValue() {
            assert (this.current != null);
            this.current = DefaultHttpHeaders.findCookieHeader(this.cookieHeaderNameHash, this.current.bucketNext);
        }
    }

    private static final class CookiesIterator
    extends HeaderUtils.AbstractCookiesIterator {
        private final int cookieHeaderNameHash;
        @Nullable
        private MultiMap.MultiMapEntry<CharSequence, CharSequence> current;

        CookiesIterator(int cookieHeaderNameHash, @NotNull MultiMap.MultiMapEntry<CharSequence, CharSequence> first) {
            this.cookieHeaderNameHash = cookieHeaderNameHash;
            this.current = first;
            this.initNext((CharSequence)this.current.value);
        }

        @Override
        @Nullable
        protected CharSequence cookieHeaderValue() {
            return this.current == null ? null : (CharSequence)this.current.value;
        }

        @Override
        protected void advanceCookieHeaderValue() {
            assert (this.current != null);
            this.current = DefaultHttpHeaders.findCookieHeader(this.cookieHeaderNameHash, this.current.bucketNext);
        }
    }
}

