/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http.cors;

import io.netty5.channel.ChannelFutureListeners;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.http.DefaultFullHttpResponse;
import io.netty5.handler.codec.http.HttpHeaderNames;
import io.netty5.handler.codec.http.HttpHeaderValues;
import io.netty5.handler.codec.http.HttpMethod;
import io.netty5.handler.codec.http.HttpRequest;
import io.netty5.handler.codec.http.HttpResponse;
import io.netty5.handler.codec.http.HttpResponseStatus;
import io.netty5.handler.codec.http.HttpUtil;
import io.netty5.handler.codec.http.cors.CorsConfig;
import io.netty5.handler.codec.http.headers.HttpHeaders;
import io.netty5.util.AsciiString;
import io.netty5.util.concurrent.Future;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.StringUtil;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

public class CorsHandler
implements ChannelHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(CorsHandler.class);
    private static final String ANY_ORIGIN = "*";
    private static final String NULL_ORIGIN = "null";
    private CorsConfig config;
    private HttpRequest request;
    private final List<CorsConfig> configList;
    private final boolean isShortCircuit;

    public CorsHandler(CorsConfig config) {
        this(Collections.singletonList(Objects.requireNonNull(config, "config")), config.isShortCircuit());
    }

    public CorsHandler(List<CorsConfig> configList, boolean isShortCircuit) {
        ObjectUtil.checkNonEmpty(configList, (String)"configList");
        this.configList = configList;
        this.isShortCircuit = isShortCircuit;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            this.request = (HttpRequest)msg;
            CharSequence origin = this.request.headers().get((CharSequence)HttpHeaderNames.ORIGIN);
            this.config = this.getForOrigin(origin);
            if (CorsHandler.isPreflightRequest(this.request)) {
                this.handlePreflight(ctx, this.request);
                return;
            }
            if (this.isShortCircuit && origin != null && this.config == null) {
                CorsHandler.forbidden(ctx, this.request);
                return;
            }
        }
        ctx.fireChannelRead(msg);
    }

    private void handlePreflight(ChannelHandlerContext ctx, HttpRequest request) throws Exception {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(request.protocolVersion(), HttpResponseStatus.OK, ctx.bufferAllocator().allocate(0), true);
        if (this.setOrigin(response)) {
            this.setAllowMethods(response);
            this.setAllowHeaders(response);
            this.setAllowCredentials(response);
            this.setMaxAge(response);
            this.setPreflightHeaders(response);
            this.setAllowPrivateNetwork(response);
        }
        if (!response.headers().contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)HttpHeaderValues.ZERO);
        }
        if (request instanceof AutoCloseable) {
            ((AutoCloseable)((Object)request)).close();
        }
        CorsHandler.respond(ctx, request, response);
    }

    private void setPreflightHeaders(HttpResponse response) {
        HttpHeaders headers = response.headers();
        HttpHeaders preflight = this.config.preflightResponseHeaders();
        for (CharSequence name : preflight.names()) {
            headers.add(name, CorsHandler.toCsv(preflight.values(name)));
        }
    }

    private CorsConfig getForOrigin(CharSequence requestOrigin) {
        for (CorsConfig corsConfig : this.configList) {
            if (corsConfig.isAnyOriginSupported()) {
                return corsConfig;
            }
            if (corsConfig.origins().contains(requestOrigin)) {
                return corsConfig;
            }
            if (!corsConfig.isNullOriginAllowed() && !AsciiString.contentEquals((CharSequence)NULL_ORIGIN, (CharSequence)requestOrigin)) continue;
            return corsConfig;
        }
        return null;
    }

    private boolean setOrigin(HttpResponse response) {
        CharSequence origin = this.request.headers().get((CharSequence)HttpHeaderNames.ORIGIN);
        if (origin != null && this.config != null) {
            if (AsciiString.contentEquals((CharSequence)NULL_ORIGIN, (CharSequence)origin) && this.config.isNullOriginAllowed()) {
                CorsHandler.setNullOrigin(response);
                return true;
            }
            if (this.config.isAnyOriginSupported()) {
                if (this.config.isCredentialsAllowed()) {
                    this.echoRequestOrigin(response);
                    CorsHandler.setVaryHeader(response);
                } else {
                    CorsHandler.setAnyOrigin(response);
                }
                return true;
            }
            if (this.config.origins().contains(origin)) {
                CorsHandler.setOrigin(response, origin);
                CorsHandler.setVaryHeader(response);
                return true;
            }
            logger.debug("Request origin [{}]] was not among the configured origins [{}]", (Object)origin, this.config.origins());
        }
        return false;
    }

    private void echoRequestOrigin(HttpResponse response) {
        CorsHandler.setOrigin(response, this.request.headers().get((CharSequence)HttpHeaderNames.ORIGIN));
    }

    private static void setVaryHeader(HttpResponse response) {
        response.headers().set((CharSequence)HttpHeaderNames.VARY, (CharSequence)HttpHeaderNames.ORIGIN);
    }

    private static void setAnyOrigin(HttpResponse response) {
        CorsHandler.setOrigin(response, ANY_ORIGIN);
    }

    private static void setNullOrigin(HttpResponse response) {
        CorsHandler.setOrigin(response, NULL_ORIGIN);
    }

    private static void setOrigin(HttpResponse response, CharSequence origin) {
        response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, origin);
    }

    private void setAllowCredentials(HttpResponse response) {
        if (this.config.isCredentialsAllowed() && !response.headers().contains((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, ANY_ORIGIN)) {
            response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS, (CharSequence)"true");
        }
    }

    private static boolean isPreflightRequest(HttpRequest request) {
        HttpHeaders headers = request.headers();
        return HttpMethod.OPTIONS.equals(request.method()) && headers.contains((CharSequence)HttpHeaderNames.ORIGIN) && headers.contains((CharSequence)HttpHeaderNames.ACCESS_CONTROL_REQUEST_METHOD);
    }

    private void setExposeHeaders(HttpResponse response) {
        if (!this.config.exposedHeaders().isEmpty()) {
            response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS, CorsHandler.toCsv(this.config.exposedHeaders()));
        }
    }

    private void setAllowMethods(HttpResponse response) {
        response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS, CorsHandler.toCsv(this.config.allowedRequestMethods()));
    }

    private void setAllowHeaders(HttpResponse response) {
        response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS, CorsHandler.toCsv(this.config.allowedRequestHeaders()));
    }

    private void setMaxAge(HttpResponse response) {
        response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_MAX_AGE, (CharSequence)String.valueOf(this.config.maxAge()));
    }

    private void setAllowPrivateNetwork(HttpResponse response) {
        if (this.request.headers().contains((CharSequence)HttpHeaderNames.ACCESS_CONTROL_REQUEST_PRIVATE_NETWORK)) {
            if (this.config.isPrivateNetworkAllowed()) {
                response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_PRIVATE_NETWORK, (CharSequence)"true");
            } else {
                response.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_PRIVATE_NETWORK, (CharSequence)"false");
            }
        }
    }

    private static CharSequence toCsv(Iterable<?> headerValues) {
        Iterator<?> itr = headerValues.iterator();
        if (!itr.hasNext()) {
            return AsciiString.EMPTY_STRING;
        }
        StringJoiner joiner = new StringJoiner(",");
        do {
            joiner.add(StringUtil.escapeCsv((CharSequence)String.valueOf(itr.next()), (boolean)true));
        } while (itr.hasNext());
        return joiner.toString();
    }

    public Future<Void> write(ChannelHandlerContext ctx, Object msg) {
        HttpResponse response;
        if (this.config != null && this.config.isCorsSupportEnabled() && msg instanceof HttpResponse && this.setOrigin(response = (HttpResponse)msg)) {
            this.setAllowCredentials(response);
            this.setExposeHeaders(response);
        }
        return ctx.write(msg);
    }

    private static void forbidden(ChannelHandlerContext ctx, HttpRequest request) throws Exception {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(request.protocolVersion(), HttpResponseStatus.FORBIDDEN, ctx.bufferAllocator().allocate(0));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)HttpHeaderValues.ZERO);
        if (request instanceof AutoCloseable) {
            ((AutoCloseable)((Object)request)).close();
        }
        CorsHandler.respond(ctx, request, response);
    }

    private static void respond(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) {
        boolean keepAlive = HttpUtil.isKeepAlive(request);
        HttpUtil.setKeepAlive(response, keepAlive);
        Future future = ctx.writeAndFlush((Object)response);
        if (!keepAlive) {
            future.addListener((Object)ctx, ChannelFutureListeners.CLOSE);
        }
    }
}

