/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http;

import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelPipeline;
import io.netty5.channel.CombinedChannelDuplexHandler;
import io.netty5.channel.internal.DelegatingChannelHandlerContext;
import io.netty5.handler.codec.PrematureChannelClosureException;
import io.netty5.handler.codec.http.HttpClientUpgradeHandler;
import io.netty5.handler.codec.http.HttpMessage;
import io.netty5.handler.codec.http.HttpMethod;
import io.netty5.handler.codec.http.HttpRequest;
import io.netty5.handler.codec.http.HttpRequestEncoder;
import io.netty5.handler.codec.http.HttpResponse;
import io.netty5.handler.codec.http.HttpResponseDecoder;
import io.netty5.handler.codec.http.LastHttpContent;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;

public final class HttpClientCodec
extends CombinedChannelDuplexHandler<HttpResponseDecoder, HttpRequestEncoder>
implements HttpClientUpgradeHandler.SourceCodec {
    public static final boolean DEFAULT_FAIL_ON_MISSING_RESPONSE = false;
    public static final boolean DEFAULT_PARSE_HTTP_AFTER_CONNECT_REQUEST = false;
    private final Queue<HttpMethod> queue = new ArrayDeque<HttpMethod>();
    private final boolean parseHttpAfterConnectRequest;
    private boolean done;
    private final AtomicLong requestResponseCounter = new AtomicLong();
    private final boolean failOnMissingResponse;

    public HttpClientCodec() {
        this(4096, 8192, false);
    }

    public HttpClientCodec(int maxInitialLineLength, int maxHeaderSize) {
        this(maxInitialLineLength, maxHeaderSize, false);
    }

    public HttpClientCodec(int maxInitialLineLength, int maxHeaderSize, boolean failOnMissingResponse) {
        this(maxInitialLineLength, maxHeaderSize, failOnMissingResponse, true);
    }

    public HttpClientCodec(int maxInitialLineLength, int maxHeaderSize, boolean failOnMissingResponse, boolean validateHeaders) {
        this(maxInitialLineLength, maxHeaderSize, failOnMissingResponse, validateHeaders, false);
    }

    public HttpClientCodec(int maxInitialLineLength, int maxHeaderSize, boolean failOnMissingResponse, boolean validateHeaders, boolean parseHttpAfterConnectRequest) {
        this.init((ChannelHandler)new Decoder(maxInitialLineLength, maxHeaderSize, validateHeaders), (ChannelHandler)new Encoder());
        this.failOnMissingResponse = failOnMissingResponse;
        this.parseHttpAfterConnectRequest = parseHttpAfterConnectRequest;
    }

    public HttpClientCodec(int maxInitialLineLength, int maxHeaderSize, boolean failOnMissingResponse, boolean validateHeaders, int initialBufferSize) {
        this(maxInitialLineLength, maxHeaderSize, failOnMissingResponse, validateHeaders, initialBufferSize, false);
    }

    public HttpClientCodec(int maxInitialLineLength, int maxHeaderSize, boolean failOnMissingResponse, boolean validateHeaders, int initialBufferSize, boolean parseHttpAfterConnectRequest) {
        this(maxInitialLineLength, maxHeaderSize, failOnMissingResponse, validateHeaders, initialBufferSize, parseHttpAfterConnectRequest, false);
    }

    public HttpClientCodec(int maxInitialLineLength, int maxHeaderSize, boolean failOnMissingResponse, boolean validateHeaders, int initialBufferSize, boolean parseHttpAfterConnectRequest, boolean allowDuplicateContentLengths) {
        this.init((ChannelHandler)new Decoder(maxInitialLineLength, maxHeaderSize, validateHeaders, initialBufferSize, allowDuplicateContentLengths), (ChannelHandler)new Encoder());
        this.parseHttpAfterConnectRequest = parseHttpAfterConnectRequest;
        this.failOnMissingResponse = failOnMissingResponse;
    }

    @Override
    public void prepareUpgradeFrom(ChannelHandlerContext ctx) {
        ((Encoder)this.outboundHandler()).upgraded = true;
    }

    @Override
    public void upgradeFrom(ChannelHandlerContext ctx) {
        ChannelPipeline p = ctx.pipeline();
        p.remove((ChannelHandler)this);
    }

    public void setSingleDecode(boolean singleDecode) {
        ((HttpResponseDecoder)this.inboundHandler()).setSingleDecode(singleDecode);
    }

    public boolean isSingleDecode() {
        return ((HttpResponseDecoder)this.inboundHandler()).isSingleDecode();
    }

    private final class Decoder
    extends HttpResponseDecoder {
        private ChannelHandlerContext context;

        Decoder(int maxInitialLineLength, int maxHeaderSize, boolean validateHeaders) {
            super(maxInitialLineLength, maxHeaderSize, validateHeaders);
        }

        Decoder(int maxInitialLineLength, int maxHeaderSize, boolean validateHeaders, int initialBufferSize, boolean allowDuplicateContentLengths) {
            super(maxInitialLineLength, maxHeaderSize, validateHeaders, initialBufferSize, allowDuplicateContentLengths);
        }

        protected void handlerAdded0(ChannelHandlerContext ctx) {
            this.context = HttpClientCodec.this.failOnMissingResponse ? new DelegatingChannelHandlerContext(ctx){

                public ChannelHandlerContext fireChannelRead(Object msg) {
                    Decoder.this.decrement(msg);
                    super.fireChannelRead(msg);
                    return this;
                }
            } : ctx;
        }

        @Override
        protected void decode(ChannelHandlerContext ctx, Buffer buffer) throws Exception {
            if (HttpClientCodec.this.done) {
                int readable = this.actualReadableBytes();
                if (readable == 0) {
                    return;
                }
                ctx.fireChannelRead((Object)buffer.readSplit(readable));
            } else {
                super.decode(this.context, buffer);
            }
        }

        private void decrement(Object msg) {
            if (msg == null) {
                return;
            }
            if (msg instanceof LastHttpContent) {
                HttpClientCodec.this.requestResponseCounter.decrementAndGet();
            }
        }

        @Override
        protected boolean isContentAlwaysEmpty(HttpMessage msg) {
            HttpMethod method = HttpClientCodec.this.queue.poll();
            int statusCode = ((HttpResponse)msg).status().code();
            if (statusCode >= 100 && statusCode < 200) {
                return super.isContentAlwaysEmpty(msg);
            }
            if (method != null) {
                char firstChar = method.name().charAt(0);
                switch (firstChar) {
                    case 'H': {
                        if (!HttpMethod.HEAD.equals(method)) break;
                        return true;
                    }
                    case 'C': {
                        if (statusCode != 200 || !HttpMethod.CONNECT.equals(method)) break;
                        if (!HttpClientCodec.this.parseHttpAfterConnectRequest) {
                            HttpClientCodec.this.done = true;
                            HttpClientCodec.this.queue.clear();
                        }
                        return true;
                    }
                }
            }
            return super.isContentAlwaysEmpty(msg);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            long missingResponses;
            super.channelInactive(ctx);
            if (HttpClientCodec.this.failOnMissingResponse && (missingResponses = HttpClientCodec.this.requestResponseCounter.get()) > 0L) {
                ctx.fireChannelExceptionCaught((Throwable)new PrematureChannelClosureException("channel gone inactive with " + missingResponses + " missing response(s)"));
            }
        }
    }

    private final class Encoder
    extends HttpRequestEncoder {
        boolean upgraded;

        private Encoder() {
        }

        @Override
        protected void encodeAndClose(ChannelHandlerContext ctx, Object msg, List<Object> out) throws Exception {
            if (this.upgraded) {
                out.add(msg);
                return;
            }
            if (msg instanceof HttpRequest) {
                HttpClientCodec.this.queue.offer(((HttpRequest)msg).method());
            }
            super.encodeAndClose(ctx, msg, out);
            if (HttpClientCodec.this.failOnMissingResponse && !HttpClientCodec.this.done && msg instanceof LastHttpContent) {
                HttpClientCodec.this.requestResponseCounter.incrementAndGet();
            }
        }
    }
}

