/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer;

import io.netty5.buffer.BufferComponent;
import io.netty5.util.SafeCloseable;

public interface ComponentIterator<T extends Next & BufferComponent>
extends SafeCloseable {
    public T first();

    default public T firstReadable() {
        return ComponentIterator.nextReadable(this.first());
    }

    default public T firstWritable() {
        return ComponentIterator.nextWritable(this.first());
    }

    private static <T extends Next & BufferComponent> T nextReadable(T component) {
        while (component != null && ((BufferComponent)component).readableBytes() == 0) {
            component = component.next();
        }
        return component;
    }

    private static <T extends Next & BufferComponent> T nextWritable(T component) {
        while (component != null && ((BufferComponent)component).writableBytes() == 0) {
            component = component.next();
        }
        return component;
    }

    public static interface Next {
        public <N extends Next & BufferComponent> N next();

        default public <N extends Next & BufferComponent> N nextReadable() {
            return ComponentIterator.nextReadable(this.next());
        }

        default public <N extends Next & BufferComponent> N nextWritable() {
            return ComponentIterator.nextWritable(this.next());
        }
    }
}

