/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.newrelic;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.MissingRequiredConfigurationException;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.DoubleFormat;
import io.micrometer.core.lang.Nullable;
import io.micrometer.newrelic.NewRelicConfig;
import io.micrometer.newrelic.NewRelicNamingConvention;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewRelicMeterRegistry
extends StepMeterRegistry {
    private final NewRelicConfig config;
    private final Logger logger = LoggerFactory.getLogger(NewRelicMeterRegistry.class);

    public NewRelicMeterRegistry(NewRelicConfig config, Clock clock) {
        this(config, clock, Executors.defaultThreadFactory());
    }

    public NewRelicMeterRegistry(NewRelicConfig config, Clock clock, ThreadFactory threadFactory) {
        super((StepRegistryConfig)config, clock);
        if (config.accountId() == null) {
            throw new MissingRequiredConfigurationException("accountId must be set to report metrics to New Relic");
        }
        if (config.apiKey() == null) {
            throw new MissingRequiredConfigurationException("apiKey must be set to report metrics to New Relic");
        }
        this.config = config;
        this.config().namingConvention((NamingConvention)new NewRelicNamingConvention());
        this.start(threadFactory);
    }

    protected void publish() {
        try {
            URL insightsEndpoint = URI.create(this.config.uri() + "/v1/accounts/" + this.config.accountId() + "/events").toURL();
            int batchSize = Math.min(this.config.batchSize(), 1000);
            List<String> events = this.getMeters().stream().flatMap(meter -> {
                if (meter instanceof Timer) {
                    return this.writeTimer((Timer)meter);
                }
                if (meter instanceof FunctionTimer) {
                    return this.writeTimer((FunctionTimer)meter);
                }
                if (meter instanceof DistributionSummary) {
                    return this.writeSummary((DistributionSummary)meter);
                }
                if (meter instanceof TimeGauge) {
                    return this.writeGauge((TimeGauge)meter);
                }
                if (meter instanceof Gauge) {
                    return this.writeGauge((Gauge)meter);
                }
                if (meter instanceof Counter) {
                    return this.writeCounter((Counter)meter);
                }
                if (meter instanceof FunctionCounter) {
                    return this.writeCounter((FunctionCounter)meter);
                }
                if (meter instanceof LongTaskTimer) {
                    return this.writeLongTaskTimer((LongTaskTimer)meter);
                }
                return this.writeMeter((Meter)meter);
            }).collect(Collectors.toList());
            if (events.size() > batchSize) {
                this.sendEvents(insightsEndpoint, events.subList(0, batchSize));
                events = new ArrayList<String>(events.subList(batchSize, events.size()));
            } else if (events.size() == batchSize) {
                this.sendEvents(insightsEndpoint, events);
                events = new ArrayList<String>();
            }
            if (!events.isEmpty()) {
                this.sendEvents(insightsEndpoint, events);
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("malformed New Relic insights endpoint -- see the 'uri' configuration", e);
        }
        catch (Throwable t) {
            this.logger.warn("failed to send metrics", t);
        }
    }

    private Stream<String> writeLongTaskTimer(LongTaskTimer ltt) {
        return Stream.of(this.event(ltt.getId(), new Attribute("activeTasks", ltt.activeTasks()), new Attribute("duration", ltt.duration(this.getBaseTimeUnit()))));
    }

    Stream<String> writeCounter(FunctionCounter counter) {
        double count = counter.count();
        if (Double.isFinite(count)) {
            return Stream.of(this.event(counter.getId(), new Attribute("throughput", count)));
        }
        return Stream.empty();
    }

    private Stream<String> writeCounter(Counter counter) {
        return Stream.of(this.event(counter.getId(), new Attribute("throughput", counter.count())));
    }

    Stream<String> writeGauge(Gauge gauge) {
        Double value = gauge.value();
        if (Double.isFinite(value)) {
            return Stream.of(this.event(gauge.getId(), new Attribute("value", value)));
        }
        return Stream.empty();
    }

    Stream<String> writeGauge(TimeGauge gauge) {
        Double value = gauge.value(this.getBaseTimeUnit());
        if (Double.isFinite(value)) {
            return Stream.of(this.event(gauge.getId(), new Attribute("value", value)));
        }
        return Stream.empty();
    }

    private Stream<String> writeSummary(DistributionSummary summary) {
        return Stream.of(this.event(summary.getId(), new Attribute("count", summary.count()), new Attribute("avg", summary.mean()), new Attribute("total", summary.totalAmount()), new Attribute("max", summary.max())));
    }

    private Stream<String> writeTimer(Timer timer) {
        return Stream.of(this.event(timer.getId(), new Attribute("count", timer.count()), new Attribute("avg", timer.mean(this.getBaseTimeUnit())), new Attribute("totalTime", timer.totalTime(this.getBaseTimeUnit())), new Attribute("max", timer.max(this.getBaseTimeUnit()))));
    }

    private Stream<String> writeTimer(FunctionTimer timer) {
        return Stream.of(this.event(timer.getId(), new Attribute("count", timer.count()), new Attribute("avg", timer.mean(this.getBaseTimeUnit())), new Attribute("totalTime", timer.totalTime(this.getBaseTimeUnit()))));
    }

    private Stream<String> writeMeter(Meter meter) {
        return Stream.of(this.event(meter.getId(), (Attribute[])StreamSupport.stream(meter.measure().spliterator(), false).map(measure -> new Attribute(measure.getStatistic().getTagValueRepresentation(), measure.getValue())).toArray(Attribute[]::new)));
    }

    private String event(Meter.Id id, Attribute ... attributes) {
        return this.event(id, (Iterable<Tag>)Tags.empty(), attributes);
    }

    private String event(Meter.Id id, Iterable<Tag> extraTags, Attribute ... attributes) {
        StringBuilder tagsJson = new StringBuilder();
        for (Tag tag : this.getConventionTags(id)) {
            tagsJson.append(",\"").append(tag.getKey()).append("\":\"").append(tag.getValue()).append("\"");
        }
        NamingConvention convention = this.config().namingConvention();
        for (Tag tag : extraTags) {
            tagsJson.append(",\"").append(convention.tagKey(tag.getKey())).append("\":\"").append(convention.tagValue(tag.getValue())).append("\"");
        }
        return "{\"eventType\":\"" + this.getConventionName(id) + "\"" + Arrays.stream(attributes).map(attr -> ",\"" + attr.getName() + "\":" + DoubleFormat.decimalOrWhole((double)attr.getValue().doubleValue())).collect(Collectors.joining("")) + tagsJson.toString() + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEvents(URL insightsEndpoint, List<String> events) {
        block32: {
            HttpURLConnection con = null;
            try {
                con = (HttpURLConnection)insightsEndpoint.openConnection();
                con.setConnectTimeout((int)this.config.connectTimeout().toMillis());
                con.setReadTimeout((int)this.config.readTimeout().toMillis());
                con.setRequestMethod("POST");
                con.setRequestProperty("Content-Type", "application/json");
                con.setRequestProperty("X-Insert-Key", this.config.apiKey());
                con.setDoOutput(true);
                String body = "[" + events.stream().collect(Collectors.joining(",")) + "]";
                this.logger.trace("Sending payload to New Relic:");
                this.logger.trace(body);
                try (OutputStream os = con.getOutputStream();){
                    os.write(body.getBytes());
                    os.flush();
                }
                int status = con.getResponseCode();
                if (status >= 200 && status < 300) {
                    this.logger.info("successfully sent {} events to New Relic", (Object)events.size());
                    break block32;
                }
                if (status >= 400) {
                    try (InputStream in = con.getErrorStream();){
                        this.logger.error("failed to send metrics: " + new BufferedReader(new InputStreamReader(in)).lines().collect(Collectors.joining(System.lineSeparator())));
                        break block32;
                    }
                }
                this.logger.error("failed to send metrics: http " + status);
            }
            catch (Throwable e) {
                this.logger.warn("failed to send metrics", e);
            }
            finally {
                this.quietlyCloseUrlConnection(con);
            }
        }
    }

    private void quietlyCloseUrlConnection(@Nullable HttpURLConnection con) {
        try {
            if (con != null) {
                con.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.SECONDS;
    }

    private class Attribute {
        private final String name;
        private final Number value;

        private Attribute(String name, Number value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Number getValue() {
            return this.value;
        }
    }
}

