/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.protocol;

import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandType;
import io.lettuce.core.protocol.ProtocolKeyword;
import io.lettuce.core.protocol.RedisCommand;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public class ReadOnlyCommands {
    private static final Set<CommandType> READ_ONLY_COMMANDS = EnumSet.noneOf(CommandType.class);
    private static final ReadOnlyPredicate PREDICATE = command -> ReadOnlyCommands.isReadOnlyCommand(command.getType());

    public static boolean isReadOnlyCommand(ProtocolKeyword protocolKeyword) {
        return READ_ONLY_COMMANDS.contains(protocolKeyword);
    }

    public static Set<CommandType> getReadOnlyCommands() {
        return Collections.unmodifiableSet(READ_ONLY_COMMANDS);
    }

    public static ReadOnlyPredicate asPredicate() {
        return PREDICATE;
    }

    static {
        for (CommandName commandNames : CommandName.values()) {
            READ_ONLY_COMMANDS.add(CommandType.valueOf(commandNames.name()));
        }
    }

    @FunctionalInterface
    public static interface ReadOnlyPredicate {
        public boolean isReadOnly(RedisCommand<?, ?, ?> var1);

        default public ReadOnlyPredicate and(ReadOnlyPredicate other) {
            LettuceAssert.notNull((Object)other, "Other ReadOnlyPredicate must not be null");
            return t -> this.isReadOnly(t) && other.isReadOnly(t);
        }

        default public ReadOnlyPredicate negate() {
            return t -> !this.isReadOnly(t);
        }

        default public ReadOnlyPredicate or(ReadOnlyPredicate other) {
            LettuceAssert.notNull((Object)other, "Other ReadOnlyPredicate must not be null");
            return t -> this.isReadOnly(t) || other.isReadOnly(t);
        }
    }

    static enum CommandName {
        ASKING,
        BITCOUNT,
        BITPOS,
        CLIENT,
        COMMAND,
        DUMP,
        ECHO,
        EVAL_RO,
        EVALSHA_RO,
        EXISTS,
        FCALL_RO,
        GEODIST,
        GEOPOS,
        GEORADIUS,
        GEORADIUS_RO,
        GEORADIUSBYMEMBER,
        GEORADIUSBYMEMBER_RO,
        GEOSEARCH,
        GEOHASH,
        GET,
        GETBIT,
        GETRANGE,
        HEXISTS,
        HGET,
        HGETALL,
        HKEYS,
        HLEN,
        HMGET,
        HRANDFIELD,
        HSCAN,
        HSTRLEN,
        HVALS,
        INFO,
        KEYS,
        LINDEX,
        LLEN,
        LPOS,
        LRANGE,
        SORT_RO,
        MGET,
        PFCOUNT,
        PTTL,
        RANDOMKEY,
        READWRITE,
        SCAN,
        SCARD,
        SCRIPT,
        SDIFF,
        SINTER,
        SISMEMBER,
        SMISMEMBER,
        SMEMBERS,
        SRANDMEMBER,
        SSCAN,
        STRLEN,
        SUNION,
        TIME,
        TTL,
        TYPE,
        XINFO,
        XLEN,
        XPENDING,
        XRANGE,
        XREVRANGE,
        XREAD,
        ZCARD,
        ZCOUNT,
        ZLEXCOUNT,
        ZRANGE,
        ZRANDMEMBER,
        ZRANGEBYLEX,
        ZRANGEBYSCORE,
        ZRANK,
        ZREVRANGE,
        ZREVRANGEBYLEX,
        ZREVRANGEBYSCORE,
        ZREVRANK,
        ZSCAN,
        ZSCORE;

    }
}

