/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.ConnectionBuilder;
import io.lettuce.core.ConnectionEventTrigger;
import io.lettuce.core.ConnectionEvents;
import io.lettuce.core.LettuceStrings;
import io.lettuce.core.PlainChannelInitializer;
import io.lettuce.core.RedisChannelInitializer;
import io.lettuce.core.RedisChannelInitializerImpl;
import io.lettuce.core.RedisConnectionException;
import io.lettuce.core.RedisURI;
import io.lettuce.core.SslOptions;
import io.lettuce.core.event.connection.ConnectedEvent;
import io.lettuce.core.event.connection.ConnectionActivatedEvent;
import io.lettuce.core.event.connection.DisconnectedEvent;
import io.lettuce.core.internal.HostAndPort;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.AsyncCommand;
import io.lettuce.core.resource.ClientResources;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;

public class SslConnectionBuilder
extends ConnectionBuilder {
    private RedisURI redisURI;

    public SslConnectionBuilder ssl(RedisURI redisURI) {
        this.redisURI = redisURI;
        return this;
    }

    public static SslConnectionBuilder sslConnectionBuilder() {
        return new SslConnectionBuilder();
    }

    @Override
    protected List<ChannelHandler> buildHandlers() {
        LettuceAssert.assertState(this.redisURI != null, "RedisURI must not be null");
        LettuceAssert.assertState(this.redisURI.isSsl(), "RedisURI is not configured for SSL (ssl is false)");
        return super.buildHandlers();
    }

    @Override
    @Deprecated
    public RedisChannelInitializer build() {
        return new SslChannelInitializer(this.getPingCommandSupplier(), this::buildHandlers, SslConnectionBuilder.toHostAndPort(this.redisURI), this.redisURI.isVerifyPeer(), this.redisURI.isStartTls(), this.clientResources(), this.getTimeout(), this.clientOptions().getSslOptions());
    }

    @Override
    public RedisChannelInitializer build(SocketAddress socketAddress) {
        return new SslChannelInitializer(this.getPingCommandSupplier(), this::buildHandlers, SslConnectionBuilder.toHostAndPort(socketAddress), this.redisURI.isVerifyPeer(), this.redisURI.isStartTls(), this.clientResources(), this.getTimeout(), this.clientOptions().getSslOptions());
    }

    static HostAndPort toHostAndPort(RedisURI redisURI) {
        if (LettuceStrings.isNotEmpty(redisURI.getHost())) {
            return HostAndPort.of(redisURI.getHost(), redisURI.getPort());
        }
        return null;
    }

    static HostAndPort toHostAndPort(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress isa = (InetSocketAddress)socketAddress;
            return HostAndPort.of(isa.getHostString(), isa.getPort());
        }
        return null;
    }

    static class SslChannelInitializer
    extends ChannelInitializer<Channel>
    implements RedisChannelInitializer {
        private final Supplier<AsyncCommand<?, ?, ?>> pingCommandSupplier;
        private final Supplier<List<ChannelHandler>> handlers;
        private final HostAndPort hostAndPort;
        private final boolean verifyPeer;
        private final boolean startTls;
        private final ClientResources clientResources;
        private final Duration timeout;
        private final SslOptions sslOptions;
        private volatile CompletableFuture<Boolean> initializedFuture = new CompletableFuture();

        public SslChannelInitializer(Supplier<AsyncCommand<?, ?, ?>> pingCommandSupplier, Supplier<List<ChannelHandler>> handlers, HostAndPort hostAndPort, boolean verifyPeer, boolean startTls, ClientResources clientResources, Duration timeout, SslOptions sslOptions) {
            this.pingCommandSupplier = pingCommandSupplier;
            this.handlers = handlers;
            this.hostAndPort = hostAndPort;
            this.verifyPeer = verifyPeer;
            this.startTls = startTls;
            this.clientResources = clientResources;
            this.timeout = timeout;
            this.sslOptions = sslOptions;
        }

        protected void initChannel(Channel channel) throws Exception {
            this.doInitialize(channel);
        }

        private void doInitialize(Channel channel) throws IOException, GeneralSecurityException {
            SSLEngine sslEngine = this.initializeSSLEngine(channel.alloc());
            if (channel.pipeline().get("first") == null) {
                channel.pipeline().addFirst("first", (ChannelHandler)new ChannelDuplexHandler(){

                    public void channelActive(ChannelHandlerContext ctx) throws Exception {
                        clientResources.eventBus().publish(new ConnectedEvent(ConnectionEventTrigger.local(ctx), ConnectionEventTrigger.remote(ctx)));
                        super.channelActive(ctx);
                    }

                    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                        clientResources.eventBus().publish(new DisconnectedEvent(ConnectionEventTrigger.local(ctx), ConnectionEventTrigger.remote(ctx)));
                        super.channelInactive(ctx);
                    }
                });
            }
            SslHandler sslHandler = new SslHandler(sslEngine, this.startTls);
            Duration sslHandshakeTimeout = this.sslOptions.getHandshakeTimeout();
            sslHandler.setHandshakeTimeoutMillis(sslHandshakeTimeout.toMillis());
            channel.pipeline().addLast(new ChannelHandler[]{sslHandler});
            if (channel.pipeline().get("channelActivator") == null) {
                channel.pipeline().addLast("channelActivator", (ChannelHandler)new RedisChannelInitializerImpl(){
                    private AsyncCommand<?, ?, ?> pingCommand;

                    @Override
                    public CompletableFuture<Boolean> channelInitialized() {
                        return initializedFuture;
                    }

                    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                        if (!initializedFuture.isDone()) {
                            initializedFuture.completeExceptionally(new RedisConnectionException("Connection closed prematurely"));
                        }
                        initializedFuture = new CompletableFuture();
                        this.pingCommand = null;
                        super.channelInactive(ctx);
                    }

                    public void channelActive(ChannelHandlerContext ctx) throws Exception {
                        if (initializedFuture.isDone()) {
                            super.channelActive(ctx);
                        }
                    }

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        if (evt instanceof SslHandshakeCompletionEvent && !initializedFuture.isDone()) {
                            SslHandshakeCompletionEvent event = (SslHandshakeCompletionEvent)evt;
                            if (event.isSuccess()) {
                                if (pingCommandSupplier != PlainChannelInitializer.NO_PING) {
                                    this.pingCommand = (AsyncCommand)pingCommandSupplier.get();
                                    PlainChannelInitializer.pingBeforeActivate(this.pingCommand, initializedFuture, ctx, clientResources, timeout);
                                } else {
                                    ctx.fireChannelActive();
                                }
                            } else {
                                initializedFuture.completeExceptionally(event.cause());
                            }
                        }
                        if (evt instanceof ConnectionEvents.Activated && !initializedFuture.isDone()) {
                            initializedFuture.complete(true);
                            clientResources.eventBus().publish(new ConnectionActivatedEvent(ConnectionEventTrigger.local(ctx), ConnectionEventTrigger.remote(ctx)));
                        }
                        super.userEventTriggered(ctx, evt);
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        if (cause instanceof SSLHandshakeException || cause.getCause() instanceof SSLException) {
                            initializedFuture.completeExceptionally(cause);
                        }
                        super.exceptionCaught(ctx, cause);
                    }
                });
            }
            for (ChannelHandler handler : this.handlers.get()) {
                channel.pipeline().addLast(new ChannelHandler[]{handler});
            }
            this.clientResources.nettyCustomizer().afterChannelInitialized(channel);
        }

        private SSLEngine initializeSSLEngine(ByteBufAllocator alloc) throws IOException, GeneralSecurityException {
            SSLParameters sslParams = this.sslOptions.createSSLParameters();
            SslContextBuilder sslContextBuilder = this.sslOptions.createSslContextBuilder();
            if (this.verifyPeer) {
                sslParams.setEndpointIdentificationAlgorithm("HTTPS");
            } else {
                sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            }
            SslContext sslContext = sslContextBuilder.build();
            SSLEngine sslEngine = this.hostAndPort != null ? sslContext.newEngine(alloc, this.hostAndPort.getHostText(), this.hostAndPort.getPort()) : sslContext.newEngine(alloc);
            sslEngine.setSSLParameters(sslParams);
            return sslEngine;
        }

        @Override
        public CompletableFuture<Boolean> channelInitialized() {
            return this.initializedFuture;
        }
    }
}

