/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.models.role;

import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.models.role.RedisInstance;
import io.lettuce.core.models.role.ReplicationPartner;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class RedisMasterInstance
implements RedisInstance,
Serializable {
    private long replicationOffset;
    private List<ReplicationPartner> slaves = Collections.emptyList();

    public RedisMasterInstance() {
    }

    public RedisMasterInstance(long replicationOffset, List<ReplicationPartner> slaves) {
        LettuceAssert.notNull(slaves, "Slaves must not be null");
        this.replicationOffset = replicationOffset;
        this.slaves = slaves;
    }

    @Override
    public RedisInstance.Role getRole() {
        return RedisInstance.Role.MASTER;
    }

    public long getReplicationOffset() {
        return this.replicationOffset;
    }

    public List<ReplicationPartner> getSlaves() {
        return this.slaves;
    }

    public void setReplicationOffset(long replicationOffset) {
        this.replicationOffset = replicationOffset;
    }

    public void setSlaves(List<ReplicationPartner> slaves) {
        LettuceAssert.notNull(slaves, "Slaves must not be null");
        this.slaves = slaves;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [replicationOffset=").append(this.replicationOffset);
        sb.append(", slaves=").append(this.slaves);
        sb.append(']');
        return sb.toString();
    }
}

