/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster;

import io.lettuce.core.ConnectionFuture;
import io.lettuce.core.RedisConnectionException;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.cluster.ClusterNodeConnectionFactory;
import io.lettuce.core.internal.LettuceAssert;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

class SynchronizingClusterConnectionProvider<K, V> {
    private final ClusterNodeConnectionFactory<K, V> connectionFactory;
    private final Map<ClusterNodeConnectionFactory.ConnectionKey, Sync<K, V>> connections = new ConcurrentHashMap<ClusterNodeConnectionFactory.ConnectionKey, Sync<K, V>>();
    private volatile boolean closed;

    public SynchronizingClusterConnectionProvider(ClusterNodeConnectionFactory<K, V> connectionFactory) {
        LettuceAssert.notNull(connectionFactory, "AsyncClusterConnectionFactory must not be null");
        this.connectionFactory = connectionFactory;
    }

    public StatefulRedisConnection<K, V> getConnection(ClusterNodeConnectionFactory.ConnectionKey key) {
        return this.getConnectionSync(key).getConnection();
    }

    public ConnectionFuture<StatefulRedisConnection<K, V>> getConnectionAsync(ClusterNodeConnectionFactory.ConnectionKey key) {
        return this.getConnectionSync(key).getConnectionAsync();
    }

    private Sync<K, V> getConnectionSync(ClusterNodeConnectionFactory.ConnectionKey key) {
        if (this.closed) {
            throw new IllegalStateException("AsyncClusterConnectionProvider is already closed");
        }
        Sync sync = this.connections.computeIfAbsent(key, connectionKey -> {
            InProgress<K, V> createdSync = new InProgress<K, V>(key, (ConnectionFuture)this.connectionFactory.apply(key), this.connections);
            if (this.closed) {
                ((InProgress)createdSync).remove = 1;
                ((InProgress)createdSync).future.thenAcceptAsync(StatefulConnection::close);
            }
            return createdSync;
        });
        return sync;
    }

    public int getConnectionCount() {
        Object[] syncs = this.connections.values().toArray(new Object[0]);
        int count = 0;
        for (Object sync : syncs) {
            if (!(sync instanceof Finished)) continue;
            ++count;
        }
        return count;
    }

    public void close() {
        this.closed = true;
        this.forEach((ClusterNodeConnectionFactory.ConnectionKey connectionKey, ? super StatefulRedisConnection<K, V> connection) -> {
            connection.close();
            this.connections.remove(connectionKey);
        });
    }

    public void close(ClusterNodeConnectionFactory.ConnectionKey key) {
        LettuceAssert.notNull(key, "ConnectionKey must not be null!");
        Sync<K, V> sync = this.connections.get(key);
        if (sync != null) {
            this.connections.remove(key);
            sync.doWithSync(StatefulConnection::close);
        }
    }

    public void forEach(Consumer<? super StatefulRedisConnection<K, V>> action) {
        this.connections.values().forEach((? super T sync) -> sync.doWithSync(action));
    }

    public void forEach(BiConsumer<ClusterNodeConnectionFactory.ConnectionKey, ? super StatefulRedisConnection<K, V>> action) {
        this.connections.forEach((? super K key, ? super V sync) -> sync.doWithSync(action));
    }

    static class InProgress<K, V>
    implements Sync<K, V> {
        private static final int ST_IN_PROGRESS = 0;
        private static final int ST_FINISHED = 1;
        private static final AtomicIntegerFieldUpdater<InProgress> REMOVE = AtomicIntegerFieldUpdater.newUpdater(InProgress.class, "remove");
        private volatile int remove = 0;
        private final ClusterNodeConnectionFactory.ConnectionKey key;
        private final ConnectionFuture<StatefulRedisConnection<K, V>> future;
        private final Map<ClusterNodeConnectionFactory.ConnectionKey, Sync<K, V>> connections;

        public InProgress(ClusterNodeConnectionFactory.ConnectionKey key, ConnectionFuture<StatefulRedisConnection<K, V>> future, Map<ClusterNodeConnectionFactory.ConnectionKey, Sync<K, V>> connections) {
            this.key = key;
            this.future = future;
            this.connections = connections;
        }

        @Override
        public ConnectionFuture<StatefulRedisConnection<K, V>> getConnectionAsync() {
            return this.future.whenComplete((connection, throwable) -> {
                if (REMOVE.compareAndSet(this, 0, 1)) {
                    if (throwable == null) {
                        this.connections.replace(this.key, this, new Finished(this.key, this.future.getRemoteAddress(), connection));
                    } else {
                        this.connections.remove(this.key);
                    }
                }
            });
        }

        @Override
        public StatefulRedisConnection<K, V> getConnection() {
            try {
                return (StatefulRedisConnection)this.getConnectionAsync().toCompletableFuture().join();
            }
            catch (CompletionException e) {
                throw RedisConnectionException.create(this.future.getRemoteAddress(), e.getCause());
            }
        }

        @Override
        public void doWithSync(Consumer<? super StatefulRedisConnection<K, V>> action) {
            this.future.thenAccept(action);
        }

        @Override
        public void doWithSync(BiConsumer<ClusterNodeConnectionFactory.ConnectionKey, ? super StatefulRedisConnection<K, V>> action) {
            this.future.thenAccept(connection -> action.accept(this.key, (StatefulRedisConnection<K, V>)connection));
        }
    }

    static class Finished<K, V>
    implements Sync<K, V> {
        private final ClusterNodeConnectionFactory.ConnectionKey key;
        private final StatefulRedisConnection<K, V> connection;
        private final ConnectionFuture<StatefulRedisConnection<K, V>> future;

        public Finished(ClusterNodeConnectionFactory.ConnectionKey key, SocketAddress remoteAddress, StatefulRedisConnection<K, V> connection) {
            this.key = key;
            this.connection = connection;
            this.future = ConnectionFuture.from(remoteAddress, CompletableFuture.completedFuture(connection));
        }

        @Override
        public StatefulRedisConnection<K, V> getConnection() {
            return this.connection;
        }

        @Override
        public ConnectionFuture<StatefulRedisConnection<K, V>> getConnectionAsync() {
            return this.future;
        }

        @Override
        public void doWithSync(Consumer<? super StatefulRedisConnection<K, V>> action) {
            action.accept(this.connection);
        }

        @Override
        public void doWithSync(BiConsumer<ClusterNodeConnectionFactory.ConnectionKey, ? super StatefulRedisConnection<K, V>> action) {
            action.accept(this.key, this.connection);
        }
    }

    static interface Sync<K, V> {
        public StatefulRedisConnection<K, V> getConnection();

        public ConnectionFuture<StatefulRedisConnection<K, V>> getConnectionAsync();

        public void doWithSync(Consumer<? super StatefulRedisConnection<K, V>> var1);

        public void doWithSync(BiConsumer<ClusterNodeConnectionFactory.ConnectionKey, ? super StatefulRedisConnection<K, V>> var1);
    }
}

