/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.grpc.ChannelCredentials;
import io.grpc.InternalLogId;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.JsonParser;
import io.grpc.internal.JsonUtil;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.Locality;
import io.grpc.xds.XdsCredentialsProvider;
import io.grpc.xds.XdsCredentialsRegistry;
import io.grpc.xds.XdsInitializationException;
import io.grpc.xds.XdsLogger;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

class BootstrapperImpl
extends Bootstrapper {
    private static final String BOOTSTRAP_PATH_SYS_ENV_VAR = "GRPC_XDS_BOOTSTRAP";
    @VisibleForTesting
    static String bootstrapPathFromEnvVar = System.getenv("GRPC_XDS_BOOTSTRAP");
    private static final String BOOTSTRAP_PATH_SYS_PROPERTY = "io.grpc.xds.bootstrap";
    @VisibleForTesting
    static String bootstrapPathFromSysProp = System.getProperty("io.grpc.xds.bootstrap");
    private static final String BOOTSTRAP_CONFIG_SYS_ENV_VAR = "GRPC_XDS_BOOTSTRAP_CONFIG";
    @VisibleForTesting
    static String bootstrapConfigFromEnvVar = System.getenv("GRPC_XDS_BOOTSTRAP_CONFIG");
    private static final String BOOTSTRAP_CONFIG_SYS_PROPERTY = "io.grpc.xds.bootstrapConfig";
    @VisibleForTesting
    static String bootstrapConfigFromSysProp = System.getProperty("io.grpc.xds.bootstrapConfig");
    static boolean enableFederation = !Strings.isNullOrEmpty((String)System.getenv("GRPC_EXPERIMENTAL_XDS_FEDERATION")) && Boolean.parseBoolean(System.getenv("GRPC_EXPERIMENTAL_XDS_FEDERATION"));
    @VisibleForTesting
    static final String CLIENT_FEATURE_DISABLE_OVERPROVISIONING = "envoy.lb.does_not_support_overprovisioning";
    @VisibleForTesting
    static final String CLIENT_FEATURE_RESOURCE_IN_SOTW = "xds.config.resource-in-sotw";
    private static final String SERVER_FEATURE_XDS_V3 = "xds_v3";
    private static final String SERVER_FEATURE_IGNORE_RESOURCE_DELETION = "ignore_resource_deletion";
    private final XdsLogger logger;
    private FileReader reader = LocalFileReader.INSTANCE;

    public BootstrapperImpl() {
        this.logger = XdsLogger.withLogId(InternalLogId.allocate((String)"bootstrapper", null));
    }

    @Override
    public Bootstrapper.BootstrapInfo bootstrap() throws XdsInitializationException {
        Map rawBootstrap;
        String fileContent;
        String filePath;
        String string = filePath = bootstrapPathFromEnvVar != null ? bootstrapPathFromEnvVar : bootstrapPathFromSysProp;
        if (filePath != null) {
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Reading bootstrap file from {0}", filePath);
            try {
                fileContent = this.reader.readFile(filePath);
            }
            catch (IOException e) {
                throw new XdsInitializationException("Fail to read bootstrap file", e);
            }
        } else {
            String string2 = fileContent = bootstrapConfigFromEnvVar != null ? bootstrapConfigFromEnvVar : bootstrapConfigFromSysProp;
        }
        if (fileContent == null) {
            throw new XdsInitializationException("Cannot find bootstrap configuration\nEnvironment variables searched:\n- GRPC_XDS_BOOTSTRAP\n- GRPC_XDS_BOOTSTRAP_CONFIG\n\nJava System Properties searched:\n- io.grpc.xds.bootstrap\n- io.grpc.xds.bootstrapConfig\n\n");
        }
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Reading bootstrap from " + filePath);
        try {
            rawBootstrap = (Map)JsonParser.parse((String)fileContent);
        }
        catch (IOException e) {
            throw new XdsInitializationException("Failed to parse JSON", e);
        }
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Bootstrap configuration:\n{0}", rawBootstrap);
        return this.bootstrap(rawBootstrap);
    }

    @Override
    Bootstrapper.BootstrapInfo bootstrap(Map<String, ?> rawData) throws XdsInitializationException {
        Bootstrapper.BootstrapInfo.Builder builder = Bootstrapper.BootstrapInfo.builder();
        List rawServerConfigs = JsonUtil.getList(rawData, (String)"xds_servers");
        if (rawServerConfigs == null) {
            throw new XdsInitializationException("Invalid bootstrap: 'xds_servers' does not exist.");
        }
        List<Bootstrapper.ServerInfo> servers = BootstrapperImpl.parseServerInfos(rawServerConfigs, this.logger);
        builder.servers(servers);
        EnvoyProtoData.Node.Builder nodeBuilder = EnvoyProtoData.Node.newBuilder();
        Map rawNode = JsonUtil.getObject(rawData, (String)"node");
        if (rawNode != null) {
            Object rawLocality;
            Map metadata;
            String cluster;
            String id = JsonUtil.getString((Map)rawNode, (String)"id");
            if (id != null) {
                this.logger.log(XdsLogger.XdsLogLevel.INFO, "Node id: {0}", id);
                nodeBuilder.setId(id);
            }
            if ((cluster = JsonUtil.getString((Map)rawNode, (String)"cluster")) != null) {
                this.logger.log(XdsLogger.XdsLogLevel.INFO, "Node cluster: {0}", cluster);
                nodeBuilder.setCluster(cluster);
            }
            if ((metadata = JsonUtil.getObject((Map)rawNode, (String)"metadata")) != null) {
                nodeBuilder.setMetadata(metadata);
            }
            if ((rawLocality = JsonUtil.getObject((Map)rawNode, (String)"locality")) != null) {
                String region = "";
                String zone = "";
                String subZone = "";
                if (rawLocality.containsKey("region")) {
                    region = JsonUtil.getString((Map)rawLocality, (String)"region");
                }
                if (rawLocality.containsKey("zone")) {
                    zone = JsonUtil.getString((Map)rawLocality, (String)"zone");
                }
                if (rawLocality.containsKey("sub_zone")) {
                    subZone = JsonUtil.getString((Map)rawLocality, (String)"sub_zone");
                }
                this.logger.log(XdsLogger.XdsLogLevel.INFO, "Locality region: {0}, zone: {0}, subZone: {0}", region, zone, subZone);
                Locality locality = Locality.create(region, zone, subZone);
                nodeBuilder.setLocality(locality);
            }
        }
        GrpcUtil.GrpcBuildVersion buildVersion = GrpcUtil.getGrpcBuildVersion();
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Build version: {0}", buildVersion);
        nodeBuilder.setBuildVersion(buildVersion.toString());
        nodeBuilder.setUserAgentName(buildVersion.getUserAgent());
        nodeBuilder.setUserAgentVersion(buildVersion.getImplementationVersion());
        nodeBuilder.addClientFeatures(CLIENT_FEATURE_DISABLE_OVERPROVISIONING);
        nodeBuilder.addClientFeatures(CLIENT_FEATURE_RESOURCE_IN_SOTW);
        builder.node(nodeBuilder.build());
        Map certProvidersBlob = JsonUtil.getObject(rawData, (String)"certificate_providers");
        if (certProvidersBlob != null) {
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Configured with {0} cert providers", certProvidersBlob.size());
            HashMap<String, Bootstrapper.CertificateProviderInfo> certProviders = new HashMap<String, Bootstrapper.CertificateProviderInfo>(certProvidersBlob.size());
            for (String name : certProvidersBlob.keySet()) {
                Map valueMap = JsonUtil.getObject((Map)certProvidersBlob, (String)name);
                String pluginName = BootstrapperImpl.checkForNull(JsonUtil.getString((Map)valueMap, (String)"plugin_name"), "plugin_name");
                this.logger.log(XdsLogger.XdsLogLevel.INFO, "cert provider: {0}, plugin name: {1}", name, pluginName);
                Map config = BootstrapperImpl.checkForNull(JsonUtil.getObject((Map)valueMap, (String)"config"), "config");
                Bootstrapper.CertificateProviderInfo certificateProviderInfo = Bootstrapper.CertificateProviderInfo.create(pluginName, config);
                certProviders.put(name, certificateProviderInfo);
            }
            builder.certProviders(certProviders);
        }
        String grpcServerResourceId = JsonUtil.getString(rawData, (String)"server_listener_resource_name_template");
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "server_listener_resource_name_template: {0}", grpcServerResourceId);
        builder.serverListenerResourceNameTemplate(grpcServerResourceId);
        if (!enableFederation) {
            return builder.build();
        }
        String grpcClientDefaultListener = JsonUtil.getString(rawData, (String)"client_default_listener_resource_name_template");
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "client_default_listener_resource_name_template: {0}", grpcClientDefaultListener);
        if (grpcClientDefaultListener != null) {
            builder.clientDefaultListenerResourceNameTemplate(grpcClientDefaultListener);
        }
        Map rawAuthoritiesMap = JsonUtil.getObject(rawData, (String)"authorities");
        ImmutableMap.Builder authorityInfoMapBuilder = ImmutableMap.builder();
        if (rawAuthoritiesMap != null) {
            this.logger.log(XdsLogger.XdsLogLevel.INFO, "Configured with {0} xDS server authorities", rawAuthoritiesMap.size());
            for (String authorityName : rawAuthoritiesMap.keySet()) {
                this.logger.log(XdsLogger.XdsLogLevel.INFO, "xDS server authority: {0}", authorityName);
                Map rawAuthority = JsonUtil.getObject((Map)rawAuthoritiesMap, (String)authorityName);
                String clientListnerTemplate = JsonUtil.getString((Map)rawAuthority, (String)"client_listener_resource_name_template");
                this.logger.log(XdsLogger.XdsLogLevel.INFO, "client_listener_resource_name_template: {0}", clientListnerTemplate);
                String prefix = "xdstp://" + authorityName + "/";
                if (clientListnerTemplate == null) {
                    clientListnerTemplate = prefix + "envoy.config.listener.v3.Listener/%s";
                } else if (!clientListnerTemplate.startsWith(prefix)) {
                    throw new XdsInitializationException("client_listener_resource_name_template: '" + clientListnerTemplate + "' does not start with " + prefix);
                }
                List rawAuthorityServers = JsonUtil.getList((Map)rawAuthority, (String)"xds_servers");
                List<Bootstrapper.ServerInfo> authorityServers = rawAuthorityServers == null || rawAuthorityServers.isEmpty() ? servers : BootstrapperImpl.parseServerInfos(rawAuthorityServers, this.logger);
                authorityInfoMapBuilder.put((Object)authorityName, (Object)Bootstrapper.AuthorityInfo.create(clientListnerTemplate, authorityServers));
            }
            builder.authorities((Map<String, Bootstrapper.AuthorityInfo>)authorityInfoMapBuilder.buildOrThrow());
        }
        return builder.build();
    }

    private static List<Bootstrapper.ServerInfo> parseServerInfos(List<?> rawServerConfigs, XdsLogger logger) throws XdsInitializationException {
        logger.log(XdsLogger.XdsLogLevel.INFO, "Configured with {0} xDS servers", rawServerConfigs.size());
        ImmutableList.Builder servers = ImmutableList.builder();
        List serverConfigList = JsonUtil.checkObjectList(rawServerConfigs);
        for (Map serverConfig : serverConfigList) {
            String serverUri = JsonUtil.getString((Map)serverConfig, (String)"server_uri");
            if (serverUri == null) {
                throw new XdsInitializationException("Invalid bootstrap: missing 'server_uri'");
            }
            logger.log(XdsLogger.XdsLogLevel.INFO, "xDS server URI: {0}", serverUri);
            List rawChannelCredsList = JsonUtil.getList((Map)serverConfig, (String)"channel_creds");
            if (rawChannelCredsList == null || rawChannelCredsList.isEmpty()) {
                throw new XdsInitializationException("Invalid bootstrap: server " + serverUri + " 'channel_creds' required");
            }
            ChannelCredentials channelCredentials = BootstrapperImpl.parseChannelCredentials(JsonUtil.checkObjectList((List)rawChannelCredsList), serverUri);
            if (channelCredentials == null) {
                throw new XdsInitializationException("Server " + serverUri + ": no supported channel credentials found");
            }
            boolean useProtocolV3 = false;
            boolean ignoreResourceDeletion = false;
            List serverFeatures = JsonUtil.getListOfStrings((Map)serverConfig, (String)"server_features");
            if (serverFeatures != null) {
                logger.log(XdsLogger.XdsLogLevel.INFO, "Server features: {0}", serverFeatures);
                useProtocolV3 = serverFeatures.contains(SERVER_FEATURE_XDS_V3);
                ignoreResourceDeletion = serverFeatures.contains(SERVER_FEATURE_IGNORE_RESOURCE_DELETION);
            }
            servers.add((Object)Bootstrapper.ServerInfo.create(serverUri, channelCredentials, useProtocolV3, ignoreResourceDeletion));
        }
        return servers.build();
    }

    @VisibleForTesting
    void setFileReader(FileReader reader) {
        this.reader = reader;
    }

    private static <T> T checkForNull(T value, String fieldName) throws XdsInitializationException {
        if (value == null) {
            throw new XdsInitializationException("Invalid bootstrap: '" + fieldName + "' does not exist.");
        }
        return value;
    }

    @Nullable
    private static ChannelCredentials parseChannelCredentials(List<Map<String, ?>> jsonList, String serverUri) throws XdsInitializationException {
        for (Map<String, ?> channelCreds : jsonList) {
            String type = JsonUtil.getString(channelCreds, (String)"type");
            if (type == null) {
                throw new XdsInitializationException("Invalid bootstrap: server " + serverUri + " with 'channel_creds' type unspecified");
            }
            XdsCredentialsProvider provider = XdsCredentialsRegistry.getDefaultRegistry().getProvider(type);
            if (provider == null) continue;
            Map config = JsonUtil.getObject(channelCreds, (String)"config");
            if (config == null) {
                config = ImmutableMap.of();
            }
            return provider.newChannelCredentials(config);
        }
        return null;
    }

    private static enum LocalFileReader implements FileReader
    {
        INSTANCE;


        @Override
        public String readFile(String path) throws IOException {
            return new String(Files.readAllBytes(Paths.get(path, new String[0])), StandardCharsets.UTF_8);
        }
    }

    static interface FileReader {
        public String readFile(String var1) throws IOException;
    }
}

