/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import io.grpc.CallCredentials;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.DataSource;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.GrpcService;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.GrpcService;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

final class FileBasedPluginCredential
extends CallCredentials {
    public static final String PLUGIN_NAME = "envoy.grpc_credentials.file_based_metadata";
    public static final String HEADER_KEY = "header_key";
    public static final String HEADER_PREFIX = "header_prefix";
    public static final String SECRET_DATA = "secret_data";
    public static final String FILENAME = "filename";
    public static final String DEFAULT_HEADER_KEY = "authorization";
    @VisibleForTesting
    final String headerKey;
    @VisibleForTesting
    final String headerPrefix;
    @VisibleForTesting
    final DataSource secretData;

    FileBasedPluginCredential(GrpcService.GoogleGrpc.CallCredentials.MetadataCredentialsFromPlugin metadataCredentialsFromPlugin) {
        Value value;
        Preconditions.checkNotNull((Object)metadataCredentialsFromPlugin, (Object)"metadataCredentialsFromPlugin");
        Preconditions.checkArgument((boolean)PLUGIN_NAME.equals(metadataCredentialsFromPlugin.getName()), (String)"plugin name should be %s", (Object)PLUGIN_NAME);
        Preconditions.checkArgument((boolean)metadataCredentialsFromPlugin.hasConfig(), (Object)"typed_config not supported");
        Struct configStruct = metadataCredentialsFromPlugin.getConfig();
        if (configStruct.containsFields(HEADER_KEY)) {
            value = configStruct.getFieldsOrThrow(HEADER_KEY);
            this.headerKey = value.getStringValue();
        } else {
            this.headerKey = DEFAULT_HEADER_KEY;
        }
        if (configStruct.containsFields(HEADER_PREFIX)) {
            value = configStruct.getFieldsOrThrow(HEADER_PREFIX);
            this.headerPrefix = value.getStringValue();
        } else {
            this.headerPrefix = "";
        }
        value = configStruct.getFieldsOrThrow(SECRET_DATA);
        Preconditions.checkState((boolean)value.hasStructValue(), (String)"expected struct value for %s", (Object)SECRET_DATA);
        this.secretData = FileBasedPluginCredential.buildDataSourceFromConfigStruct(value.getStructValue());
    }

    FileBasedPluginCredential(GrpcService.GoogleGrpc.CallCredentials.MetadataCredentialsFromPlugin metadataCredentialsFromPlugin) {
        Preconditions.checkNotNull((Object)metadataCredentialsFromPlugin, (Object)"metadataCredentialsFromPlugin");
        Preconditions.checkArgument((boolean)PLUGIN_NAME.equals(metadataCredentialsFromPlugin.getName()), (String)"plugin name should be %s", (Object)PLUGIN_NAME);
        this.headerKey = DEFAULT_HEADER_KEY;
        this.headerPrefix = "";
        this.secretData = null;
    }

    private static DataSource buildDataSourceFromConfigStruct(Struct secretValueStruct) {
        Preconditions.checkNotNull((Object)secretValueStruct, (Object)"secretValueStruct");
        if (secretValueStruct.containsFields(FILENAME)) {
            Value value = secretValueStruct.getFieldsOrThrow(FILENAME);
            return DataSource.newBuilder().setFilename(value.getStringValue()).build();
        }
        throw new UnsupportedOperationException("only secret_data of filename type supported");
    }

    public void applyRequestMetadata(@Nullable CallCredentials.RequestInfo requestInfo, Executor appExecutor, final CallCredentials.MetadataApplier applier) {
        appExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Metadata headers = new Metadata();
                    String headerValue = FileBasedPluginCredential.this.headerPrefix + Files.asCharSource((File)new File(FileBasedPluginCredential.this.secretData.getFilename()), (Charset)StandardCharsets.UTF_8).read();
                    if (FileBasedPluginCredential.this.headerKey.endsWith("-bin")) {
                        Metadata.Key metadataHeaderKey = Metadata.Key.of((String)FileBasedPluginCredential.this.headerKey, (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER);
                        headers.put(metadataHeaderKey, (Object)headerValue.getBytes(StandardCharsets.UTF_8));
                    } else {
                        Metadata.Key metadataHeaderKey = Metadata.Key.of((String)FileBasedPluginCredential.this.headerKey, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
                        headers.put(metadataHeaderKey, (Object)headerValue);
                    }
                    applier.apply(headers);
                }
                catch (IOException e) {
                    applier.fail(Status.fromThrowable((Throwable)e));
                }
            }
        });
    }

    public void thisUsesUnstableApi() {
    }
}

