/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.web.session;

import com.logviewer.data2.LogCrashedException;
import com.logviewer.data2.LogRecord;
import com.logviewer.data2.LvPredicateChecker;
import com.logviewer.data2.Position;
import com.logviewer.data2.RecordList;
import com.logviewer.data2.Snapshot;
import com.logviewer.filters.RecordPredicate;
import com.logviewer.utils.Pair;
import com.logviewer.utils.PredicateUtils;
import com.logviewer.web.session.LogProcess;
import com.logviewer.web.session.SearchResult;
import com.logviewer.web.session.Status;
import com.logviewer.web.session.tasks.SearchPattern;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileRecordSearcher
implements LogProcess {
    private static final Logger LOG = LoggerFactory.getLogger(LocalFileRecordSearcher.class);
    private final Supplier<Snapshot> snapshotFactory;
    private final ExecutorService executor;
    private final Position start;
    private final boolean backward;
    private final RecordPredicate filter;
    private final Long timeLimitFomFilter;
    private final SearchPattern pattern;
    private final String hash;
    private final int recordCount;
    private final Consumer<SearchResult> listener;
    private int state = 0;
    private volatile long timeLimit = 0L;
    private volatile Future<?> future;

    public LocalFileRecordSearcher(Supplier<Snapshot> snapshotFactory, ExecutorService executor, Position start, boolean backward, RecordPredicate filter, String hash, int recordCount, SearchPattern pattern, Consumer<SearchResult> listener) {
        this.snapshotFactory = snapshotFactory;
        this.executor = executor;
        this.start = start;
        this.backward = backward;
        this.filter = filter;
        this.pattern = pattern;
        this.hash = hash;
        this.recordCount = recordCount;
        this.listener = listener;
        assert (recordCount > 0);
        this.timeLimitFomFilter = PredicateUtils.extractTimeLimit(filter, !backward);
    }

    @Override
    public synchronized void start() {
        if (this.state != 0) {
            throw new IllegalStateException("Loader already started");
        }
        assert (this.future == null);
        this.future = this.executor.submit(() -> {
            try (Snapshot snapshot = this.snapshotFactory.get();){
                try {
                    if (this.hash != null && !snapshot.isValidHash(this.hash)) {
                        throw new LogCrashedException();
                    }
                    ArrayDeque<Pair<LogRecord, Throwable>> queue = new ArrayDeque<Pair<LogRecord, Throwable>>(this.recordCount);
                    boolean[] hasSkippedLined = new boolean[1];
                    boolean[] found = new boolean[1];
                    Predicate<String> matcher = this.pattern.matcher();
                    Status status = new Status(snapshot);
                    LvPredicateChecker predicateChecker = new LvPredicateChecker(snapshot.getLog());
                    Predicate<LogRecord> predicate = record -> {
                        if (this.timeLimitFomFilter != null && record.hasTime() && (this.backward ? record.getTime() < this.timeLimitFomFilter : record.getTime() > this.timeLimitFomFilter)) {
                            return false;
                        }
                        if (!this.timeOk((LogRecord)record)) {
                            return false;
                        }
                        Pair<LogRecord, Throwable> restRecord = predicateChecker.applyFilter((LogRecord)record, this.filter);
                        if (restRecord != null) {
                            if (queue.size() == this.recordCount) {
                                hasSkippedLined[0] = true;
                                queue.remove();
                            }
                            queue.add(restRecord);
                            if (matcher.test(record.getMessage())) {
                                found[0] = true;
                                return false;
                            }
                        }
                        return true;
                    };
                    int idCmp = this.start.getLogId().compareTo(snapshot.getLog().getId());
                    if (idCmp == 0) {
                        if (this.backward) {
                            snapshot.processRecordsBack(this.start.getLocalPosition(), true, predicate);
                        } else {
                            snapshot.processRecords(this.start.getLocalPosition(), true, predicate);
                        }
                    } else if (this.backward) {
                        long startTime = idCmp < 0 ? this.start.getTime() - 1L : this.start.getTime();
                        snapshot.processFromTimeBack(startTime, predicate);
                    } else {
                        long startTime = idCmp < 0 ? this.start.getTime() : this.start.getTime() + 1L;
                        snapshot.processFromTime(startTime, predicate);
                    }
                    this.listener.accept(new SearchResult(new RecordList((Collection<Pair<LogRecord, Throwable>>)queue), status, hasSkippedLined[0], found[0]));
                }
                catch (Throwable e) {
                    this.listener.accept(new SearchResult(e));
                }
            }
            catch (Throwable e) {
                LOG.error("Failed to load records", e);
            }
        });
        this.state = 1;
    }

    private boolean timeOk(LogRecord record) {
        long timeLimit = this.timeLimit;
        if (timeLimit <= 0L) {
            return true;
        }
        long time = record.getTime();
        if (time <= 0L) {
            return true;
        }
        if (this.backward) {
            return time > timeLimit;
        }
        return time < timeLimit;
    }

    @Override
    public synchronized void cancel() {
        if (this.state == 0) {
            throw new IllegalStateException("Loader is not started");
        }
        if (this.state == 1) {
            this.future.cancel(true);
            this.state = 2;
        }
    }

    @Override
    public void setTimeLimit(long limit) {
        this.timeLimit = limit;
    }
}

