/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.web.rmt;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.logviewer.utils.LvGsonUtils;
import com.logviewer.web.rmt.MethodCall;
import com.logviewer.web.rmt.Remote;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public class RemoteInvoker {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteInvoker.class);
    private static final Map<Class, Map<String, MethodDescriptor>> classCache = new ConcurrentHashMap<Class, Map<String, MethodDescriptor>>();

    private static Map<String, MethodDescriptor> getMethods(@NonNull Class handlerClass) {
        return classCache.computeIfAbsent(handlerClass, cls -> {
            HashMap<String, MethodDescriptor> methods = new HashMap<String, MethodDescriptor>();
            for (Method method : cls.getMethods()) {
                MethodDescriptor old;
                Remote remoteAnn = method.getAnnotation(Remote.class);
                if (remoteAnn == null || (old = methods.put(method.getName(), new MethodDescriptor(method))) == null) continue;
                throw new IllegalArgumentException("Duplicated method: " + method.getName());
            }
            return methods;
        });
    }

    public static Object call(@NonNull Object handler, @NonNull MethodCall call) throws Throwable {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Incoming message: " + call);
        }
        String methodName = call.getMethodName();
        MethodDescriptor descriptor = RemoteInvoker.getMethods(handler.getClass()).get(methodName);
        if (descriptor == null) {
            throw new IllegalArgumentException("Failed to find remote method '" + methodName + "' on class " + handler.getClass());
        }
        JsonObject argsJson = call.getArgs() == null ? new JsonObject() : call.getArgs();
        Object[] args = RemoteInvoker.paramsFromJsonObject(descriptor.method, argsJson);
        try {
            return descriptor.method.invoke(handler, args);
        }
        catch (InvocationTargetException e) {
            if (Stream.of(descriptor.method.getExceptionTypes()).anyMatch(expectedEx -> expectedEx.isInstance(e))) {
                throw e;
            }
            throw e.getTargetException();
        }
    }

    private static Object[] paramsFromJsonObject(Method method, JsonObject argsJson) {
        String paramName;
        Parameter[] parameters = method.getParameters();
        Object[] res = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            assert (parameter.isNamePresent());
            paramName = parameter.getName();
            JsonElement value = argsJson.get(paramName);
            if (value == null) continue;
            res[i] = LvGsonUtils.GSON.fromJson(value, parameter.getParameterizedType());
        }
        for (Map.Entry entry : argsJson.entrySet()) {
            paramName = (String)entry.getKey();
            if (!Stream.of(parameters).noneMatch(p -> p.getName().equals(paramName))) continue;
            throw new IllegalArgumentException("Unknown parameter [name=" + paramName + ", method=" + method);
        }
        return res;
    }

    private static class MethodDescriptor {
        private final Method method;
        private final Type returnType;

        public MethodDescriptor(Method method) {
            this.method = method;
            this.returnType = method.getGenericReturnType();
        }
    }
}

