/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.web.dto.events;

import com.logviewer.web.dto.RestRecord;
import com.logviewer.web.dto.events.StatusHolderEvent;
import com.logviewer.web.session.tasks.LoadNextResponse;
import com.logviewer.web.session.tasks.SearchTask;
import java.util.ArrayList;
import java.util.List;

public class EventSearchResponse
extends StatusHolderEvent {
    public final List<RestRecord> records;
    public final long foundIdx;
    public final boolean hasSkippedLine;
    public final long requestId;
    public final boolean hasNextLine;

    public EventSearchResponse(SearchTask.SearchResponse res, long stateVersion, long requestId, long foundIdx) {
        super(res.getStatuses(), stateVersion);
        this.records = RestRecord.fromPairList(res.getData());
        this.foundIdx = foundIdx;
        this.hasSkippedLine = res.hasSkippedLine();
        this.requestId = requestId;
        this.hasNextLine = true;
    }

    public EventSearchResponse(SearchTask.SearchResponse res, long stateVersion, long requestId) {
        this(res, stateVersion, requestId, -1L);
    }

    public EventSearchResponse(SearchTask.SearchResponse combRes, LoadNextResponse loadRes, long stateVersion, long requestId, boolean backward) {
        super(combRes.getStatuses(), stateVersion);
        this.requestId = requestId;
        this.hasSkippedLine = combRes.hasSkippedLine();
        List<RestRecord> beforeOccurrence = RestRecord.fromPairList(combRes.getData());
        List<RestRecord> afterOccurrence = RestRecord.fromPairList(loadRes.getData());
        this.records = new ArrayList<RestRecord>(beforeOccurrence.size() + afterOccurrence.size());
        if (backward) {
            this.records.addAll(afterOccurrence);
            this.records.addAll(beforeOccurrence);
            this.foundIdx = afterOccurrence.size();
        } else {
            this.records.addAll(beforeOccurrence);
            this.records.addAll(afterOccurrence);
            this.foundIdx = beforeOccurrence.size() - 1;
        }
        this.hasNextLine = loadRes.hasNextLine();
    }

    @Override
    public String getName() {
        return "onSearchResponse";
    }
}

