/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.utils;

import com.logviewer.utils.Destroyer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.springframework.lang.Nullable;

public class MultiListener<T> {
    private final Map<Destroyer, T> localListeners = new HashMap<Destroyer, T>();
    private final Callable<Destroyer> globalListenerCreator;
    private Destroyer onEmptyNotifier;

    public MultiListener(Callable<Destroyer> globalListenerCreator) {
        this.globalListenerCreator = globalListenerCreator;
    }

    @Nullable
    public synchronized Destroyer addListener(T listener) {
        Destroyer[] holder;
        Destroyer res;
        if (this.localListeners.isEmpty()) {
            try {
                this.onEmptyNotifier = this.globalListenerCreator.call();
            }
            catch (Exception e) {
                return null;
            }
        }
        holder = new Destroyer[]{res = () -> {
            Destroyer destroyer = null;
            MultiListener multiListener = this;
            synchronized (multiListener) {
                this.localListeners.remove(holder[0]);
                if (this.localListeners.isEmpty()) {
                    destroyer = this.onEmptyNotifier;
                    this.onEmptyNotifier = null;
                }
            }
            if (destroyer != null) {
                destroyer.close();
            }
        }};
        this.localListeners.put(res, listener);
        return res;
    }

    public synchronized List<T> getListeners() {
        return new ArrayList<T>(this.localListeners.values());
    }
}

