/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.utils;

import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public class LvTimer {
    private static final Logger LOG = LoggerFactory.getLogger(LvTimer.class);
    private final Map<Object, Boolean> uniqueTaskMap = new ConcurrentHashMap<Object, Boolean>();
    private final Timer timer = new Timer("log-viewer-timer", true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scheduleTask(@NonNull Object key, @NonNull Runnable task, long delay) {
        if (this.uniqueTaskMap.putIfAbsent(key, true) == null) {
            boolean scheduled = false;
            try {
                this.timer.schedule((TimerTask)new TimerTaskImpl(() -> {
                    this.uniqueTaskMap.remove(key);
                    task.run();
                }), delay);
                scheduled = true;
            }
            finally {
                if (!scheduled) {
                    this.uniqueTaskMap.remove(key);
                }
            }
            return true;
        }
        return false;
    }

    public void cancel() {
        this.timer.cancel();
    }

    public TimerTask schedule(Runnable run, long delay) {
        TimerTaskImpl task = new TimerTaskImpl(run);
        this.timer.schedule((TimerTask)task, delay);
        return task;
    }

    public void schedule(TimerTask timerTask, long delay) {
        this.timer.schedule(timerTask, delay);
    }

    private static class TimerTaskImpl
    extends TimerTask {
        private final Runnable run;

        public TimerTaskImpl(Runnable run) {
            this.run = run;
        }

        @Override
        public void run() {
            try {
                this.run.run();
            }
            catch (Throwable e) {
                LOG.error("Failed to execute timer task", e);
            }
        }
    }
}

