/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class LvDateUtils {
    public static final int[] DATE_FIELDS = new int[]{14, 13, 12, 11, 6, 2, 1};

    private LvDateUtils() {
    }

    public static boolean isDateFormatFull(@NonNull DateFormat dateFormat) {
        int firstExistField;
        Calendar c = Calendar.getInstance(dateFormat.getTimeZone());
        c.set(2020, 1, 25, 1, 1, 4);
        c.setTimeInMillis(333L);
        for (firstExistField = 0; firstExistField < DATE_FIELDS.length && !LvDateUtils.isFieldPresent(dateFormat, c, DATE_FIELDS[firstExistField], 1); ++firstExistField) {
        }
        if (firstExistField > 3) {
            return false;
        }
        for (int i = firstExistField; i < DATE_FIELDS.length; ++i) {
            if (LvDateUtils.isFieldPresent(dateFormat, c, DATE_FIELDS[i], 1)) continue;
            return false;
        }
        return !LvDateUtils.isFieldPresent(dateFormat, c, 10, 1) || LvDateUtils.isFieldPresent(dateFormat, c, 10, 12);
    }

    private static boolean isFieldPresent(@NonNull DateFormat dateFormat, Calendar c, int field, int incrementCount) {
        try {
            Date initDate = dateFormat.parse(dateFormat.format(c.getTime()));
            c.add(field, incrementCount);
            Date newDate = dateFormat.parse(dateFormat.format(c.getTime()));
            c.add(field, -incrementCount);
            return initDate.before(newDate);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static long toNanos(@NonNull Date date) {
        return LvDateUtils.toNanos(date.getTime());
    }

    public static long toNanos(@NonNull Instant instant) {
        return instant.getEpochSecond() * 1000000000L + (long)instant.getNano();
    }

    public static long toNanos(long millisecond) {
        if (millisecond <= 0L) {
            return millisecond;
        }
        if (millisecond > 3000000000000L) {
            throw new IllegalArgumentException("Not a milliseconds: " + millisecond);
        }
        return millisecond * 1000000L;
    }

    public static Instant toInstant(TemporalAccessor accessor, @Nullable TimeZone zone) {
        if (!accessor.isSupported(ChronoField.INSTANT_SECONDS)) {
            LocalDateTime localDateTime = LocalDateTime.from(accessor);
            return localDateTime.atZone(zone == null ? ZoneId.systemDefault() : zone.toZoneId()).toInstant();
        }
        return Instant.from(accessor);
    }
}

