/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.utils;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class GsonNanosecondsAdapter
extends TypeAdapter<Long> {
    private static final int TIME_LENGTH = 20;

    public void write(JsonWriter out, Long nanoseconds) throws IOException {
        if (nanoseconds == null || nanoseconds <= 0L) {
            out.nullValue();
            return;
        }
        String str = Long.toString(nanoseconds);
        if (str.length() < 20) {
            StringBuilder sb = new StringBuilder();
            for (int i = str.length(); i < 20; ++i) {
                sb.append('0');
            }
            sb.append(str);
            str = sb.toString();
        }
        assert (str.length() == 20);
        out.value(str);
    }

    public Long read(JsonReader in) throws IOException {
        JsonToken peek = in.peek();
        if (peek == JsonToken.NULL) {
            in.nextNull();
            return 0L;
        }
        String str = in.nextString();
        return Long.parseLong(str);
    }
}

