/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.services;

import com.logviewer.utils.RegexUtils;
import com.logviewer.utils.Utils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class PathPattern {
    private final Path prefix;
    private final Predicate<Path> fileFilter;
    private final Predicate<Path> dirFilter;

    public PathPattern(@Nullable Path prefix, @NonNull Predicate<Path> fileFilter, @NonNull Predicate<Path> dirFilter) {
        this.prefix = prefix;
        this.fileFilter = fileFilter;
        this.dirFilter = dirFilter;
    }

    @Nullable
    public Path getPrefix() {
        return this.prefix;
    }

    @NonNull
    public Predicate<Path> getFileFilter() {
        return this.fileFilter;
    }

    @NonNull
    public Predicate<Path> getDirFilter() {
        return this.dirFilter;
    }

    public boolean matchFile(@NonNull Path file) {
        if (this.prefix == null) {
            return this.fileFilter.test(file);
        }
        if (!file.startsWith(this.prefix)) {
            return false;
        }
        if (this.prefix.getNameCount() == file.getNameCount()) {
            return false;
        }
        Path relative = this.prefix.relativize(file);
        return this.fileFilter.test(relative);
    }

    public boolean matchDir(@NonNull Path dir) {
        if (this.prefix == null) {
            return this.dirFilter.test(dir);
        }
        if (this.prefix.startsWith(dir)) {
            return true;
        }
        if (!dir.startsWith(this.prefix)) {
            return false;
        }
        Path relative = dir.subpath(this.prefix.getNameCount(), dir.getNameCount());
        return this.dirFilter.test(relative);
    }

    public static PathPattern directory(@NonNull Path dir) {
        if (!dir.isAbsolute()) {
            throw new IllegalArgumentException("Path must be absolute: " + dir);
        }
        return new PathPattern(dir, p -> true, p -> true);
    }

    public static PathPattern file(@NonNull Path file) {
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException("Path must be absolute: " + file);
        }
        if (file.getParent() == null) {
            throw new IllegalArgumentException("Path is not a file: " + file);
        }
        Path fileName = file.getFileName();
        return new PathPattern(file.getParent(), f -> f.equals(fileName), dir -> false);
    }

    public static PathPattern fromPattern(@NonNull String pattern) {
        int tailStart;
        Path fixedPrefixPath;
        String fixedPrefix;
        if ((pattern = Utils.normalizePath(pattern)).endsWith("/")) {
            pattern = pattern + "**";
        }
        if ((fixedPrefix = PathPattern.extractFixedPrefix(pattern)) == null) {
            fixedPrefixPath = null;
        } else {
            Path path2 = Paths.get(fixedPrefix, new String[0]);
            Path path3 = fixedPrefixPath = path2.isAbsolute() ? path2 : null;
        }
        if (fixedPrefixPath == null) {
            Pattern p = RegexUtils.filePattern("**/" + pattern);
            Predicate<Path> filePredicate = path -> p.matcher(path.toString()).matches();
            return new PathPattern(null, filePredicate, path -> true);
        }
        if (fixedPrefix.equals("/")) {
            tailStart = 1;
        } else {
            assert (pattern.startsWith(fixedPrefix + '/'));
            tailStart = fixedPrefix.length() + 1;
        }
        ArrayList<Pattern> subdirs = new ArrayList<Pattern>();
        int idx = pattern.indexOf(47, tailStart);
        while (idx >= 0) {
            Pattern regex = RegexUtils.filePattern(pattern.substring(tailStart, idx));
            subdirs.add(regex);
            idx = pattern.indexOf(47, idx + 1);
        }
        if (pattern.endsWith("/**")) {
            subdirs.add(RegexUtils.filePattern(pattern.substring(tailStart)));
        }
        Predicate<Path> dirPredicate = path -> {
            String str = path.toString();
            for (Pattern subdir : subdirs) {
                if (!subdir.matcher(str).matches()) continue;
                return true;
            }
            return false;
        };
        Pattern filePattern = RegexUtils.filePattern(pattern.substring(tailStart));
        Predicate<Path> filePredicate = path -> filePattern.matcher(path.toString()).matches();
        return new PathPattern(fixedPrefixPath, filePredicate, dirPredicate);
    }

    @Nullable
    private static String extractFixedPrefix(@NonNull String pattern) {
        int firstStarIdx = pattern.indexOf(42);
        if (firstStarIdx < 0) {
            int slashIdx = pattern.lastIndexOf(47);
            if (slashIdx < 0) {
                return null;
            }
            return pattern.substring(0, slashIdx);
        }
        int slashIdx = pattern.lastIndexOf(47, firstStarIdx - 1);
        if (slashIdx < 0) {
            return null;
        }
        if (slashIdx == 0) {
            return "/";
        }
        return pattern.substring(0, slashIdx);
    }
}

