/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.impl;

import com.logviewer.api.LvFilterPanelStateProvider;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.lang.NonNull;

public class LvHoconFilterPanelStateProvider
implements LvFilterPanelStateProvider {
    public static final String CONFIG_PATH = "filters";
    private final Config lvHoconConfig;
    private volatile Map<String, String> filters;

    public LvHoconFilterPanelStateProvider(@NonNull Config lvHoconConfig) {
        this.lvHoconConfig = lvHoconConfig;
    }

    @Override
    @NonNull
    public Map<String, String> getFilterSets() {
        Map<String, String> res = this.filters;
        if (res == null) {
            if (this.lvHoconConfig.hasPath(CONFIG_PATH)) {
                res = new LinkedHashMap<String, String>();
                for (Map.Entry entry : this.lvHoconConfig.getObject(CONFIG_PATH).entrySet()) {
                    String filterSetName = (String)entry.getKey();
                    String json = ((ConfigValue)entry.getValue()).render(ConfigRenderOptions.concise());
                    res.put(filterSetName, json);
                }
            } else {
                res = Collections.emptyMap();
            }
            this.filters = res;
        }
        return res;
    }
}

