/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.formats.utils;

import com.logviewer.formats.utils.LvLayoutCustomTypeNode;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class LvLayoutNumberNode
extends LvLayoutCustomTypeNode {
    private final boolean canBeNegative;
    private final boolean canHaveFraction;

    public LvLayoutNumberNode(@NonNull String fieldName, @Nullable String fieldType) {
        this(fieldName, fieldType, false, false);
    }

    public LvLayoutNumberNode(@NonNull String fieldName, @Nullable String fieldType, boolean canBeNegative) {
        this(fieldName, fieldType, canBeNegative, false);
    }

    public LvLayoutNumberNode(@NonNull String fieldName, @Nullable String fieldType, boolean canBeNegative, boolean canHaveFraction) {
        super(fieldName, fieldType);
        this.canBeNegative = canBeNegative;
        this.canHaveFraction = canHaveFraction;
    }

    @Override
    public int parse(String s, int offset, int end) {
        if (offset == end) {
            return -2147483647;
        }
        char c = s.charAt(offset);
        if (c == '-' && this.canBeNegative) {
            if (++offset == end) {
                return -2147483647;
            }
            c = s.charAt(offset);
        }
        if (c < '0' || c > '9') {
            return -2147483647;
        }
        do {
            if (++offset != end) continue;
            return offset;
        } while ((c = s.charAt(offset)) >= '0' && c <= '9');
        if (this.canHaveFraction && c == '.' && offset + 1 < end && (c = s.charAt(offset + 1)) >= '0' && c <= '9') {
            offset += 2;
            while (offset < end && (c = s.charAt(offset)) >= '0' && c <= '9') {
                ++offset;
            }
        }
        return offset;
    }

    @Override
    public LvLayoutNumberNode clone() {
        return new LvLayoutNumberNode(this.getFieldName(), this.getFieldType(), this.canBeNegative, this.canHaveFraction);
    }
}

