/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.formats.utils;

import com.logviewer.formats.utils.FastDateTimeParser;
import com.logviewer.formats.utils.LvLayoutDateNode;
import com.logviewer.utils.LvDateUtils;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class LvLayoutLog4jISO8601Date
extends LvLayoutDateNode {
    private static final Pattern SUPPORTED_PATTERN = Pattern.compile("yyyy([-/])MM\\1dd(?:'T'|[_T ])HH:mm:ss(?<milliseconds>[,.]SSS(?:SSSSSS|SSS|S)?)?(?<timezone>z+|Z+|X+)?");
    private static final int[] MILLI_TO_NANO = new int[]{1000000, 100000, 10000, 1000, 100, 10, 1};
    private final int milliseconds;
    private final boolean hasTimezone;
    private transient Calendar calendar;
    private transient String currentTimezoneStr;

    public LvLayoutLog4jISO8601Date(boolean hasMilliseconds) {
        this(hasMilliseconds ? 3 : 0, false);
    }

    public LvLayoutLog4jISO8601Date(int milliseconds, boolean hasTimezone) {
        this.milliseconds = milliseconds;
        this.hasTimezone = hasTimezone;
    }

    @Override
    public int parse(String s, int offset, int end) {
        int nano;
        char a;
        char dateSeparator;
        int expectedLength = 19 + (this.milliseconds == 0 ? 0 : this.milliseconds + 1);
        if (end - offset < expectedLength) {
            return -2147483647;
        }
        int year = LvLayoutLog4jISO8601Date.readInt(s, offset, offset + 4);
        if (year < 1970 || year > 2034) {
            return -2147483647;
        }
        offset += 4;
        if ((dateSeparator = s.charAt(offset++)) != '-' && dateSeparator != '/') {
            return -2147483647;
        }
        int mm = LvLayoutLog4jISO8601Date.readInt(s, offset, offset + 2);
        if (mm < 1 || mm > 12) {
            return -2147483647;
        }
        offset += 2;
        if (s.charAt(offset++) != dateSeparator) {
            return -2147483647;
        }
        int dd = LvLayoutLog4jISO8601Date.readInt(s, offset, offset + 2);
        if (dd < 1 || dd > 31) {
            return -2147483647;
        }
        offset += 2;
        if ((a = s.charAt(offset++)) != 'T' && a != ' ' && a != '_') {
            return -2147483647;
        }
        int hh = LvLayoutLog4jISO8601Date.readInt(s, offset, offset + 2);
        if (hh < 0 || hh > 23) {
            return -2147483647;
        }
        offset += 2;
        if (s.charAt(offset++) != ':') {
            return -2147483647;
        }
        int min = LvLayoutLog4jISO8601Date.readInt(s, offset, offset + 2);
        if (min < 0 || min > 59) {
            return -2147483647;
        }
        offset += 2;
        if (s.charAt(offset++) != ':') {
            return -2147483647;
        }
        int sec = LvLayoutLog4jISO8601Date.readInt(s, offset, offset + 2);
        if (sec < 0 || sec > 59) {
            return -2147483647;
        }
        offset += 2;
        if (this.milliseconds > 0) {
            if ((a = s.charAt(offset++)) != ',' && a != '.') {
                return -2147483647;
            }
            nano = LvLayoutLog4jISO8601Date.readInt(s, offset, offset + this.milliseconds);
            if (nano < 0) {
                return -2147483647;
            }
            nano *= MILLI_TO_NANO[this.milliseconds - 3];
            offset += this.milliseconds;
        } else {
            nano = 0;
        }
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance();
            this.calendar.set(14, 0);
            if (this.zone != null) {
                this.calendar.setTimeZone(this.zone);
            }
        }
        if (this.hasTimezone && (offset = this.parseAndSetTimezone(s, offset, this.calendar)) < 0) {
            return -2147483647;
        }
        this.calendar.set(1, year);
        this.calendar.set(2, mm - 1);
        this.calendar.set(5, dd);
        this.calendar.set(11, hh);
        this.calendar.set(12, min);
        this.calendar.set(13, sec);
        this.currentDate = LvDateUtils.toNanos(this.calendar.getTimeInMillis()) + (long)nano;
        return offset;
    }

    private int parseAndSetTimezone(String s, int offset, Calendar calendar) {
        if (this.currentTimezoneStr != null && s.startsWith(this.currentTimezoneStr, offset)) {
            return offset + this.currentTimezoneStr.length();
        }
        if (offset >= s.length()) {
            return -1;
        }
        ParsePosition position = new ParsePosition(offset);
        TimeZone res = FastDateTimeParser.parseTimezone(s, position);
        if (res == null) {
            return -1;
        }
        calendar.setTimeZone(res);
        this.currentTimezoneStr = s.substring(offset, position.getIndex());
        return position.getIndex();
    }

    private static int readInt(String s, int offset, int end) {
        int res = 0;
        while (offset < end) {
            char a;
            if ((a = s.charAt(offset++)) < '0' || a > '9') {
                return -1;
            }
            res = res * 10 + (a - 48);
        }
        return res;
    }

    @Override
    public boolean isFull() {
        return true;
    }

    @Nullable
    public static LvLayoutLog4jISO8601Date fromPattern(@NonNull String pattern) {
        Matcher matcher = SUPPORTED_PATTERN.matcher(pattern);
        if (!matcher.matches()) {
            return null;
        }
        String ms = matcher.group("milliseconds");
        return new LvLayoutLog4jISO8601Date(ms == null ? 0 : ms.length() - 1, matcher.group("timezone") != null);
    }

    @Override
    public LvLayoutDateNode clone() {
        LvLayoutLog4jISO8601Date res = (LvLayoutLog4jISO8601Date)super.clone();
        res.calendar = null;
        res.currentTimezoneStr = null;
        return res;
    }
}

